package modules.text;

import com.vmx.Locale;
import com.vmx.StringEncoder;
import filemanager.TemplateTextField;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

/**
 * Форма перехода на позицию в тексте
 */
class frmSeek extends Form implements ItemStateListener
{
	protected Gauge gSeek;
	protected TextField tfLineNum;

	public frmSeek(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.GOTO_CMD));

		gSeek = new Gauge("0%", true, 100, 0);

		tfLineNum = new TextField(Locale.getString(this, Locale.LINE_NUMBER), "", 20, TextField.NUMERIC);

		append(gSeek);
		append(tfLineNum);

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));

		setCommandListener(cl);
		setItemStateListener(this);
	}

	public int getValue()
	{
		return gSeek.getValue();
	}

	public int getLineNum()
	{
		try
		{
			return Integer.parseInt(tfLineNum.getString());
		}
		catch(NumberFormatException nfe)
		{
			return 0;
		}
	}

	public void setValue(int value)
	{
		gSeek.setValue(value);
		gSeek.setLabel(Integer.toString(value) + "%"); // Integer.toString(scrStart) + "/" + Integer.toString(bdis.getCapacity());

		tfLineNum.setString("");
	}

	public void itemStateChanged(Item item)
	{
		gSeek.setLabel(Integer.toString(gSeek.getValue()) + "%");
	}
}

/**
 * Форма выбора шрифта
 */
class frmFont extends filemanager.frmFont
{
	public frmFont(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.FONT_CMD));

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));

		setCommandListener(cl);
	}
}

/**
 * Форма для выбора кодировки текста
 */
class frmEnc extends Form
{
	protected ChoiceGroup cgEnc;

	public frmEnc(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.ENCODING_CMD));

		cgEnc = new ChoiceGroup(null, ChoiceGroup.EXCLUSIVE);

		cgEnc.append(StringEncoder.ENC_NAME_UTF8, null);
		cgEnc.append(StringEncoder.ENC_NAME_UTF16N, null);
		cgEnc.append(StringEncoder.ENC_NAME_UTF16L, null);

		for(int i = 0; i < StringEncoder.encnames.length; i++)
		{
			cgEnc.append(StringEncoder.encnames[i], null);
		}

		append(cgEnc);

		addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));

		setCommandListener(cl);
	}

	public void setEncoding(int enc)
	{
		switch(enc)
		{
			case StringEncoder.ENC_UTF8:
				cgEnc.setSelectedIndex(0, true);
				break;

			case StringEncoder.ENC_UTF16N:
				cgEnc.setSelectedIndex(1, true);
				break;

			case StringEncoder.ENC_UTF16L:
				cgEnc.setSelectedIndex(2, true);
				break;

			default:
				cgEnc.setSelectedIndex(enc + 3, true);
		}
	}

	public int getEncoding()
	{
		switch(cgEnc.getSelectedIndex())
		{
			case 0:
				return StringEncoder.ENC_UTF8;

			case 1:
				return StringEncoder.ENC_UTF16N;

			case 2:
				return StringEncoder.ENC_UTF16L;

			default:
				return cgEnc.getSelectedIndex() - 3;
		}
	}
}

/**
 * Форма сохранения текста.
 * Отображается при выборе пункта меню "Сохранить как".
 */
class frmSave extends Form
{
	protected TextField tfFileName;
	protected ChoiceGroup cgEnc;
	protected ChoiceGroup cgBOM;

	public frmSave(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.SAVE_AS_CMD));

		tfFileName = new TemplateTextField(Locale.getString(this, Locale.NAME), "", 256, TextField.ANY);

		cgEnc = new ChoiceGroup(Locale.getString(this, Locale.ENCODING_CMD), ChoiceGroup.EXCLUSIVE);

		cgEnc.append(StringEncoder.ENC_NAME_UTF8, null);
		cgEnc.append(StringEncoder.ENC_NAME_UTF16N, null);
		cgEnc.append(StringEncoder.ENC_NAME_UTF16L, null);

		for(int i = 0; i < StringEncoder.encnames.length; i++)
		{
			cgEnc.append(StringEncoder.encnames[i], null);
		}

		cgBOM = new ChoiceGroup(null, ChoiceGroup.MULTIPLE);
		cgBOM.append(Locale.getString(this, Locale.USE_UTF_BOM), null);

		append(tfFileName);
		append(cgEnc);
		append(cgBOM);

		addCommand(new Command(Locale.getString(this, Locale.SAVE_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 2));

		setCommandListener(cl);
	}

	/**
	 * Установка имени файла.
	 */
	public void setFileName(String fname)
	{
		tfFileName.setString(fname);
	}

	/**
	 * Получение имени файла.
	 */
	public String getFileName()
	{
		return tfFileName.getString();
	}

	public void setEncoding(int enc)
	{
		switch(enc)
		{
			case StringEncoder.ENC_UTF8:
				cgEnc.setSelectedIndex(0, true);
				break;

			case StringEncoder.ENC_UTF16N:
				cgEnc.setSelectedIndex(1, true);
				break;

			case StringEncoder.ENC_UTF16L:
				cgEnc.setSelectedIndex(2, true);
				break;

			default:
				cgEnc.setSelectedIndex(enc + 3, true);
		}
	}

	public int getEncoding()
	{
		switch(cgEnc.getSelectedIndex())
		{
			case 0:
				return StringEncoder.ENC_UTF8;

			case 1:
				return StringEncoder.ENC_UTF16N;

			case 2:
				return StringEncoder.ENC_UTF16L;

			default:
				return cgEnc.getSelectedIndex() - 3;
		}
	}

	public void setUseBOM(boolean value)
	{
		cgBOM.setSelectedIndex(0, value);
	}

	public boolean getUseBOM()
	{
		return cgBOM.isSelected(0);
	}
}

class frmFind extends Form
{
	protected TextField tfText;
	protected TextField tfReplace;
	protected ChoiceGroup cgIgnoreCase;
	protected StringItem siMatches;

	public frmFind(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.MENU_SEARCH));

		tfText = new TemplateTextField(Locale.getString(this, Locale.FIND_CMD), "", TextOptions.textBufSize, TextField.ANY);
		tfReplace = new TemplateTextField(Locale.getString(this, Locale.REPLACE_WITH), "", TextOptions.textBufSize, TextField.ANY);

		cgIgnoreCase = new ChoiceGroup(null, Choice.MULTIPLE);
		cgIgnoreCase.append(Locale.getString(this, Locale.IGNORE_CASE), null);

		siMatches = new StringItem(null, "");

		append(tfText);
		append(tfReplace);
		append(cgIgnoreCase);
		append(siMatches);

		addCommand(new Command(Locale.getString(this, Locale.FIND_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.REPLACE_CMD), Command.OK, 2));
		addCommand(new Command(Locale.getString(this, Locale.REPLACE_ALL_CMD), Command.OK, 3));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 4));

		setCommandListener(cl);
	}

	public void setText(String text)
	{
		tfText.setString(text);
	}

	public String getText()
	{
		return tfText.getString();
	}

	public void setReplace(String replace)
	{
		tfReplace.setString(replace);
	}

	public String getReplace()
	{
		return tfReplace.getString();
	}

	public void setIgnoreCase(boolean ignoreCase)
	{
		cgIgnoreCase.setSelectedIndex(0, ignoreCase);
	}

	public boolean getIgnoreCase()
	{
		return cgIgnoreCase.isSelected(0);
	}

	public void setMatchesCount(int matches)
	{
		if(matches > 0)
		{
			siMatches.setText(Integer.toString(matches) + " " + Locale.getString(this, Locale.SEARCH_MATCHES));
		}
		else
		{
			siMatches.setText("");
		}
	}
}

class frmRegExp extends Form
{
	protected TextField tfText;
	protected TextField tfReplace;
	protected ChoiceGroup cgFlags;

	public frmRegExp(CommandListener cl)
	{
		super("");
		setTitle(Locale.getString(this, Locale.REG_EXP_CMD));

		tfText = new TemplateTextField(Locale.getString(this, Locale.FIND_CMD), "", TextOptions.textBufSize, TextField.ANY);
		tfReplace = new TemplateTextField(Locale.getString(this, Locale.REPLACE_WITH), "", TextOptions.textBufSize, TextField.ANY);

		cgFlags = new ChoiceGroup(null, Choice.MULTIPLE);
		
		cgFlags.append(Locale.getString(this, Locale.IGNORE_CASE), null);
		cgFlags.append(Locale.getString(this, Locale.RE_MATCH_MULTILINE), null);
		cgFlags.append(Locale.getString(this, Locale.RE_REPLACE_BACKREF), null);

		append(tfText);
		append(tfReplace);
		append(cgFlags);

		//addCommand(new Command(Locale.getString(this, Locale.REPLACE_CMD), Command.OK, 1));
		addCommand(new Command(Locale.getString(this, Locale.REPLACE_ALL_CMD), Command.OK, 2));
		addCommand(new Command(Locale.getString(this, Locale.BACK_CMD), Command.BACK, 3));

		setCommandListener(cl);
	}

	public void setText(String text)
	{
		tfText.setString(text);
	}

	public String getText()
	{
		return tfText.getString();
	}

	public void setReplace(String replace)
	{
		tfReplace.setString(replace);
	}

	public String getReplace()
	{
		return tfReplace.getString();
	}

	public void setFlags(int index, boolean ignoreCase)
	{
		cgFlags.setSelectedIndex(index, ignoreCase);
	}

	public boolean getFlags(int index)
	{
		return cgFlags.isSelected(index);
	}
}