package modules.text;

import com.one.AbstractFont;
import com.one.ModuleRegistry;
import com.one.OptionStorage;
import com.one.TextProcessor;
import com.vmx.Locale;
import filemanager.cvsContextMenu;
import filemanager.main;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;

public class TextOptions implements CommandListener, ItemStateListener, OptionStorage
{
	public static final int OPTIONS_VERSION = 2;

	public static final int MIN_TAB_SIZE = 1;
	public static final int MAX_TAB_SIZE = 12;
	
	public static int textFontFace = AbstractFont.FACE_SYSTEM;
	public static int textFontSize = AbstractFont.SIZE_SMALL;
	public static int textFontStyle = AbstractFont.STYLE_PLAIN;
	public static boolean showCR = false;
	public static boolean showLF = false;
	public static boolean accurateTAB = true;
	public static int textBoxTitle = 0;
	public static int textBufSize = 8192;
	public static boolean useUTFBOM = true;
	public static boolean textPageScroll = false;

	public static int tabSize = 6;
	public static String[] tabSpaces = TextProcessor.createSpaces(tabSize);

	protected Object parent;

	protected ChoiceGroup cgText;
	protected ChoiceGroup cgTextBoxTitle;
	protected Gauge gTabSize;
	protected TextField tfTextBufSize;

	public void showEditor(Object parent)
	{
		this.parent = parent;

		restoreOptions();

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));

		// *** Настройки текстового редактора ***
		cgText = new ChoiceGroup(Locale.getString(this, Locale.PREF_TEXT_SETUP), Choice.MULTIPLE);

		// Показывать CR
		cgText.append(Locale.getString(this, Locale.PREF_SHOW_CR), null);
		cgText.setSelectedIndex(0, showCR);

		// Показывать LF
		cgText.append(Locale.getString(this, Locale.PREF_SHOW_LF), null);
		cgText.setSelectedIndex(1, showLF);

		// Заменять табуляцию пробелами
		cgText.append(Locale.getString(this, Locale.PREF_ACCURATE_TAB), null);
		cgText.setSelectedIndex(2, accurateTAB);

		// Построчная / постраничная прокрутка
		cgText.append(Locale.getString(this, Locale.PREF_PAGE_SCROLL), null);
		cgText.setSelectedIndex(3, textPageScroll);

		// *** Заколовок текстового окна ***
		cgTextBoxTitle = new ChoiceGroup(Locale.getString(this, Locale.PREF_TEXTBOX_TITLE), Choice.EXCLUSIVE);

		cgTextBoxTitle.append(Locale.getString(this, Locale.NORMAL), null);
		cgTextBoxTitle.append(Locale.getString(this, Locale.TICKER), null);
		cgTextBoxTitle.append(Locale.getString(this, Locale.DISABLED), null);

		cgTextBoxTitle.setSelectedIndex(textBoxTitle, true);

		// *** Размер табуляции в пробелах ***
		gTabSize = new Gauge(null, true, MAX_TAB_SIZE - MIN_TAB_SIZE, tabSize - MIN_TAB_SIZE);
		itemStateChanged(gTabSize);

		// Размер текстового буфера
		tfTextBufSize = new TextField(Locale.getString(this, Locale.PREF_TEXT_BUFFER_SIZE), Integer.toString(textBufSize), 20, TextField.NUMERIC);

		form.append(cgText);
		form.append(cgTextBoxTitle);
		form.append(gTabSize);
		form.append(tfTextBufSize);

		form.addCommand(new Command(Locale.getString(this, Locale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(this, Locale.CANCEL_CMD), Command.BACK, 2));

		form.setCommandListener(this);
		form.setItemStateListener(this);

		main.dsp.setCurrent(form);
	}

	public void itemStateChanged(Item item)
	{
		if(item == gTabSize)
		{
			gTabSize.setLabel(Locale.getString(this, Locale.TAB_SIZE, Integer.toString(gTabSize.getValue() + MIN_TAB_SIZE)));
		}
	}

	public void commandAction(Command c, Displayable d)
	{
		if(c.getCommandType() == Command.OK)
		{
			showCR = cgText.isSelected(0);
			showLF = cgText.isSelected(1);
			accurateTAB = cgText.isSelected(2);
			textPageScroll = cgText.isSelected(3);

			textBoxTitle = cgTextBoxTitle.getSelectedIndex();

			textBufSize = Integer.parseInt(tfTextBufSize.getString());

			if(textBufSize < 1024)
			{
				textBufSize = 1024;
			}

			tabSize = gTabSize.getValue() + MIN_TAB_SIZE;
			tabSpaces = TextProcessor.createSpaces(tabSize);

			saveOptions();
		}

		main.dsp.setCurrent(parent);
	}

	public void restoreOptions()
	{
		try
		{
			byte[] data = ModuleRegistry.getModuleData(getClass().getName());

			if(data == null || data.length == 0)
			{
				return;
			}

			DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));

			if(dis.readInt() != OPTIONS_VERSION)
			{
				dis.close();
				return;
			}

			textFontFace = dis.readInt();
			textFontSize = dis.readInt();
			textFontStyle = dis.readInt();
			showCR = dis.readBoolean();
			showLF = dis.readBoolean();
			accurateTAB = dis.readBoolean();
			textBoxTitle = dis.readInt();
			textBufSize = dis.readInt();
			useUTFBOM = dis.readBoolean();
			textPageScroll = dis.readBoolean();

			tabSize = dis.readInt();
			tabSpaces = TextProcessor.createSpaces(tabSize);

			cvsContextMenu.readKeyConfig(cvsTextView.menuKeyConfig, dis);

			dis.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	public void saveOptions()
	{
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(baos);

			dos.writeInt(OPTIONS_VERSION);
			dos.writeInt(textFontFace);
			dos.writeInt(textFontSize);
			dos.writeInt(textFontStyle);
			dos.writeBoolean(showCR);
			dos.writeBoolean(showLF);
			dos.writeBoolean(accurateTAB);
			dos.writeInt(textBoxTitle);
			dos.writeInt(textBufSize);
			dos.writeBoolean(useUTFBOM);
			dos.writeBoolean(textPageScroll);
			dos.writeInt(tabSize);

			cvsContextMenu.writeKeyConfig(cvsTextView.menuKeyConfig, dos);

			byte[] data = baos.toByteArray();
			dos.close();

			ModuleRegistry.setModuleData(getClass().getName(), data);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}