package modules.viart;

import javax.microedition.lcdui.*;
import java.io.*;
import com.one.*;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.Palette;

public class DrawOptions extends Form implements CommandListener, ItemCommandListener, ItemStateListener
{
	protected TextField tfPrimaryColor;
	protected TextField tfSecondaryColor;
	protected ChoiceGroup cgFlags;
	protected TextField tfFileName;
	protected TextField tfPolyCount;
	protected TextField tfCount;
	protected TextField tfQuality;
	protected TextField tfExactCurColor;
	protected TextField tfAverageCurColor;
	protected TextField tfCursorX;
	protected TextField tfCursorY;
	
	public static int primaryColor = 0xFFFFFFFF;
	public static int secondaryColor = 0xFF000000;
	public static boolean dotted = false;
	public static boolean fill = false;
	public static String fileName  = "";
	public static int polyCount = 3;
	public static int count = 2;
	public static int quality = 2;
	public static int exactCurColor;
	public static int averageCurColor;
	public static double cursorX;
	public static double cursorY;
	
	protected Command cmdPalette = new Command(Locale.getString(this, CustomLocale.PALETTE_CMD), Command.ITEM, 1);
	protected TextField clritem;
	
	public DrawOptions()
	{
		super(null);
		setTitle(Locale.getString(this, CustomLocale.DRAW_OPTIONS_CMD));
		
		tfPrimaryColor = new TextField(Locale.getString(this, CustomLocale.PRIMARY_COLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfSecondaryColor = new TextField(Locale.getString(this, CustomLocale.SECONDARY_COLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfPrimaryColor.setItemCommandListener(this);
		tfSecondaryColor.setItemCommandListener(this);
		
		cgFlags = new ChoiceGroup(Locale.getString(this, CustomLocale.FLAGS), Choice.MULTIPLE);
		cgFlags.append(Locale.getString(this, CustomLocale.DOTTED), null);
		cgFlags.append(Locale.getString(this, CustomLocale.FILL), null);
		
		tfFileName = new TextField(Locale.getString(this, CustomLocale.FILE_NAME), "", 256, TextField.ANY);
		
		tfPolyCount = new TextField(Locale.getString(this, CustomLocale.POLY_COUNT), "", 20, TextField.NUMERIC);
		tfCount = new TextField(Locale.getString(this, CustomLocale.COUNT), "", 20, TextField.NUMERIC);
		tfQuality = new TextField(Locale.getString(this, CustomLocale.QUALITY), "", 20, TextField.NUMERIC);
		
		tfExactCurColor = new TextField(Locale.getString(this, CustomLocale.EXACT_CURCOLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfAverageCurColor = new TextField(Locale.getString(this, CustomLocale.AVERAGE_CURCOLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfCursorX = new TextField(Locale.getString(this, CustomLocale.CURSOR_X), "", 20, TextField.DECIMAL);
		tfCursorY = new TextField(Locale.getString(this, CustomLocale.CURSOR_Y), "", 20, TextField.DECIMAL);
		
		addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
		
		setItemStateListener(this);
	}
	
	public void reset()
	{
		//deleteAll();
		
		tfPrimaryColor.setString(Integer.toHexString(primaryColor).toUpperCase());
		
		try
		{
			tfPrimaryColor.removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		tfPrimaryColor.addCommand(cmdPalette);
		append(tfPrimaryColor);
		
		tfSecondaryColor.setString(Integer.toHexString(secondaryColor).toUpperCase());
		
		try
		{
			tfSecondaryColor.removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		tfSecondaryColor.addCommand(cmdPalette);
		append(tfSecondaryColor);
		
		cgFlags.setSelectedIndex(0, dotted);
		cgFlags.setSelectedIndex(1, fill);
		append(cgFlags);
		
		tfFileName.setString(fileName);
		append(tfFileName);
		
		tfPolyCount.setString(Integer.toString(polyCount));
		append(tfPolyCount);
		
		tfCount.setString(Integer.toString(count));
		append(tfCount);
		
		tfQuality.setString(Integer.toString(quality));
		append(tfQuality);
		
		tfExactCurColor.setString(Integer.toHexString(exactCurColor).toUpperCase());
		append(tfExactCurColor);
		
		tfAverageCurColor.setString(Integer.toHexString(averageCurColor).toUpperCase());
		append(tfAverageCurColor);
		
		tfCursorX.setString(Double.toString(cursorX));
		append(tfCursorX);
		
		tfCursorY.setString(Double.toString(cursorY));
		append(tfCursorY);
	}
	
	public void itemStateChanged(Item item)
	{
		if(item == tfPrimaryColor)
		{
			try
			{
				primaryColor = (int)Long.parseLong(tfPrimaryColor.getString(), 16);
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == tfSecondaryColor)
		{
			try
			{
				secondaryColor = (int)Long.parseLong(tfSecondaryColor.getString(), 16);
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == cgFlags)
		{
			dotted = cgFlags.isSelected(0);
			fill = cgFlags.isSelected(1);
		}
		else if(item == tfFileName)
		{
			fileName = tfFileName.getString();
		}
		else if(item == tfPolyCount)
		{
			polyCount = Integer.parseInt(tfPolyCount.getString());
			
			if(polyCount < 3)
			{
				polyCount = 3;
			}
			
			tfPolyCount.setString(Integer.toString(polyCount));
		}
		else if(item == tfCount)
		{
			count = Integer.parseInt(tfCount.getString());
			
			if(count < 2)
			{
				count = 2;
			}
			
			tfCount.setString(Integer.toString(count));
		}
		else if(item == tfQuality)
		{
			quality = Integer.parseInt(tfQuality.getString());
			
			if(quality < 2)
			{
				quality = 2;
			}
			
			tfQuality.setString(Integer.toString(quality));
		}
		else if(item == tfExactCurColor)
		{
			tfExactCurColor.setString(Integer.toHexString(exactCurColor).toUpperCase());
		}
		else if(item == tfAverageCurColor)
		{
			tfAverageCurColor.setString(Integer.toHexString(averageCurColor).toUpperCase());
		}
		else if(item == tfCursorX)
		{
			tfCursorX.setString(Double.toString(cursorX));
		}
		else if(item == tfCursorY)
		{
			tfCursorY.setString(Double.toString(cursorY));
		}
	}
	
	public void commandAction(Command c, Item item)
	{
		if(c == cmdPalette)
		{
			if(item instanceof TextField)
			{
				try
				{
					VIArt.showPalette(this, (int)Long.parseLong(((TextField)item).getString(), 16), false);
					clritem = (TextField)item;
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();
			
			if(po instanceof Palette)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showColorSelector(this, ((Palette)po).getColor());
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((Palette)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showDrawOptions(false);
						break;
				}
			}
			else if(po instanceof ColorSelector)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showPalette(this, ((ColorSelector)po).getColor(), true);
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((ColorSelector)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showDrawOptions(false);
						break;
				}
			}
		}
		else if(dp == this)
		{
			VIArt.showEdit(false);
		}
	}
	
	public static void writeOptions(DataOutputStream dos) throws IOException
	{
		dos.writeInt(primaryColor);
		dos.writeInt(secondaryColor);
		
		dos.writeBoolean(dotted);
		dos.writeBoolean(fill);
		
		dos.writeInt(polyCount);
		dos.writeInt(count);
		dos.writeInt(quality);
	}
	
	public static void readOptions(DataInputStream dis) throws IOException
	{
		primaryColor = dis.readInt();
		secondaryColor = dis.readInt();
		
		dotted = dis.readBoolean();
		fill = dis.readBoolean();
		
		polyCount = dis.readInt();
		count = dis.readInt();
		quality = dis.readInt();
	}
}