package modules.viart;

import javax.microedition.lcdui.*;
import com.one.vector.*;
import com.one.*;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.Palette;
import filemanager.TemplateTextField;

public class EffectEditor extends Form implements CommandListener, ItemCommandListener, ItemStateListener
{
	protected Effect effect;
	protected int type;
	
	protected TextField tfName;
	protected ChoiceGroup cgFlags;
	protected Item[] fields;
	
	protected int channel;
	protected int destchannel;
	protected int index;
	
	protected Command cmdPalette = new Command(Locale.getString(this, CustomLocale.PALETTE_CMD), Command.ITEM, 1);
	protected TextField clritem;
	
	public EffectEditor()
	{
		super(null);
		setTitle(Locale.getString(this, CustomLocale.EFFECT_EDITOR));
		
		tfName = new TemplateTextField(Locale.getString(this, CustomLocale.NAME), "", 256, TextField.ANY);
		
		cgFlags = new ChoiceGroup(Locale.getString(this, CustomLocale.FLAGS), Choice.MULTIPLE);
		cgFlags.append(Locale.getString(this, CustomLocale.HIDDEN), null);
		
		addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
		
		setItemStateListener(this);
	}
	
	public void setCurrentEffect(Effect effect)
	{
		this.effect = effect;
		
		//deleteAll();
		
		tfName.setString(effect.getName());
		append(tfName);
		
		cgFlags.setSelectedIndex(0, effect.isHidden());
		append(cgFlags);
		
		if(fields != null)
		{
			for(int i = 0; i < fields.length; i++)
			{
				try
				{
					fields[i].removeCommand(cmdPalette);
					removeCommand(cmdPalette);
				}
				catch(Exception e)
				{
				}
			}
		}
		
		type = Effect.effectType(effect);
		
		if(type == Effect.COLOR_REPLACE)
		{
			fields = new TextField[2];
			
			fields[0] = new TextField(Locale.getString(this, CustomLocale.START_COLOR), Integer.toHexString(((ColorReplace)effect).getStartColor()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[1] = new TextField(Locale.getString(this, CustomLocale.END_COLOR), Integer.toHexString(((ColorReplace)effect).getEndColor()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			
			fields[0].addCommand(cmdPalette);
			fields[1].addCommand(cmdPalette);
			
			fields[0].setItemCommandListener(this);
			fields[1].setItemCommandListener(this);
			
			append(fields[0]);
			append(fields[1]);
		}
		else if(type == Effect.AREA_FILL)
		{
			fields = new TextField[3];
			
			fields[0] = new TextField(Locale.getString(this, CustomLocale.COLOR), Integer.toHexString(((AreaFill)effect).getColor()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[1] = new TextField(VectorElement.getTransformPrefix(VectorElement.X, -1), Double.toString(((AreaFill)effect).getX()), 20, TextField.DECIMAL);
			fields[2] = new TextField(VectorElement.getTransformPrefix(VectorElement.Y, -1), Double.toString(((AreaFill)effect).getY()), 20, TextField.DECIMAL);
			
			fields[0].addCommand(cmdPalette);
			fields[0].setItemCommandListener(this);
			
			append(fields[0]);
			append(fields[1]);
			append(fields[2]);
		}
		else if(type == Effect.LINE_FILL)
		{
			fields = new TextField[1];
			
			fields[0] = new TextField(Locale.getString(this, CustomLocale.COLOR), Integer.toHexString(((LineFill)effect).getColor()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[0].addCommand(cmdPalette);
			fields[0].setItemCommandListener(this);
			
			append(fields[0]);
		}
		else if(type == Effect.CHANNEL_MATRIX)
		{
			fields = new Item[5];
			
			fields[0] = new Gauge(Locale.getString(this, CustomLocale.SOURCE_CHANNEL), true, 3, 0);
			fields[1] = new Gauge(Locale.getString(this, CustomLocale.DEST_CHANNEL), true, 3, 0);
			fields[2] = new TextField(Locale.getString(this, CustomLocale.FACTOR), "", 20, TextField.NUMERIC);
			fields[3] = new TextField(Locale.getString(this, CustomLocale.DIVISOR), "", 20, TextField.NUMERIC);
			fields[4] = new TextField(Locale.getString(this, CustomLocale.OFFSET), "", 20, TextField.NUMERIC);
			
			append(fields[0]);
			append(fields[1]);
			append(fields[2]);
			append(fields[3]);
			append(fields[4]);
			
			itemStateChanged(fields[0]);
			itemStateChanged(fields[1]);
		}
		else if(type == Effect.PIXEL_MATRIX)
		{
			fields = new Item[7];
			
			fields[0] = new Gauge(Locale.getString(this, CustomLocale.CHANNEL), true, 3, 0);
			fields[1] = new TextField(Locale.getString(this, CustomLocale.DIVISOR), "", 20, TextField.NUMERIC);
			fields[2] = new TextField(Locale.getString(this, CustomLocale.OFFSET), "", 20, TextField.NUMERIC);
			fields[3] = new TextField(Locale.getString(this, CustomLocale.SIZE), Integer.toString(((PixelMatrix)effect).getSize()), 2, TextField.NUMERIC);
			fields[4] = new Gauge(Locale.getString(this, CustomLocale.ROW), true, ((PixelMatrix)effect).getSize() - 1, ((PixelMatrix)effect).getSize() / 2);
			fields[5] = new Gauge(Locale.getString(this, CustomLocale.COLUMN), true, ((PixelMatrix)effect).getSize() - 1, ((PixelMatrix)effect).getSize() / 2);
			fields[6] = new TextField(Locale.getString(this, CustomLocale.FACTOR), "", 20, TextField.NUMERIC);
			
			append(fields[0]);
			append(fields[1]);
			append(fields[2]);
			append(fields[3]);
			append(fields[4]);
			append(fields[5]);
			append(fields[6]);
			
			itemStateChanged(fields[0]);
			itemStateChanged(fields[4]);
			itemStateChanged(fields[5]);
		}
		else if(type == Effect.BITWISE_FUNCTION)
		{
			fields = new Item[2];
			
			fields[0] = new ChoiceGroup(Locale.getString(this, CustomLocale.FX_TYPE), Choice.POPUP);
			((ChoiceGroup)fields[0]).append(BitwiseFunction.FUNCTIONS[0], null);
			((ChoiceGroup)fields[0]).append(BitwiseFunction.FUNCTIONS[1], null);
			((ChoiceGroup)fields[0]).append(BitwiseFunction.FUNCTIONS[2], null);
			((ChoiceGroup)fields[0]).setSelectedIndex(((BitwiseFunction)effect).getType(), true);
			
			fields[1] = new TextField(Locale.getString(this, CustomLocale.VALUE), Integer.toHexString(((BitwiseFunction)effect).getValue()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[1].addCommand(cmdPalette);
			fields[1].setItemCommandListener(this);
			
			append(fields[0]);
			append(fields[1]);
		}
		else if(type == Effect.GRADIENT_REPLACE)
		{
			fields = new Item[5];
			
			fields[0] = new TextField(Locale.getString(this, CustomLocale.START_COLOR) + " 1", Integer.toHexString(((GradientReplace)effect).getStartColorA()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[1] = new TextField(Locale.getString(this, CustomLocale.START_COLOR) + " 2", Integer.toHexString(((GradientReplace)effect).getStartColorB()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[2] = new TextField(Locale.getString(this, CustomLocale.END_COLOR) + " 1", Integer.toHexString(((GradientReplace)effect).getEndColorA()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			fields[3] = new TextField(Locale.getString(this, CustomLocale.END_COLOR) + " 2", Integer.toHexString(((GradientReplace)effect).getEndColorB()).toUpperCase(), 8, TextField.ANY | TextField.NON_PREDICTIVE);
			
			fields[0].addCommand(cmdPalette);
			fields[1].addCommand(cmdPalette);
			fields[2].addCommand(cmdPalette);
			fields[3].addCommand(cmdPalette);
			
			fields[0].setItemCommandListener(this);
			fields[1].setItemCommandListener(this);
			fields[2].setItemCommandListener(this);
			fields[3].setItemCommandListener(this);
			
			fields[4] = new TextField(Locale.getString(this, CustomLocale.MAX_DELTA), Integer.toString(((GradientReplace)effect).getMaxDelta()), 20, TextField.NUMERIC);
			
			append(fields[0]);
			append(fields[1]);
			append(fields[2]);
			append(fields[3]);
			append(fields[4]);
		}
	}
	
	public void itemStateChanged(Item item)
	{
		if(item == tfName)
		{
			effect.setName(tfName.getString());
			return;
		}
		else if(item == cgFlags)
		{
			effect.setHidden(cgFlags.isSelected(0));
			return;
		}
		
		if(type == Effect.COLOR_REPLACE)
		{
			if(item == fields[0])
			{
				try
				{
					((ColorReplace)effect).setStartColor((int)Long.parseLong(((TextField)fields[0]).getString(), 16));
				}
				catch(NumberFormatException nfe)
				{
				}
			}
			else if(item == fields[1])
			{
				try
				{
					((ColorReplace)effect).setEndColor((int)Long.parseLong(((TextField)fields[1]).getString(), 16));
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
		else if(type == Effect.AREA_FILL)
		{
			if(item == fields[0])
			{
				try
				{
					((AreaFill)effect).setColor((int)Long.parseLong(((TextField)fields[0]).getString(), 16));
				}
				catch(NumberFormatException nfe)
				{
				}
			}
			else if(item == fields[1] || item == fields[2])
			{
				((AreaFill)effect).setPosition(Double.parseDouble(((TextField)fields[1]).getString()), Double.parseDouble(((TextField)fields[2]).getString()));
			}
		}
		else if(type == Effect.LINE_FILL)
		{
			if(item == fields[0])
			{
				try
				{
					((LineFill)effect).setColor((int)Long.parseLong(((TextField)fields[0]).getString(), 16));
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
		else if(type == Effect.CHANNEL_MATRIX)
		{
			if(item == fields[0])
			{
				channel = ((Gauge)fields[0]).getValue();
				
				switch(channel)
				{
					case 0:
						fields[0].setLabel(Locale.getString(this, CustomLocale.SOURCE_CHANNEL) + ": " + Locale.getString(this, CustomLocale.ALPHA));
						break;
					
					case 1:
						fields[0].setLabel(Locale.getString(this, CustomLocale.SOURCE_CHANNEL) + ": " + Locale.getString(this, CustomLocale.RED));
						break;
					
					case 2:
						fields[0].setLabel(Locale.getString(this, CustomLocale.SOURCE_CHANNEL) + ": " + Locale.getString(this, CustomLocale.GREEN));
						break;
					
					case 3:
						fields[0].setLabel(Locale.getString(this, CustomLocale.SOURCE_CHANNEL) + ": " + Locale.getString(this, CustomLocale.BLUE));
						break;
				}
				
				((TextField)fields[2]).setString(Integer.toString(((ChannelMatrix)effect).getFactor(channel, destchannel)));
			}
			else if(item == fields[1])
			{
				destchannel = ((Gauge)fields[1]).getValue();
				
				switch(destchannel)
				{
					case 0:
						fields[1].setLabel(Locale.getString(this, CustomLocale.DEST_CHANNEL) + ": " + Locale.getString(this, CustomLocale.ALPHA));
						break;
					
					case 1:
						fields[1].setLabel(Locale.getString(this, CustomLocale.DEST_CHANNEL) + ": " + Locale.getString(this, CustomLocale.RED));
						break;
					
					case 2:
						fields[1].setLabel(Locale.getString(this, CustomLocale.DEST_CHANNEL) + ": " + Locale.getString(this, CustomLocale.GREEN));
						break;
					
					case 3:
						fields[1].setLabel(Locale.getString(this, CustomLocale.DEST_CHANNEL) + ": " + Locale.getString(this, CustomLocale.BLUE));
						break;
				}
				
				((TextField)fields[2]).setString(Integer.toString(((ChannelMatrix)effect).getFactor(channel, destchannel)));
				((TextField)fields[3]).setString(Integer.toString(((ChannelMatrix)effect).getDivisor(destchannel)));
				((TextField)fields[4]).setString(Integer.toString(((ChannelMatrix)effect).getOffset(destchannel)));
			}
			else if(item == fields[2])
			{
				((ChannelMatrix)effect).setFactor(channel, destchannel, Integer.parseInt(((TextField)fields[2]).getString()));
			}
			else if(item == fields[3])
			{
				((ChannelMatrix)effect).setDivisor(destchannel, Integer.parseInt(((TextField)fields[3]).getString()));
			}
			else if(item == fields[4])
			{
				((ChannelMatrix)effect).setOffset(destchannel, Integer.parseInt(((TextField)fields[4]).getString()));
			}
		}
		else if(type == Effect.PIXEL_MATRIX)
		{
			if(item == fields[0])
			{
				channel = ((Gauge)fields[0]).getValue();
				
				switch(channel)
				{
					case 0:
						fields[0].setLabel(Locale.getString(this, CustomLocale.CHANNEL) + ": " + Locale.getString(this, CustomLocale.ALPHA));
						break;
					
					case 1:
						fields[0].setLabel(Locale.getString(this, CustomLocale.CHANNEL) + ": " + Locale.getString(this, CustomLocale.RED));
						break;
					
					case 2:
						fields[0].setLabel(Locale.getString(this, CustomLocale.CHANNEL) + ": " + Locale.getString(this, CustomLocale.GREEN));
						break;
					
					case 3:
						fields[0].setLabel(Locale.getString(this, CustomLocale.CHANNEL) + ": " + Locale.getString(this, CustomLocale.BLUE));
						break;
				}
				
				((TextField)fields[1]).setString(Integer.toString(((PixelMatrix)effect).getDivisor(channel)));
				((TextField)fields[2]).setString(Integer.toString(((PixelMatrix)effect).getOffset(channel)));
				
				((TextField)fields[6]).setString(Integer.toString(((PixelMatrix)effect).getFactor(channel, index)));
			}
			else if(item == fields[1])
			{
				((PixelMatrix)effect).setDivisor(channel, Integer.parseInt(((TextField)fields[1]).getString()));
			}
			else if(item == fields[2])
			{
				((PixelMatrix)effect).setOffset(channel, Integer.parseInt(((TextField)fields[2]).getString()));
			}
			else if(item == fields[3])
			{
				((PixelMatrix)effect).setSize(Integer.parseInt(((TextField)fields[3]).getString()));
				((TextField)fields[3]).setString(Integer.toString(((PixelMatrix)effect).getSize()));
				
				((Gauge)fields[4]).setMaxValue(((PixelMatrix)effect).getSize() - 1);
				((Gauge)fields[5]).setMaxValue(((PixelMatrix)effect).getSize() - 1);
				
				((Gauge)fields[4]).setValue(((PixelMatrix)effect).getSize() / 2);
				((Gauge)fields[5]).setValue(((PixelMatrix)effect).getSize() / 2);
				
				((TextField)fields[1]).setString(Integer.toString(((PixelMatrix)effect).getDivisor(channel)));
				((TextField)fields[2]).setString(Integer.toString(((PixelMatrix)effect).getOffset(channel)));
				
				itemStateChanged(fields[4]);
				itemStateChanged(fields[5]);
			}
			else if(item == fields[4])
			{
				fields[4].setLabel(Locale.getString(this, CustomLocale.ROW) + ": " + Integer.toString(((Gauge)fields[4]).getValue() - ((PixelMatrix)effect).getDelta()));
				
				index = ((Gauge)fields[4]).getValue() + ((PixelMatrix)effect).getSize() * ((Gauge)fields[5]).getValue();
				((TextField)fields[6]).setString(Integer.toString(((PixelMatrix)effect).getFactor(channel, index)));
			}
			else if(item == fields[5])
			{
				fields[5].setLabel(Locale.getString(this, CustomLocale.COLUMN) + ": " + Integer.toString(((Gauge)fields[5]).getValue() - ((PixelMatrix)effect).getDelta()));
				
				index = ((Gauge)fields[4]).getValue() + ((PixelMatrix)effect).getSize() * ((Gauge)fields[5]).getValue();
				((TextField)fields[6]).setString(Integer.toString(((PixelMatrix)effect).getFactor(channel, index)));
			}
			else if(item == fields[6])
			{
				((PixelMatrix)effect).setFactor(channel, index, Integer.parseInt(((TextField)fields[6]).getString()));
			}
		}
		else if(type == Effect.BITWISE_FUNCTION)
		{
			if(item == fields[0])
			{
				((BitwiseFunction)effect).setType(((ChoiceGroup)fields[0]).getSelectedIndex());
			}
			else if(item == fields[1])
			{
				((BitwiseFunction)effect).setValue((int)Long.parseLong(((TextField)fields[1]).getString(), 16));
			}
		}
		else if(type == Effect.GRADIENT_REPLACE)
		{
			if(item == fields[0] || item == fields[1])
			{
				((GradientReplace)effect).setStartColors((int)Long.parseLong(((TextField)fields[0]).getString(), 16), (int)Long.parseLong(((TextField)fields[1]).getString(), 16));
			}
			else if(item == fields[2] || item == fields[3])
			{
				((GradientReplace)effect).setEndColors((int)Long.parseLong(((TextField)fields[2]).getString(), 16), (int)Long.parseLong(((TextField)fields[3]).getString(), 16));
			}
			else if(item == fields[4])
			{
				((GradientReplace)effect).setMaxDelta(Integer.parseInt(((TextField)fields[4]).getString()));
			}
		}
	}
	
	public void commandAction(Command c, Item item)
	{
		if(c == cmdPalette)
		{
			if(item instanceof TextField)
			{
				try
				{
					VIArt.showPalette(this, (int)Long.parseLong(((TextField)item).getString(), 16), false);
					clritem = (TextField)item;
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();
			
			if(po instanceof Palette)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showColorSelector(this, ((Palette)po).getColor());
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((Palette)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showEffectEditor(null);
						break;
				}
			}
			else if(po instanceof ColorSelector)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showPalette(this, ((ColorSelector)po).getColor(), true);
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((ColorSelector)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showEffectEditor(null);
						break;
				}
			}
		}
		else if(dp == this)
		{
			VIArt.showObjectBrowser(ObjectBrowser.VIEW_CURRENT);
		}
	}
}