package modules.viart;

import com.one.FileSystemObject;
import javax.microedition.lcdui.*;
import com.one.vector.VectorElement;
import com.vmx.Locale;
import filemanager.ListMenu;
import filemanager.ListStateListener;

public class FileBrowser implements CommandListener, ListStateListener
{
	public static final int MODE_BROWSE = 0;
	public static final int MODE_OPEN = 1;
	public static final int MODE_SAVE = 2;
	
	protected FileSystemObject fso;
	protected FileNameListener listener;
	protected ListMenu list;
	protected int mode;
	protected String prevfile;
	
	protected Command cmdView, cmdOpen, cmdSave, cmdExportSVG, cmdExportPNG, cmdExportGIF, cmdBack, cmdCancel;
	
	public FileBrowser(FileSystemObject fso, ListMenu list)
	{
		this.fso = fso;
		this.list = list;
		
		cmdView = new Command(Locale.getString(this, CustomLocale.VIEW_CMD), Command.ITEM, 1);
		cmdOpen = new Command(Locale.getString(this, CustomLocale.OPEN_CMD), Command.OK, 2);
		cmdSave = new Command(Locale.getString(this, CustomLocale.SAVE_CMD), Command.OK, 2);
		cmdExportSVG = new Command(Locale.getString(this, CustomLocale.EXPORT_SVG_CMD), Command.OK, 3);
		cmdExportPNG = new Command(Locale.getString(this, CustomLocale.EXPORT_PNG_CMD), Command.OK, 4);
		cmdExportGIF = new Command(Locale.getString(this, CustomLocale.EXPORT_GIF_CMD), Command.OK, 5);
		cmdBack = new Command(Locale.getString(this, CustomLocale.BACK_CMD), Command.BACK, 6);
		cmdCancel = new Command(Locale.getString(this, CustomLocale.CANCEL_CMD), Command.CANCEL, 7);
	}
	
	public void init(FileNameListener listener, int mode)
	{
		this.listener = listener;
		this.mode = mode;
		
		if(mode == MODE_OPEN)
		{
			list.setTitle(Locale.getString(this, CustomLocale.OPEN_CMD));
		}
		else if(mode == MODE_SAVE)
		{
			list.setTitle(Locale.getString(this, CustomLocale.SAVE_CMD));
		}
		else
		{
			list.setTitle(Locale.getString(this, CustomLocale.BROWSE_CMD));
		}
		
		if(fso.getCurrentPath() != null)
		{
			list.setSubTitle(fso.getCurrentPath(), true);
		}
		else
		{
			list.setSubTitle(Locale.getString(this, CustomLocale.ROOT), false);
		}
		
		list.deleteAll();
		list.append(FileSystemObject.sortFileList(fso.list()));
		list.select(prevfile);
		
		list.removeAllCommands();
		list.addCommand(cmdBack);
		list.addCommand(cmdCancel);
		
		if(list.getString(list.getSelectedIndex()).endsWith("/"))
		{
			list.addCommand(cmdView);
		}
		
		if(mode == MODE_SAVE)
		{
			if(fso.getCurrentPath() != null)
			{
				list.addCommand(cmdSave);
				list.addCommand(cmdExportSVG);
				list.addCommand(cmdExportPNG);
				list.addCommand(cmdExportGIF);
			}
		}
		else
		{
			list.addCommand(cmdOpen);
		}
		
		list.setCommandListener(this);
		list.setStateListener(this);
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(c == cmdView)
		{
			fso.changeDir(list.getString(list.getSelectedIndex()));
			list.deleteAll();
			list.append(FileSystemObject.sortFileList(fso.list()));
			list.setSubTitle(fso.getCurrentPath(), true);
			
			if(mode == MODE_SAVE)
			{
				list.addCommand(cmdSave);
				list.addCommand(cmdExportSVG);
				list.addCommand(cmdExportPNG);
				list.addCommand(cmdExportGIF);
			}
		}
		else if(c == cmdOpen)
		{
			prevfile = list.getString(list.getSelectedIndex());
			
			if(mode == MODE_OPEN)
			{
				VIArt.openFile(fso.getCurrentPath() + list.getString(list.getSelectedIndex()));
			}
			else if(listener != null)
			{
				listener.fileNameAcquired(fso.getCurrentPath() + list.getString(list.getSelectedIndex()));
			}
		}
		else if(c == cmdSave ||
		        c == cmdExportSVG ||
		        c == cmdExportPNG ||
		        c == cmdExportGIF)
		{
			int format;
			
			if(c == cmdExportSVG)
			{
				format = 1;
			}
			else if(c == cmdExportPNG)
			{
				format = 2;
			}
			else if(c == cmdExportGIF)
			{
				format = 3;
			}
			else
			{
				format = 0;
			}
			
			if(list.size() > 0)
			{
				String s = list.getString(list.getSelectedIndex());
				
				if(s.endsWith("/"))
				{
					VIArt.showSaveFileName(fso.getCurrentPath() + VectorElement.defaultName(), format);
				}
				else
				{
					VIArt.showSaveFileName(fso.getCurrentPath() + s, format);
				}
			}
			else
			{
				VIArt.showSaveFileName(fso.getCurrentPath() + VectorElement.defaultName(), format);
			}
		}
		else if(c == cmdBack)
		{
			String s = fso.getCurrentPath();
			
			if(s == null)
			{
				if(mode == MODE_BROWSE && listener != null)
				{
					listener.fileNameAcquired(null);
				}
				else
				{
					VIArt.showMainMenu();
				}
			}
			else
			{
				fso.changeDir(null);
				list.deleteAll();
				list.append(FileSystemObject.sortFileList(fso.list()));
				
				s = s.substring(0, s.length() - 1);
				s = s.substring(s.lastIndexOf('/') + 1) + "/";
				list.select(s);
				
				if(fso.getCurrentPath() != null)
				{
					list.setSubTitle(fso.getCurrentPath(), true);
				}
				else
				{
					list.setSubTitle(Locale.getString(this, CustomLocale.ROOT), false);
					list.removeCommand(cmdSave);
					list.removeCommand(cmdExportSVG);
					list.removeCommand(cmdExportPNG);
					list.removeCommand(cmdExportGIF);
				}
			}
		}
		else if(c == cmdCancel)
		{
			if(mode == MODE_BROWSE && listener != null)
			{
				listener.fileNameAcquired(null);
			}
			else
			{
				VIArt.showMainMenu();
			}
		}
	}
	
	public void listStateChanged(ListMenu list, int action)
	{
		if(list.size() > 0)
		{
			String s = list.getString(list.getSelectedIndex());
			
			if(s.endsWith("/"))
			{
				list.addCommand(cmdView);
			}
			else
			{
				list.removeCommand(cmdView);
			}
			
			if(mode != MODE_SAVE)
			{
				list.addCommand(cmdOpen);
			}
		}
		else
		{
			list.removeCommand(cmdView);
			list.removeCommand(cmdOpen);
		}
	}
}