package modules.viart;

import javax.microedition.lcdui.*;
import com.one.vector.*;
import com.one.*;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.Palette;
import filemanager.TemplateTextField;

public class ImageProperties extends Form implements CommandListener, ItemCommandListener, ItemStateListener
{
	protected VectorImage image;
	
	protected TextField tfTitle, tfDescription;
	protected TextField tfNativeWidth, tfNativeHeight;
	protected TextField tfOffsetX, tfOffsetY;
	protected TextField tfScaleX, tfScaleY;
	protected TextField tfBackColor;
	protected ChoiceGroup cgColorMode;
	protected TextField tfFPS, tfMaxFrame, tfLoopCount;
	
	protected Command cmdPalette = new Command(Locale.getString(this, CustomLocale.PALETTE_CMD), Command.ITEM, 1);
	protected TextField clritem;
	
	protected boolean sizechanged;
	
	public ImageProperties()
	{
		super(null);
		setTitle(Locale.getString(this, CustomLocale.IMAGE_PROPERTIES_CMD));
		
		tfTitle = new TemplateTextField(Locale.getString(this, CustomLocale.TITLE), "", 256, TextField.ANY);
		tfDescription = new TemplateTextField(Locale.getString(this, CustomLocale.DESCRIPTION), "", 4096, TextField.ANY);
		
		tfNativeWidth = new TextField(Locale.getString(this, CustomLocale.NATIVE_WIDTH), "", 20, TextField.NUMERIC);
		tfNativeHeight = new TextField(Locale.getString(this, CustomLocale.NATIVE_HEIGHT), "", 20, TextField.NUMERIC);
		
		tfOffsetX = new TextField(Locale.getString(this, CustomLocale.OFFSET_X), "", 20, TextField.DECIMAL);
		tfOffsetY = new TextField(Locale.getString(this, CustomLocale.OFFSET_Y), "", 20, TextField.DECIMAL);
		tfScaleX = new TextField(Locale.getString(this, CustomLocale.SCALE_X), "", 20, TextField.DECIMAL);
		tfScaleY = new TextField(Locale.getString(this, CustomLocale.SCALE_Y), "", 20, TextField.DECIMAL);
		
		tfBackColor = new TextField(Locale.getString(this, CustomLocale.BACK_COLOR), "", 20, TextField.ANY | TextField.NON_PREDICTIVE);
		tfBackColor.setItemCommandListener(this);
		
		cgColorMode = new ChoiceGroup(Locale.getString(this, CustomLocale.COLOR_MODE), Choice.MULTIPLE);
		cgColorMode.append(Locale.getString(this, CustomLocale.USE_COLOR), null);
		cgColorMode.append(Locale.getString(this, CustomLocale.USE_BACK), null);
		
		tfFPS = new TextField(Locale.getString(this, CustomLocale.FPS), "", 20, TextField.DECIMAL);
		tfMaxFrame = new TextField(Locale.getString(this, CustomLocale.MAX_FRAME), "", 20, TextField.NUMERIC);
		tfLoopCount = new TextField(Locale.getString(this, CustomLocale.LOOP_COUNT), "", 20, TextField.NUMERIC);
		
		addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
		
		setItemStateListener(this);
	}
	
	public void setCurrentImage(VectorImage image)
	{
		this.image = image;
		
		//deleteAll();
		
		tfTitle.setString(image.getTitle());
		tfDescription.setString(image.getDescription());
		
		tfNativeWidth.setString(Integer.toString(image.getNativeWidth()));
		tfNativeHeight.setString(Integer.toString(image.getNativeHeight()));
		
		tfOffsetX.setString(Double.toString(image.param[0]));
		tfOffsetY.setString(Double.toString(image.param[1]));
		tfScaleX.setString(Double.toString(image.param[4]));
		tfScaleY.setString(Double.toString(image.param[5]));
		
		tfBackColor.setString(Integer.toHexString(image.getBackColor()).toUpperCase());
		
		try
		{
			tfBackColor.removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		tfBackColor.addCommand(cmdPalette);
		
		cgColorMode.setSelectedIndex(0, image.getUseColor());
		cgColorMode.setSelectedIndex(1, image.getUseBack());
		
		tfFPS.setString(Double.toString(image.getFPS()));
		tfMaxFrame.setString(Integer.toString(image.getMaxFrame()));
		tfLoopCount.setString(Integer.toString(image.getLoopCount()));
		
		append(tfTitle);
		append(tfDescription);
		append(tfNativeWidth);
		append(tfNativeHeight);
		append(tfOffsetX);
		append(tfOffsetY);
		append(tfScaleX);
		append(tfScaleY);
		append(tfBackColor);
		append(cgColorMode);
		append(tfFPS);
		append(tfMaxFrame);
		append(tfLoopCount);
		
		sizechanged = false;
	}
	
	public void itemStateChanged(Item item)
	{
		if(item == tfTitle)
		{
			image.setTitle(tfTitle.getString());
		}
		else if(item == tfDescription)
		{
			image.setDescription(tfDescription.getString());
		}
		else if(item == tfNativeWidth || item == tfNativeHeight)
		{
			image.setNativeSize(Integer.parseInt(tfNativeWidth.getString()), Integer.parseInt(tfNativeHeight.getString()));
			sizechanged = true;
		}
		else if(item == tfOffsetX)
		{
			image.param[0] = Double.parseDouble(tfOffsetX.getString());
		}
		else if(item == tfOffsetY)
		{
			image.param[1] = Double.parseDouble(tfOffsetY.getString());
		}
		else if(item == tfScaleX)
		{
			image.param[4] = Double.parseDouble(tfScaleX.getString());
		}
		else if(item == tfScaleY)
		{
			image.param[5] = Double.parseDouble(tfScaleY.getString());
		}
		else if(item == tfBackColor)
		{
			try
			{
				image.setBackColor((int)Long.parseLong(tfBackColor.getString(), 16));
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == cgColorMode)
		{
			image.setUseColor(cgColorMode.isSelected(0));
			image.setUseBack(cgColorMode.isSelected(1));
		}
		else if(item == tfFPS)
		{
			image.setFPS(Double.parseDouble(tfFPS.getString()));
		}
		else if(item == tfMaxFrame)
		{
			image.setMaxFrame(Integer.parseInt(tfMaxFrame.getString()));
		}
		else if(item == tfLoopCount)
		{
			image.setLoopCount(Integer.parseInt(tfLoopCount.getString()));
		}
	}
	
	public void commandAction(Command c, Item item)
	{
		if(c == cmdPalette)
		{
			if(item instanceof TextField)
			{
				try
				{
					VIArt.showPalette(this, (int)Long.parseLong(((TextField)item).getString(), 16), false);
					clritem = (TextField)item;
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();
			
			if(po instanceof Palette)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showColorSelector(this, ((Palette)po).getColor());
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((Palette)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showImageProperties(null);
						break;
				}
			}
			else if(po instanceof ColorSelector)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showPalette(this, ((ColorSelector)po).getColor(), true);
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((ColorSelector)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showImageProperties(null);
						break;
				}
			}
		}
		else if(dp == this)
		{
			VIArt.setEditScaleMode(!sizechanged);
			VIArt.showEdit(false);
		}
	}
}