package modules.viart;

import com.one.AbstractFont;
import com.one.ExtGraphics;
import com.vmx.Locale;
import com.vmx.gkcCanvas;
import filemanager.ColorScheme;
import filemanager.LineEffect;
import filemanager.MenuListener;
import filemanager.options;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class MainMenu extends gkcCanvas implements Runnable
{
	public static final String TITLE = "VIArt";
	public static final String SUBTITLE = "The Art of Vector Animation";
	
	public static final int MENU_MAIN = 0;
	
	protected AbstractFont font, smallfont, largefont;
	protected int width, height;
	protected int header;
	protected int[] ttlpos = new int[4];
	
	protected MenuListener listener;
	protected int type;
	protected int[][] pos;
	protected int clipx, clipy, clipw, cliph;
	protected int selindex;
	protected boolean hkmode;
	
	protected LineEffect lfx;
	protected boolean isshown = false;
	protected long delay;
	protected Thread t;
	
	protected static Random rnd = new Random();
	
	public static int rndFromRange(int from, int to)
	{
		if(to == from)
		{
			return from;
		}
		
		return (rnd.nextInt() >>> 1) % (to - from) + from;
	}
	
	public MainMenu()
	{
		setFullScreenMode(true);
		
		width = getWidth();
		height = getHeight();
		
		lfx = new LineEffect(1, 1, width - 2, height - 2);
		delay = lfx.getDelay();
		
		font = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_SMALL);
		
		smallfont = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_SMALL);
		largefont = AbstractFont.getFont(AbstractFont.FACE_SYSTEM, AbstractFont.STYLE_PLAIN, AbstractFont.SIZE_LARGE);
		
		header = largefont.getHeight() + smallfont.getHeight() * 2;
		
		ttlpos[0] = (width - largefont.stringWidth(TITLE)) / 2;
		ttlpos[1] = 0;
		ttlpos[2] = (width - smallfont.stringWidth(SUBTITLE)) / 2;
		ttlpos[3] = largefont.getHeight();
		
		setType(MENU_MAIN);
	}
	
	public void setType(int newtype)
	{
		if(newtype < 0 || newtype >= menu.length)
		{
			return;
		}
		
		type = newtype;
		
		pos = new int[menu[type].length][6];
		
		selindex = 0;
	}
	
	public void randomize()
	{
		int lineheight = (height - header) / menu[type].length;
		int fontheight = font.getHeight();
		int itemwidth;
		
		for(int i = 0; i < menu[type].length; i++)
		{
			itemwidth = font.stringWidth(Locale.getString(this, menu[type][i]));
			
			pos[i][2] = itemwidth + fontheight;
			pos[i][3] = fontheight + fontheight / 2;
			pos[i][0] = rndFromRange(0, width - pos[i][2]);
			pos[i][1] = header + lineheight * i + rndFromRange(0, lineheight - pos[i][3]);
			pos[i][4] = pos[i][0] + (pos[i][2] - itemwidth) / 2;
			pos[i][5] = pos[i][1] + (pos[i][3] - fontheight) / 2;
		}
	}
	
	public void setMenuListener(MenuListener listener)
	{
		this.listener = listener;
	}
	
	public void keyPressed(int keyCode)
	{
		if(hkmode)
		{
			hkmode = false;
			
			if(keyCode == KEY_STAR)
			{
				VIArt.showMemoryMonitor(this);
			}
			else
			{
				int index = keyCode - KEY_NUM1;
				
				if(index >= 0 && index < menu[type].length && listener != null)
				{
					listener.menuAction(menu[type][index]);
				}
			}
			
			return;
		}
		
		keyCode = translateKey(keyCode);
		
		if(keyCode == KEY_FIRE)
		{
			if(listener != null)
			{
				listener.menuAction(menu[type][selindex]);
			}
		}
		else if(keyCode == KEY_UP ||
		        keyCode == KEY_LEFT)
		{
			if(--selindex < 0)
			{
				selindex = menu[type].length - 1;
			}
		}
		else if(keyCode == KEY_DOWN ||
		        keyCode == KEY_RIGHT)
		{
			if(++selindex >= menu[type].length)
			{
				selindex = 0;
			}
		}
		else if(keyCode == KEY_POUND)
		{
			hkmode = !hkmode;
		}
		
		if(isshown && options.noEffects)
		{
			repaint();
		}
	}
	
	public void showNotify()
	{
		randomize();
		
		isshown = true;
		
		if(!options.noEffects)
		{
			(t = new Thread(this)).start();
		}
	}
	
	public void hideNotify()
	{
		isshown = false;
		t = null;
	}
	
	public void paint(ExtGraphics g)
	{
		g.setClip(0, 0, width, height);
		
		g.setColor(ColorScheme.colors[ColorScheme.back1]);
		g.fillRect(0, 0, width, height);
		
		if(!options.noEffects)
		{
			g.setColor(ColorScheme.colors[ColorScheme.ltborder]);
			lfx.drawLines(g);
		}
		
		g.setFont(largefont);
		
		if(!options.noEffects)
		{
			g.setColor(ColorScheme.colors[ColorScheme.back1]);
			LineEffect.drawTextOutline(g, TITLE, ttlpos[0], ttlpos[1]);
		}
		
		g.setColor(ColorScheme.colors[ColorScheme.fore]);
		g.drawString(TITLE, ttlpos[0], ttlpos[1], Graphics.LEFT | Graphics.TOP);
		
		g.setFont(smallfont);
		
		if(!options.noEffects)
		{
			g.setColor(ColorScheme.colors[ColorScheme.back1]);
			LineEffect.drawTextOutline(g, SUBTITLE, ttlpos[2], ttlpos[3]);
		}
		
		g.setColor(ColorScheme.colors[ColorScheme.fore]);
		g.drawString(SUBTITLE, ttlpos[2], ttlpos[3], Graphics.LEFT | Graphics.TOP);
		
		g.setFont(font);
		
		for(int i = 0; i < menu[type].length; i++)
		{
			if(i == selindex)
			{
				g.setColor(ColorScheme.colors[ColorScheme.selback1]);
				g.fillRect(pos[i][0], pos[i][1], pos[i][2], pos[i][3]);
				
				g.setColor(ColorScheme.colors[ColorScheme.selfore]);
				g.drawString(Locale.getString(this, menu[type][i]), pos[i][4], pos[i][5], Graphics.LEFT | Graphics.TOP);
			}
			else
			{
				g.setColor(ColorScheme.colors[ColorScheme.back1]);
				g.fillRect(pos[i][0], pos[i][1], pos[i][2], pos[i][3]);
				
				g.setColor(ColorScheme.colors[ColorScheme.fore]);
				g.drawString(Locale.getString(this, menu[type][i]), pos[i][4], pos[i][5], Graphics.LEFT | Graphics.TOP);
			}
			
			g.setColor(ColorScheme.colors[ColorScheme.ltborder]);
			g.drawRect(pos[i][0], pos[i][1], pos[i][2] - 1, pos[i][3] - 1);
		}
	}
	
	public void run()
	{
		try
		{
			while(isshown)
			{
				Thread.sleep(delay);
				
				lfx.moveLines();
				repaint();
			}
		}
		catch(InterruptedException ie)
		{
		}
	}
	
	protected static final int[][] menu =
	{
		{
			CustomLocale.CREATE_CMD,
			CustomLocale.OPEN_CMD,
			CustomLocale.SAVE_CMD,
			CustomLocale.BACK_CMD,
			CustomLocale.PREFS_CMD,
			CustomLocale.EXIT_CMD
		}
	};
}