package modules.viart;

import javax.microedition.lcdui.*;
import java.util.Enumeration;
import com.one.vector.*;
import com.vmx.Locale;
import filemanager.ListMenu;
import filemanager.ListStateListener;

public class ObjectBrowser implements CommandListener, ListStateListener
{
	public static final int VIEW_CURRENT = 0;
	public static final int VIEW_GROUPS = 1;
	public static final int VIEW_ELEMENTS = 2;
	public static final int VIEW_TRANSFORMS = 3;
	
	public static final int DISP_THIS = 0;
	public static final int DISP_TOOLS = 1;
	public static final int DISP_ORDER = 2;
	
	protected VectorImage image;
	protected ListMenu list;
	protected int view;
	protected int disp;
	
	protected int oldindex;
	protected boolean move;
	
	protected int transoffset;
	protected int fxoffset;
	
	protected Group curgroup;
	protected VectorElement curelement;
	
	protected String selgroup, selelement, seltransform;
	
	protected Command cmdOK, cmdView, cmdSelect, cmdEdit, cmdAdd, cmdDelete, cmdOrder, cmdBack, cmdCancel;
	
	public ObjectBrowser(ListMenu list)
	{
		this.list = list;
		
		cmdOK = new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.OK, 1);
		cmdView = new Command(Locale.getString(this, CustomLocale.VIEW_CMD), Command.ITEM, 1);
		cmdSelect = new Command(Locale.getString(this, CustomLocale.SELECT_CMD), Command.OK, 2);
		cmdAdd = new Command(Locale.getString(this, CustomLocale.ADD_CMD), Command.OK, 3);
		cmdEdit = new Command(Locale.getString(this, CustomLocale.EDIT_CMD), Command.OK, 4);
		cmdDelete = new Command(Locale.getString(this, CustomLocale.DELETE_CMD), Command.OK, 5);
		cmdOrder = new Command(Locale.getString(this, CustomLocale.ORDER_CMD), Command.OK, 6);
		cmdBack = new Command(Locale.getString(this, CustomLocale.BACK_CMD), Command.BACK, 7);
		cmdCancel = new Command(Locale.getString(this, CustomLocale.CANCEL_CMD), Command.CANCEL, 8);
	}
	
	public void setCurrentImage(VectorImage image)
	{
		this.image = image;
	}
	
	public void init(int nextview)
	{
		if(nextview != VIEW_CURRENT)
		{
			view = nextview;
		}
		
		list.setTitle(Locale.getString(this, CustomLocale.OBJECT_BROWSER_CMD));
		
		list.deleteAll();
		
		if(view == VIEW_TRANSFORMS && curelement == null)
		{
			view = VIEW_ELEMENTS;
		}
		
		if(view == VIEW_ELEMENTS && curgroup == null)
		{
			view = VIEW_GROUPS;
		}
		
		if(view == VIEW_ELEMENTS)
		{
			list.setSubTitle(curgroup.getName(), false);
			
			list.deleteAll();
			
			Enumeration elements = curgroup.listElements();
			
			while(elements.hasMoreElements())
			{
				list.append(((VectorElement)elements.nextElement()).getName());
			}
			
			transoffset = list.size();
			
			elements = curgroup.listTransforms();
			
			while(elements.hasMoreElements())
			{
				list.append(((Transform)elements.nextElement()).getName());
			}
			
			fxoffset = list.size();
			
			elements = curgroup.listEffects();
			
			while(elements.hasMoreElements())
			{
				list.append(((Effect)elements.nextElement()).getName());
			}
			
			list.select(selelement);
			
			list.removeAllCommands();
			
			list.addCommand(cmdAdd);
			list.addCommand(cmdBack);
			
			if(list.size() > 0)
			{
				if(list.getSelectedIndex() < transoffset)
				{
					list.addCommand(cmdView);
					list.addCommand(cmdSelect);
				}
				
				list.addCommand(cmdEdit);
				list.addCommand(cmdDelete);
				list.addCommand(cmdOrder);
			}
		}
		else if(view == VIEW_TRANSFORMS)
		{
			list.setSubTitle(curelement.getName(), false);
			
			list.deleteAll();
			Enumeration transforms = curelement.listTransforms();
			
			while(transforms.hasMoreElements())
			{
				list.append(((Transform)transforms.nextElement()).getName());
			}
			
			list.select(seltransform);
			
			list.removeAllCommands();
			
			list.addCommand(cmdAdd);
			list.addCommand(cmdBack);
			
			if(list.size() > 0)
			{
				list.addCommand(cmdEdit);
				list.addCommand(cmdDelete);
				list.addCommand(cmdOrder);
			}
		}
		else
		{
			list.setSubTitle(Locale.getString(this, CustomLocale.GROUPS), false);
			
			Enumeration groups = image.listGroups();
			
			while(groups.hasMoreElements())
			{
				list.append(((Group)groups.nextElement()).getName());
			}
			
			list.select(selgroup);
			
			list.removeAllCommands();
			
			list.addCommand(cmdAdd);
			list.addCommand(cmdBack);
			
			if(list.size() > 0)
			{
				list.addCommand(cmdView);
				list.addCommand(cmdSelect);
				list.addCommand(cmdEdit);
				list.addCommand(cmdDelete);
				list.addCommand(cmdOrder);
			}
			
			view = VIEW_GROUPS;
		}
		
		list.setCommandListener(this);
		list.setStateListener(this);
		
		disp = DISP_THIS;
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(disp == DISP_THIS)
		{
			if(c == cmdView)
			{
				if(view == VIEW_GROUPS)
				{
					curgroup = image.getGroup(list.getString(list.getSelectedIndex()));
					selgroup = curgroup.getName();
					list.setSubTitle(selgroup, false);
					
					list.deleteAll();
					
					Enumeration elements = curgroup.listElements();
					
					while(elements.hasMoreElements())
					{
						list.append(((VectorElement)elements.nextElement()).getName());
					}
					
					transoffset = list.size();
					
					elements = curgroup.listTransforms();
					
					while(elements.hasMoreElements())
					{
						list.append(((Transform)elements.nextElement()).getName());
					}
					
					fxoffset = list.size();
					
					elements = curgroup.listEffects();
					
					while(elements.hasMoreElements())
					{
						list.append(((Effect)elements.nextElement()).getName());
					}
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						if(list.getSelectedIndex() < transoffset)
						{
							list.addCommand(cmdView);
							list.addCommand(cmdSelect);
						}
						
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
					
					view = VIEW_ELEMENTS;
				}
				else if(view == VIEW_ELEMENTS)
				{
					curelement = curgroup.getElement(list.getString(list.getSelectedIndex()));
					selelement = curelement.getName();
					list.setSubTitle(selelement, false);
					
					list.deleteAll();
					Enumeration transforms = curelement.listTransforms();
					
					while(transforms.hasMoreElements())
					{
						list.append(((Transform)transforms.nextElement()).getName());
					}
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
					
					view = VIEW_TRANSFORMS;
				}
			}
			else if(c == cmdBack)
			{
				if(view == VIEW_TRANSFORMS)
				{
					list.setSubTitle(curgroup.getName(), false);
					
					list.deleteAll();
					
					Enumeration elements = curgroup.listElements();
					
					while(elements.hasMoreElements())
					{
						list.append(((VectorElement)elements.nextElement()).getName());
					}
					
					transoffset = list.size();
					
					elements = curgroup.listTransforms();
					
					while(elements.hasMoreElements())
					{
						list.append(((Transform)elements.nextElement()).getName());
					}
					
					fxoffset = list.size();
					
					elements = curgroup.listEffects();
					
					while(elements.hasMoreElements())
					{
						list.append(((Effect)elements.nextElement()).getName());
					}
					
					list.select(selelement);
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						if(list.getSelectedIndex() < transoffset)
						{
							list.addCommand(cmdView);
							list.addCommand(cmdSelect);
						}
						
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
					
					view = VIEW_ELEMENTS;
				}
				else if(view == VIEW_ELEMENTS)
				{
					list.setSubTitle(Locale.getString(this, CustomLocale.GROUPS), false);
					
					list.deleteAll();
					Enumeration groups = image.listGroups();
					
					while(groups.hasMoreElements())
					{
						list.append(((Group)groups.nextElement()).getName());
					}
					
					list.select(selgroup);
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						list.addCommand(cmdView);
						list.addCommand(cmdSelect);
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
					
					view = VIEW_GROUPS;
				}
				else if(view == VIEW_GROUPS)
				{
					VIArt.showEdit(false);
				}
			}
			else if(c == cmdCancel)
			{
				VIArt.showEdit(false);
			}
			else if(c == cmdAdd)
			{
				if(view == VIEW_GROUPS)
				{
					Group grp = new Group();
					image.addGroup(grp);
					selgroup = grp.getName();
					VIArt.showObjectEditor(grp);
				}
				else if(view == VIEW_ELEMENTS)
				{
					VIArt.showToolList(this, true, true, true, -1);
					disp = DISP_TOOLS;
				}
				else if(view == VIEW_TRANSFORMS)
				{
					VIArt.showToolList(this, false, true, false, -1);
					disp = DISP_TOOLS;
				}
			}
			else if(c == cmdEdit)
			{
				if(view == VIEW_GROUPS)
				{
					Group grp = image.getGroup(list.getString(list.getSelectedIndex()));
					selgroup = grp.getName();
					VIArt.showObjectEditor(grp);
				}
				else if(view == VIEW_ELEMENTS)
				{
					int index = list.getSelectedIndex();
					
					if(transoffset > 0 && index < transoffset)
					{
						VectorElement ve = curgroup.getElement(list.getString(index));
						selelement = ve.getName();
						VIArt.showObjectEditor(ve);
					}
					else if(fxoffset > transoffset && index < fxoffset)
					{
						Transform transform = curgroup.getTransform(list.getString(index));
						selelement = transform.getName();
						VIArt.showTransformEditor(transform, image);
					}
					else
					{
						Effect effect = curgroup.getEffect(list.getString(index));
						selelement = effect.getName();
						VIArt.showEffectEditor(effect);
					}
				}
				else if(view == VIEW_TRANSFORMS)
				{
					Transform transform = curelement.getTransform(list.getString(list.getSelectedIndex()));
					seltransform = transform.getName();
					VIArt.showTransformEditor(transform, image);
				}
			}
			else if(c == cmdDelete)
			{
				if(view == VIEW_GROUPS)
				{
					image.deleteGroup(image.getGroup(list.getString(list.getSelectedIndex())));
					list.delete(list.getSelectedIndex());
					VIArt.setEditCurrentGroup(null);
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						list.addCommand(cmdView);
						list.addCommand(cmdSelect);
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
				}
				else if(view == VIEW_ELEMENTS)
				{
					int index = list.getSelectedIndex();
					
					if(transoffset > 0 && index < transoffset)
					{
						curgroup.deleteElement(curgroup.getElement(list.getString(index)));
						VIArt.setEditCurrentElement(null);
					}
					else if(fxoffset > transoffset && index < fxoffset)
					{
						curgroup.deleteTransform(curgroup.getTransform(list.getString(index)));
					}
					else
					{
						curgroup.deleteEffect(curgroup.getEffect(list.getString(index)));
					}
					
					list.delete(index);
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						if(list.getSelectedIndex() < transoffset)
						{
							list.addCommand(cmdView);
							list.addCommand(cmdSelect);
						}
						
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
				}
				else if(view == VIEW_TRANSFORMS)
				{
					curelement.deleteTransform(curelement.getTransform(list.getString(list.getSelectedIndex())));
					list.delete(list.getSelectedIndex());
					
					list.removeAllCommands();
					
					list.addCommand(cmdAdd);
					list.addCommand(cmdBack);
					
					if(list.size() > 0)
					{
						list.addCommand(cmdEdit);
						list.addCommand(cmdDelete);
						list.addCommand(cmdOrder);
					}
				}
			}
			else if(c == cmdSelect)
			{
				if(view == VIEW_GROUPS)
				{
					VIArt.setEditCurrentGroup(image.getGroup(list.getString(list.getSelectedIndex())));
					VIArt.showEdit(false);
				}
				else if(view == VIEW_ELEMENTS)
				{
					VIArt.setEditCurrentElement(curgroup.getElement(list.getString(list.getSelectedIndex())));
					VIArt.showEdit(false);
				}
			}
			else if(c == cmdOrder)
			{
				list.removeAllCommands();
				list.addCommand(cmdSelect);
				list.addCommand(cmdBack);
				
				disp = DISP_ORDER;
				move = false;
			}
		}
		else if(disp == DISP_TOOLS)
		{
			if(c.getCommandType() == Command.OK)
			{
				int index = list.getSelectedIndex();
				
				transoffset = VectorElement.OFFSET_TRANSFORMS - VectorElement.OFFSET_ELEMENTS;
				fxoffset = VectorElement.OFFSET_EFFECTS - VectorElement.OFFSET_ELEMENTS;
				
				if(view == VIEW_ELEMENTS)
				{
					if(index < transoffset)
					{
						VectorElement ve = VectorElement.getInstance(index);
						ve.create();
						curgroup.addElement(ve);
						selelement = ve.getName();
						VIArt.showObjectEditor(ve);
					}
					else if(index < fxoffset)
					{
						Transform transform = new Transform(new ArrayData(), index - transoffset, -1, image.currentFrame(), image.currentFrame(), 0, 0, 0);
						curgroup.addTransform(transform, false);
						selelement = transform.getName();
						VIArt.showTransformEditor(transform, image);
					}
					else
					{
						Effect effect = Effect.getInstance(index - fxoffset);
						curgroup.addEffect(effect);
						selelement = effect.getName();
						VIArt.showEffectEditor(effect);
					}
				}
				else if(view == VIEW_TRANSFORMS)
				{
					Transform transform = new Transform(new ArrayData(), index, -1, image.currentFrame(), image.currentFrame(), 0, 0, 0);
					curelement.addTransform(transform, false);
					seltransform = transform.getName();
					VIArt.showTransformEditor(transform, image);
				}
				
				disp = DISP_THIS;
			}
			else
			{
				VIArt.showObjectBrowser(VIEW_CURRENT);
			}
		}
		else if(disp == DISP_ORDER)
		{
			if(c == cmdSelect)
			{
				oldindex = list.getSelectedIndex();
				move = true;
				
				list.removeCommand(cmdSelect);
				list.addCommand(cmdOK);
			}
			else if(c == cmdOK)
			{
				move = false;
				
				list.removeCommand(cmdOK);
				list.addCommand(cmdSelect);
			}
			else
			{
				if(view == VIEW_GROUPS)
				{
					selgroup = list.getString(list.getSelectedIndex());
				}
				else if(view == VIEW_ELEMENTS)
				{
					selelement = list.getString(list.getSelectedIndex());
				}
				else if(view == VIEW_TRANSFORMS)
				{
					seltransform = list.getString(list.getSelectedIndex());
				}
				
				init(VIEW_CURRENT);
			}
		}
	}
	
	public void listStateChanged(ListMenu list, int action)
	{
		if(disp == DISP_THIS && view == VIEW_ELEMENTS)
		{
			if(transoffset > 0 && list.getSelectedIndex() < transoffset)
			{
				list.addCommand(cmdView);
				list.addCommand(cmdSelect);
			}
			else
			{
				list.removeCommand(cmdView);
				list.removeCommand(cmdSelect);
			}
		}
		else if(disp == DISP_ORDER && action == ListMenu.CURSOR_MOVED && move)
		{
			if(view == VIEW_GROUPS)
			{
				image.arrangeGroups(oldindex, list.getSelectedIndex());
			}
			else if(view == VIEW_ELEMENTS)
			{
				if(transoffset > 0 && oldindex < transoffset)
				{
					curgroup.arrangeElements(oldindex, list.getSelectedIndex());
				}
				else if(fxoffset > transoffset && oldindex < fxoffset)
				{
					curgroup.arrangeTransforms(oldindex - transoffset, list.getSelectedIndex() - transoffset);
				}
				else
				{
					curgroup.arrangeEffects(oldindex - fxoffset, list.getSelectedIndex() - fxoffset);
				}
			}
			else if(view == VIEW_TRANSFORMS)
			{
				curelement.arrangeTransforms(oldindex, list.getSelectedIndex());
			}
			
			String temp = list.getString(list.getSelectedIndex());
			list.setString(list.getString(oldindex), list.getSelectedIndex());
			list.setString(temp, oldindex);
			
			oldindex = list.getSelectedIndex();
		}
	}
}