package modules.viart;

import javax.microedition.lcdui.*;
import com.one.vector.*;
import com.one.*;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.Palette;
import filemanager.TemplateTextField;

public class ObjectEditor extends Form implements CommandListener, ItemCommandListener, ItemStateListener, FileNameListener
{
	protected VectorElement element;
	protected int type;
	
	protected TextField tfName, tfColor;
	protected ChoiceGroup cgFlags;
	
	protected TextField[] tfTrans;
	
	protected TextField tfCount;
	protected TextField tfQuality;
	protected Gauge gSelect;
	protected int curparam;
	
	protected ChoiceGroup cgFunction;
	protected ChoiceGroup cgParam;
	
	protected ChoiceGroup cgClipMode;
	protected ChoiceGroup cgBitmapMode;
	protected TextField tfFileName;
	protected TextField tfStartColor, tfEndColor;
	protected TextField tfPolyCount;
	protected TextField tfOffsetX, tfOffsetY;
	protected TextField tfScaleX, tfScaleY;
	
	protected Command cmdBrowse = new Command(Locale.getString(this, CustomLocale.BROWSE_CMD), Command.ITEM, 1);
	protected Command cmdPalette = new Command(Locale.getString(this, CustomLocale.PALETTE_CMD), Command.ITEM, 1);
	protected TextField clritem;
	
	public ObjectEditor()
	{
		super(null);
		setTitle(Locale.getString(this, CustomLocale.OBJECT_EDITOR));
		
		tfName = new TemplateTextField(Locale.getString(this, CustomLocale.NAME), "", 256, TextField.ANY);
		
		tfColor = new TextField(Locale.getString(this, CustomLocale.COLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfColor.setItemCommandListener(this);
		
		cgFlags = new ChoiceGroup(Locale.getString(this, CustomLocale.FLAGS), Choice.MULTIPLE);
		cgFlags.append(Locale.getString(this, CustomLocale.DOTTED), null);
		cgFlags.append(Locale.getString(this, CustomLocale.FILL), null);
		cgFlags.append(Locale.getString(this, CustomLocale.HIDDEN), null);
		
		tfCount = new TextField(Locale.getString(this, CustomLocale.COUNT), "", 20, TextField.NUMERIC);
		tfQuality = new TextField(Locale.getString(this, CustomLocale.QUALITY), "", 20, TextField.NUMERIC);
		gSelect = new Gauge(Locale.getString(this, CustomLocale.SELECT), true, 1, 0);
		
		tfTrans = new TextField[VectorElement.INT_B - VectorElement.X + 1];
		
		int i, j;
		
		for(i = 0; i < tfTrans.length; i++)
		{
			j = i + VectorElement.X;
			
			if(j >= VectorElement.START && j <= VectorElement.ANGLE)
			{
				tfTrans[i] = new TextField("", "", 20, TextField.NUMERIC);
			}
			else if(j == VectorElement.INT_A || j == VectorElement.INT_B)
			{
				tfTrans[i] = new TextField("", "", 20, TextField.ANY | TextField.NON_PREDICTIVE);
				tfTrans[i].setItemCommandListener(this);
			}
			else
			{
				tfTrans[i] = new TextField("", "", 20, TextField.DECIMAL);
			}
		}
		
		cgParam = new ChoiceGroup(Locale.getString(this, CustomLocale.PARAM), Choice.POPUP);
		
		cgFunction = new ChoiceGroup(Locale.getString(this, CustomLocale.FX_TYPE), Choice.POPUP);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_LINEAR), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_INTEGER), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_HARMONIC), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_CUBIC), null);
		
		cgClipMode = new ChoiceGroup(Locale.getString(this, CustomLocale.CLIP_MODE), Choice.POPUP);
		cgClipMode.append(Locale.getString(this, CustomLocale.CLIP_ABSOLUTE), null);
		cgClipMode.append(Locale.getString(this, CustomLocale.CLIP_RELATIVE), null);
		
		cgBitmapMode = new ChoiceGroup(Locale.getString(this, CustomLocale.BITMAP_MODE), Choice.POPUP);
		cgBitmapMode.append(Locale.getString(this, CustomLocale.NO_REPEAT), null);
		cgBitmapMode.append(Locale.getString(this, CustomLocale.REPEAT_X), null);
		cgBitmapMode.append(Locale.getString(this, CustomLocale.REPEAT_Y), null);
		cgBitmapMode.append(Locale.getString(this, CustomLocale.REPEAT_BOTH), null);
		cgBitmapMode.append(Locale.getString(this, CustomLocale.BITMAP_SCALE), null);
		
		tfFileName = new TextField(Locale.getString(this, CustomLocale.FILE_NAME), "", 256, TextField.ANY);
		tfFileName.setItemCommandListener(this);
		
		tfStartColor = new TextField(Locale.getString(this, CustomLocale.START_COLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfEndColor = new TextField(Locale.getString(this, CustomLocale.END_COLOR), "", 8, TextField.ANY | TextField.NON_PREDICTIVE);
		tfStartColor.setItemCommandListener(this);
		tfEndColor.setItemCommandListener(this);
		
		tfPolyCount = new TextField(Locale.getString(this, CustomLocale.POLY_COUNT), "", 20, TextField.NUMERIC);
		
		tfOffsetX = new TextField(Locale.getString(this, CustomLocale.OFFSET_X), "", 20, TextField.DECIMAL);
		tfOffsetY = new TextField(Locale.getString(this, CustomLocale.OFFSET_Y), "", 20, TextField.DECIMAL);
		tfScaleX = new TextField(Locale.getString(this, CustomLocale.SCALE_X), "", 20, TextField.DECIMAL);
		tfScaleY = new TextField(Locale.getString(this, CustomLocale.SCALE_Y), "", 20, TextField.DECIMAL);
		
		addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
		
		setItemStateListener(this);
	}
	
	protected void setField(int param, int subparam, boolean append)
	{
		if(param >= VectorElement.START && param <= VectorElement.ANGLE)
		{
			tfTrans[param - VectorElement.X].setLabel(VectorElement.getTransformPrefix(param, subparam));
			tfTrans[param - VectorElement.X].setString(((Integer)element.getValue(param, subparam)).toString());
		}
		else if(param >= VectorElement.VAL_A && param <= VectorElement.DIV_D)
		{
			tfTrans[param - VectorElement.X].setLabel(VectorElement.getTransformPrefix(param, -1));
			tfTrans[param - VectorElement.X].setString(((Double)element.getValue(param, subparam)).toString());
		}
		else if(param == VectorElement.INT_A || param == VectorElement.INT_B)
		{
			tfTrans[param - VectorElement.X].setLabel(VectorElement.getTransformPrefix(param, -1));
			
			try
			{
				tfTrans[param - VectorElement.X].removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			if(type != VectorElement.PARAMETRIC_CURVE &&
			   type != VectorElement.THICK_PARAMETRIC_CURVE &&
			   subparam == 0)
			{
				tfTrans[param - VectorElement.X].setString(Integer.toHexString(((Integer)element.getValue(param, subparam)).intValue()).toUpperCase());
				tfTrans[param - VectorElement.X].addCommand(cmdPalette);
			}
			else
			{
				tfTrans[param - VectorElement.X].setString(((Integer)element.getValue(param, subparam)).toString());
			}
		}
		else
		{
			tfTrans[param - VectorElement.X].setLabel(VectorElement.getTransformPrefix(param, subparam));
			tfTrans[param - VectorElement.X].setString(((Double)element.getValue(param, subparam)).toString());
		}
		
		if(append)
		{
			append(tfTrans[param - VectorElement.X]);
		}
	}
	
	protected void storeField(int param, int subparam)
	{
		if(param >= VectorElement.START && param <= VectorElement.ANGLE)
		{
			element.setValue(Integer.valueOf(tfTrans[param - VectorElement.X].getString()), param, subparam);
		}
		else if(param == VectorElement.INT_A || param == VectorElement.INT_B)
		{
			try
			{
				if(type != VectorElement.PARAMETRIC_CURVE &&
				   type != VectorElement.THICK_PARAMETRIC_CURVE &&
				   subparam == 0)
				{
					element.setValue(new Integer((int)Long.parseLong(tfTrans[param - VectorElement.X].getString(), 16)), param, subparam);
				}
				else
				{
					element.setValue(Integer.valueOf(tfTrans[param - VectorElement.X].getString()), param, subparam);
				}
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else
		{
			element.setValue(Double.valueOf(tfTrans[param - VectorElement.X].getString()), param, subparam);
		}
	}
	
	public void setCurrentElement(VectorElement element)
	{
		this.element = element;
		
		//deleteAll();
		
		tfName.setString(element.getName());
		append(tfName);
		
		tfColor.setString(Integer.toHexString(element.getColor()).toUpperCase());
		
		try
		{
			tfColor.removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		tfColor.addCommand(cmdPalette);
		append(tfColor);
		
		cgFlags.setSelectedIndex(0, element.isDotted());
		cgFlags.setSelectedIndex(1, element.isFill());
		cgFlags.setSelectedIndex(2, element.isHidden());
		append(cgFlags);
		
		curparam = -1;
		
		if(element instanceof Group)
		{
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
			
			tfOffsetX.setString(Double.toString(((Group)element).param[0]));
			tfOffsetY.setString(Double.toString(((Group)element).param[1]));
			tfScaleX.setString(Double.toString(((Group)element).param[4]));
			tfScaleY.setString(Double.toString(((Group)element).param[5]));
			
			append(tfOffsetX);
			append(tfOffsetY);
			append(tfScaleX);
			append(tfScaleY);
			
			return;
		}
		
		type = VectorElement.elementType(element);
		
		int n;
		String s;
		
		if(type == VectorElement.CLIP)
		{
			cgClipMode.setSelectedIndex(((Boolean)element.getValue(VectorElement.MODE, -1)).booleanValue() ? 0 : 1, true);
			append(cgClipMode);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
		}
		else if(type == VectorElement.LINE)
		{
			gSelect.setMaxValue(1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.ARC)
		{
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.START, curparam, true);
			setField(VectorElement.LENGTH, curparam, true);
		}
		else if(type == VectorElement.RECT)
		{
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
		}
		else if(type == VectorElement.ROUND_RECT)
		{
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ARC_WIDTH, curparam, true);
			setField(VectorElement.ARC_HEIGHT, curparam, true);
		}
		else if(type == VectorElement.POINT)
		{
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.TRIANGLE)
		{
			gSelect.setMaxValue(2);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.POLYLINE)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			gSelect.setMaxValue(((Integer)element.getValue(VectorElement.COUNT, -1)).intValue() - 1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.POLYGON)
		{
			tfPolyCount.setString(((Integer)element.getValue(VectorElement.POLY_COUNT, -1)).toString());
			append(tfPolyCount);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ROTATION, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
		}
		else if(type == VectorElement.PARAMETRIC_CURVE)
		{
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.BEZIER_CURVE)
		{
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			n = ((Integer)element.getValue(VectorElement.COUNT, -1)).intValue();
			
			tfCount.setString(Integer.toString(n));
			append(tfCount);
			
			gSelect.setMaxValue(n - 1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.THICK_LINE)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			gSelect.setMaxValue(1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.THICK_RECT)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
		}
		else if(type == VectorElement.THICK_TRIANGLE)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			gSelect.setMaxValue(2);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.THICK_POLYLINE)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			gSelect.setMaxValue(((Integer)element.getValue(VectorElement.COUNT, -1)).intValue() - 1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.THICK_POLYGON)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			tfPolyCount.setString(((Integer)element.getValue(VectorElement.POLY_COUNT, -1)).toString());
			append(tfPolyCount);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ROTATION, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
		}
		else if(type == VectorElement.THICK_PARAMETRIC_CURVE)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, -1)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.THICK_BEZIER_CURVE)
		{
			setField(VectorElement.THICKNESS, -1, true);
			
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			n = ((Integer)element.getValue(VectorElement.COUNT, -1)).intValue();
			
			tfCount.setString(Integer.toString(n));
			append(tfCount);
			
			gSelect.setMaxValue(n - 1);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.BITMAP)
		{
			s = (String)element.getValue(VectorElement.FILE, -1);
			
			tfFileName.setString(s != null ? s : "");
			
			try
			{
				tfFileName.removeCommand(cmdBrowse);
				removeCommand(cmdBrowse);
			}
			catch(Exception e)
			{
			}
			
			tfFileName.addCommand(cmdBrowse);
			append(tfFileName);
			
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
			
			cgBitmapMode.setSelectedIndex(((Integer)element.getValue(VectorElement.MODE, -1)).intValue(), true);
			append(cgBitmapMode);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
		}
		else if(type == VectorElement.TEXTURE_ARC)
		{
			s = (String)element.getValue(VectorElement.FILE, -1);
			
			tfFileName.setString(s != null ? s : "");
			
			try
			{
				tfFileName.removeCommand(cmdBrowse);
				removeCommand(cmdBrowse);
			}
			catch(Exception e)
			{
			}
			
			tfFileName.addCommand(cmdBrowse);
			append(tfFileName);
			
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.START, curparam, true);
			setField(VectorElement.LENGTH, curparam, true);
		}
		else if(type == VectorElement.TEXTURE_ROUND_RECT)
		{
			s = (String)element.getValue(VectorElement.FILE, -1);
			
			tfFileName.setString(s != null ? s : "");
			
			try
			{
				tfFileName.removeCommand(cmdBrowse);
				removeCommand(cmdBrowse);
			}
			catch(Exception e)
			{
			}
			
			tfFileName.addCommand(cmdBrowse);
			append(tfFileName);
			
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ARC_WIDTH, curparam, true);
			setField(VectorElement.ARC_HEIGHT, curparam, true);
		}
		else if(type == VectorElement.TEXTURE_TRIANGLE)
		{
			s = (String)element.getValue(VectorElement.FILE, -1);
			
			tfFileName.setString(s != null ? s : "");
			
			try
			{
				tfFileName.removeCommand(cmdBrowse);
				removeCommand(cmdBrowse);
			}
			catch(Exception e)
			{
			}
			
			tfFileName.addCommand(cmdBrowse);
			append(tfFileName);
			
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
			
			gSelect.setMaxValue(2);
			gSelect.setValue(0);
			append(gSelect);
			
			curparam = gSelect.getValue() + 1;
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
		}
		else if(type == VectorElement.TEXTURE_POLYGON)
		{
			s = (String)element.getValue(VectorElement.FILE, -1);
			
			tfFileName.setString(s != null ? s : "");
			
			try
			{
				tfFileName.removeCommand(cmdBrowse);
				removeCommand(cmdBrowse);
			}
			catch(Exception e)
			{
			}
			
			tfFileName.addCommand(cmdBrowse);
			append(tfFileName);
			
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
			
			tfPolyCount.setString(((Integer)element.getValue(VectorElement.POLY_COUNT, -1)).toString());
			append(tfPolyCount);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ROTATION, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
		}
		else if(type == VectorElement.GRADIENT_RECT)
		{
			tfStartColor.setString(Integer.toHexString(((Integer)element.getValue(VectorElement.COLOR, 0)).intValue()).toUpperCase());
			
			try
			{
				tfStartColor.removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			tfStartColor.addCommand(cmdPalette);
			append(tfStartColor);
			
			tfEndColor.setString(Integer.toHexString(((Integer)element.getValue(VectorElement.COLOR, 1)).intValue()).toUpperCase());
			
			try
			{
				tfEndColor.removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			tfEndColor.addCommand(cmdPalette);
			append(tfEndColor);
			
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
		}
		else if(type == VectorElement.GRADIENT_CIRCLE)
		{
			tfStartColor.setString(Integer.toHexString(((Integer)element.getValue(VectorElement.COLOR, 0)).intValue()).toUpperCase());
			
			try
			{
				tfStartColor.removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			tfStartColor.addCommand(cmdPalette);
			append(tfStartColor);
			
			tfEndColor.setString(Integer.toHexString(((Integer)element.getValue(VectorElement.COLOR, 1)).intValue()).toUpperCase());
			
			try
			{
				tfEndColor.removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			tfEndColor.addCommand(cmdPalette);
			append(tfEndColor);
			
			tfQuality.setString(((Integer)element.getValue(VectorElement.QUALITY, -1)).toString());
			append(tfQuality);
			
			setField(VectorElement.X, curparam, true);
			setField(VectorElement.Y, curparam, true);
			setField(VectorElement.WIDTH, curparam, true);
			setField(VectorElement.HEIGHT, curparam, true);
			setField(VectorElement.ANGLE, curparam, true);
		}
		else if(type == VectorElement.LINE_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, 1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, 1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, 2), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, 2), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.ARC_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.WIDTH, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.HEIGHT, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.START, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.LENGTH, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.RECT_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.WIDTH, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.HEIGHT, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.ROUND_RECT_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.WIDTH, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.HEIGHT, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.ARC_WIDTH, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.ARC_HEIGHT, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.POINT_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.TRIANGLE_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, 1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, 1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, 2), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, 2), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, 3), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, 3), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
		else if(type == VectorElement.POLYGON_ARRAY)
		{
			tfCount.setString(((Integer)element.getValue(VectorElement.COUNT, -1)).toString());
			append(tfCount);
			
			tfPolyCount.setString(((Integer)element.getValue(VectorElement.POLY_COUNT, -1)).toString());
			append(tfPolyCount);
			
			cgParam.deleteAll();
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.COLOR, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.X, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.Y, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.WIDTH, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.HEIGHT, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.ROTATION, -1), null);
			cgParam.append(VectorElement.getTransformPrefix(VectorElement.ANGLE, -1), null);
			cgParam.setSelectedIndex(0, true);
			append(cgParam);
			
			curparam = cgParam.getSelectedIndex();
			
			cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
			append(cgFunction);
			
			setField(VectorElement.VAL_A, curparam, true);
			setField(VectorElement.VAL_B, curparam, true);
			setField(VectorElement.DIV_A, curparam, true);
			setField(VectorElement.DIV_B, curparam, true);
			setField(VectorElement.DIV_C, curparam, true);
			setField(VectorElement.DIV_D, curparam, true);
			setField(VectorElement.INT_A, curparam, true);
			setField(VectorElement.INT_B, curparam, true);
		}
	}
	
	public void itemStateChanged(Item item)
	{
		int n;
		
		if(item == tfCount)
		{
			n = Integer.parseInt(tfCount.getString());
			
			if(type == VectorElement.POLYLINE ||
			   type == VectorElement.BEZIER_CURVE ||
			   type == VectorElement.THICK_POLYLINE ||
			   type == VectorElement.THICK_BEZIER_CURVE)
			{
				if(n < 3)
				{
					n = 3;
				}
				
				gSelect.setMaxValue(n - 1);
				itemStateChanged(gSelect);
			}
			else
			{
				if(n < 2)
				{
					n = 2;
				}
			}
			
			tfCount.setString(Integer.toString(n));
			element.setValue(new Integer(n), VectorElement.COUNT, -1);
		}
		else if(item == tfPolyCount)
		{
			n = Integer.parseInt(tfPolyCount.getString());
			
			if(n < 3)
			{
				n = 3;
			}
			
			tfPolyCount.setString(Integer.toString(n));
			element.setValue(Integer.valueOf(tfPolyCount.getString()), VectorElement.POLY_COUNT, -1);
		}
		else if(item == gSelect)
		{
			n = gSelect.getValue() + 1;
			
			if(n != curparam)
			{
				curparam = n;
				
				setField(VectorElement.X, curparam, false);
				setField(VectorElement.Y, curparam, false);
			}
		}
		else if(item == tfQuality)
		{
			n = Integer.parseInt(tfQuality.getString());
			
			if(n < 2)
			{
				n = 2;
			}
			
			tfQuality.setString(Integer.toString(n));
			element.setValue(new Integer(n), VectorElement.QUALITY, -1);
		}
		else if(item == cgParam)
		{
			n = cgParam.getSelectedIndex();
			
			if(n != curparam)
			{
				curparam = n;
				
				cgFunction.setSelectedIndex(((Integer)element.getValue(VectorElement.FUNCTION, curparam)).intValue(), true);
				
				setField(VectorElement.VAL_A, curparam, false);
				setField(VectorElement.VAL_B, curparam, false);
				setField(VectorElement.DIV_A, curparam, false);
				setField(VectorElement.DIV_B, curparam, false);
				setField(VectorElement.DIV_C, curparam, false);
				setField(VectorElement.DIV_D, curparam, false);
				setField(VectorElement.INT_A, curparam, false);
				setField(VectorElement.INT_B, curparam, false);
			}
		}
		else if(item == cgFunction)
		{
			element.setValue(new Integer(cgFunction.getSelectedIndex()), VectorElement.FUNCTION, curparam);
		}
		else if(item == tfName)
		{
			element.setName(tfName.getString());
		}
		else if(item == tfColor)
		{
			try
			{
				element.setColor((int)Long.parseLong(tfColor.getString(), 16));
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == cgFlags)
		{
			element.setDotted(cgFlags.isSelected(0));
			element.setFill(cgFlags.isSelected(1));
			element.setHidden(cgFlags.isSelected(2));
		}
		else if(item == cgClipMode)
		{
			element.setValue(new Boolean(cgClipMode.isSelected(0)), VectorElement.MODE, -1);
		}
		else if(item == cgBitmapMode)
		{
			element.setValue(new Integer(cgBitmapMode.getSelectedIndex()), VectorElement.MODE, -1);
		}
		else if(item == tfFileName)
		{
			element.setValue(tfFileName.getString(), VectorElement.FILE, -1);
		}
		else if(item == tfStartColor)
		{
			try
			{
				element.setValue(new Integer((int)Long.parseLong(tfStartColor.getString(), 16)), VectorElement.COLOR, 0);
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == tfEndColor)
		{
			try
			{
				element.setValue(new Integer((int)Long.parseLong(tfEndColor.getString(), 16)), VectorElement.COLOR, 1);
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == tfOffsetX)
		{
			((Group)element).param[0] = Double.parseDouble(tfOffsetX.getString());
		}
		else if(item == tfOffsetY)
		{
			((Group)element).param[1] = Double.parseDouble(tfOffsetY.getString());
		}
		else if(item == tfScaleX)
		{
			((Group)element).param[4] = Double.parseDouble(tfScaleX.getString());
		}
		else if(item == tfScaleY)
		{
			((Group)element).param[5] = Double.parseDouble(tfScaleY.getString());
		}
		else
		{
			for(n = 0; n < tfTrans.length; n++)
			{
				if(item == tfTrans[n])
				{
					storeField(n + VectorElement.X, curparam);
					break;
				}
			}
		}
	}
	
	public void commandAction(Command c, Item item)
	{
		if(c == cmdPalette)
		{
			if(item instanceof TextField)
			{
				try
				{
					VIArt.showPalette(this, (int)Long.parseLong(((TextField)item).getString(), 16), false);
					clritem = (TextField)item;
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
		else if(c == cmdBrowse)
		{
			if(item == tfFileName)
			{
				VIArt.showFileBrowser(this);
			}
		}
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();
			
			if(po instanceof Palette)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showColorSelector(this, ((Palette)po).getColor());
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((Palette)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showObjectEditor(null);
						break;
				}
			}
			else if(po instanceof ColorSelector)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showPalette(this, ((ColorSelector)po).getColor(), true);
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((ColorSelector)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showObjectEditor(null);
						break;
				}
			}
		}
		else if(dp == this)
		{
			element.create();
			element.rescale();
			
			if(element instanceof Group)
			{
				VIArt.setEditCurrentGroup((Group)element);
			}
			else
			{
				VIArt.setEditCurrentElement(element);
			}
			
			VIArt.showObjectBrowser(ObjectBrowser.VIEW_CURRENT);
		}
	}
	
	public void fileNameAcquired(String filename)
	{
		VIArt.showObjectEditor(null);
		
		if(filename != null)
		{
			tfFileName.setString(filename);
			itemStateChanged(tfFileName);
		}
	}
}