package modules.viart;

import com.one.ModuleRegistry;
import com.one.OptionStorage;
import com.vmx.Locale;
import filemanager.main;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class OptionsEditor implements CommandListener, OptionStorage
{
	public static final int OPTIONS_VERSION = 1;

	// Настройки
	public static boolean compressSVG = true;
	public static boolean quantizeGIF = true;
	public static boolean ditherGIF = false;
	public static boolean scaleImported = true;

	protected Object parent;

	protected ChoiceGroup cgMisc;
	protected ChoiceGroup cgExportGIF;
	
	public void showEditor(Object parent)
	{
		this.parent = parent;

		restoreOptions();

		Form form = new Form(ModuleRegistry.getModuleName(getClass().getName()));
		
		cgMisc = new ChoiceGroup(null, Choice.MULTIPLE);
		
		cgMisc.append(Locale.getString(this, CustomLocale.COMPRESS_SVG), null);
		cgMisc.setSelectedIndex(0, compressSVG);
		
		cgMisc.append(Locale.getString(this, CustomLocale.SCALE_IMPORTED), null);
		cgMisc.setSelectedIndex(1, scaleImported);
		
		cgExportGIF = new ChoiceGroup(null, Choice.MULTIPLE);
		
		cgExportGIF.append(Locale.getString(this, CustomLocale.QUANTIZE_GIF), null);
		cgExportGIF.setSelectedIndex(0, quantizeGIF);
		
		cgExportGIF.append(Locale.getString(this, CustomLocale.DITHER_GIF), null);
		cgExportGIF.setSelectedIndex(1, ditherGIF);
		
		form.append(cgMisc);
		form.append(cgExportGIF);
		
		form.addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.OK, 1));
		form.addCommand(new Command(Locale.getString(this, CustomLocale.CANCEL_CMD), Command.CANCEL, 2));
		form.setCommandListener(this);

		main.dsp.setCurrent(form);
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(c.getCommandType() == Command.OK)
		{
			compressSVG = cgMisc.isSelected(0);
			scaleImported = cgMisc.isSelected(1);
			
			quantizeGIF = cgExportGIF.isSelected(0);
			ditherGIF = cgExportGIF.isSelected(1);
			
			VIArt.updateRuntimeOptions();
		}
		
		main.dsp.setCurrent(parent);
	}

	public void restoreOptions()
	{
		try
		{
			byte[] data = ModuleRegistry.getModuleData(getClass().getName());

			if(data == null || data.length == 0)
			{
				return;
			}

			DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));

			if(dis.readInt() != OPTIONS_VERSION)
			{
				dis.close();
				return;
			}

			compressSVG = dis.readBoolean();
			quantizeGIF = dis.readBoolean();
			ditherGIF = dis.readBoolean();
			scaleImported = dis.readBoolean();

			dis.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	public void saveOptions()
	{
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			DataOutputStream dos = new DataOutputStream(baos);

			dos.writeInt(OPTIONS_VERSION);
			dos.writeBoolean(compressSVG);
			dos.writeBoolean(quantizeGIF);
			dos.writeBoolean(ditherGIF);
			dos.writeBoolean(scaleImported);

			byte[] data = baos.toByteArray();
			dos.close();

			ModuleRegistry.setModuleData(getClass().getName(), data);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}