package modules.viart;

import com.one.AbstractFont;
import com.one.ExtGraphics;
import com.one.PaintableObject;
import com.one.vector.VectorImage;
import com.vmx.AuxClass;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreen extends PaintableObject
{
	protected Image image;
	protected int width, height;
	protected int curstate, maxstate;
	protected AbstractFont font;
	protected int pbx, pby, pbw, pbh;
	protected int backcolor, forecolor;
	protected int imgx, imgy;
	protected int fnth;
	protected String message;
	protected int msgx, msgy;
	protected int arcsz;
	protected boolean error;
	
	public SplashScreen()
	{
		setFullScreenMode(true);
		
		width = getWidth();
		height = getHeight();
		
		font = AbstractFont.getDefaultFont();
		fnth = font.getHeight();
		
		pbw = width - fnth;
		pbh = fnth / 2;
		pbx = (width - pbw) / 2;
		pby = height - fnth;
		
		arcsz = Math.min(pbw, pbh) / 2;
		
		curstate = 0;
		maxstate = 1;
		
		setMessage("");
		
		try
		{
			DataInputStream dis = new DataInputStream(AuxClass.getResourceAsStream("/modules/viart/img/splash.mvi"));
			VectorImage vi = new VectorImage(dis);
			dis.close();
			
			vi.scaleToFit(width - fnth * 2, height - fnth * 2);
			
			backcolor = vi.getBackColor();
			forecolor = backcolor ^ 0xFFFFFF;
			
			image = Image.createImage(vi.getWidth(), vi.getHeight());
			vi.paint(image.getGraphics(), 0, 0);
			
			imgx = (width - image.getWidth()) / 2;
			imgy = (height - image.getHeight()) / 2;
		}
		catch(Throwable t)
		{
			t.printStackTrace();
			
			backcolor = 0;
			forecolor = -1;
		}
	}
	
	public void setMaxState(int value)
	{
		maxstate = value;
		repaint();
	}
	
	public void setState(int value)
	{
		curstate = value;
		repaint();
	}
	
	public void nextState()
	{
		curstate++;
		repaint();
	}
	
	public void setMessage(String text)
	{
		if(text != null)
		{
			message = text;
			error = false;
		}
		else
		{
			message = "-" + Integer.toString(curstate) + "-";
			error = true;
		}
		
		msgx = (width - font.stringWidth(message)) / 2;
		msgy = pby - (fnth - pbh) / 2;
		
		repaint();
	}
	
	public void keyPressed(int keyCode)
	{
		if(curstate < 0 || curstate > maxstate)
		{
			if(error)
			{
				VIArt.exit();
			}
			else
			{
				VIArt.showMainMenu();
			}
		}
	}
	
	public void paint(ExtGraphics g)
	{
		g.setColor(backcolor);
		g.fillRect(0, 0, width, height);
		
		if(image != null)
		{
			g.drawImage(image, imgx, imgy, Graphics.LEFT | Graphics.TOP);
		}
		
		g.setColor(forecolor);
		
		if(curstate >= 0 && curstate <= maxstate)
		{
			g.fillRoundRect(pbx, pby, pbw * curstate / maxstate, pbh, arcsz, arcsz);
		}
		else
		{
			g.setFont(font);
			g.drawString(message, msgx, msgy, Graphics.LEFT | Graphics.TOP);
		}
	}
}