package modules.viart;

import javax.microedition.lcdui.*;
import com.one.vector.*;
import com.one.*;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.Palette;
import filemanager.TemplateTextField;

public class TransformEditor extends Form implements CommandListener, ItemCommandListener, ItemStateListener
{
	protected Transform transform;
	protected VectorImage image;
	protected ArrayData data;
	
	protected TextField tfName;
	
	protected TextField tfStartFrame, tfEndFrame;
	protected TextField tfPreGap, tfPostGap;
	protected ChoiceGroup cgMode;
	
	protected ChoiceGroup cgParam;
	protected TextField tfSubParam;
	
	protected ChoiceGroup cgFunction;
	protected TextField[] tfData;
	
	protected Command cmdPalette = new Command(Locale.getString(this, CustomLocale.PALETTE_CMD), Command.ITEM, 1);
	protected TextField clritem;
	
	public TransformEditor()
	{
		super(null);
		setTitle(Locale.getString(this, CustomLocale.TRANSFORM_EDITOR));
		
		tfName = new TemplateTextField(Locale.getString(this, CustomLocale.NAME), "", 256, TextField.ANY);
		
		tfStartFrame = new TextField(Locale.getString(this, CustomLocale.START_FRAME), "", 20, TextField.NUMERIC);
		tfEndFrame = new TextField(Locale.getString(this, CustomLocale.END_FRAME), "", 20, TextField.NUMERIC);
		tfPreGap = new TextField(Locale.getString(this, CustomLocale.PRE_GAP), "", 20, TextField.NUMERIC);
		tfPostGap = new TextField(Locale.getString(this, CustomLocale.POST_GAP), "", 20, TextField.NUMERIC);
		
		cgMode = new ChoiceGroup(Locale.getString(this, CustomLocale.TRANS_MODE), Choice.POPUP);
		cgMode.append(Locale.getString(this, CustomLocale.TRANS_NORMAL), null);
		cgMode.append(Locale.getString(this, CustomLocale.TRANS_EXTEND), null);
		cgMode.append(Locale.getString(this, CustomLocale.TRANS_LOOP), null);
		cgMode.append(Locale.getString(this, CustomLocale.TRANS_SLIDE), null);
		cgMode.append(Locale.getString(this, CustomLocale.TRANS_TRIGGER), null);
		
		cgParam = new ChoiceGroup(Locale.getString(this, CustomLocale.PARAM), ChoiceGroup.POPUP);
		
		for(int i = 0; i <= VectorElement.INT_B; i++)
		{
			cgParam.append(VectorElement.getTransformPrefix(i, -1), null);
		}
		
		tfSubParam = new TextField(Locale.getString(this, CustomLocale.SUBPARAM), "", 20, TextField.NUMERIC);
		
		cgFunction = new ChoiceGroup(Locale.getString(this, CustomLocale.FX_TYPE), Choice.POPUP);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_LINEAR), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_INTEGER), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_HARMONIC), null);
		cgFunction.append(Locale.getString(this, CustomLocale.FX_CUBIC), null);
		
		tfData = new TextField[8];
		
		tfData[0] = new TextField(VectorElement.getTransformPrefix(VectorElement.VAL_A, -1), "", 20, TextField.DECIMAL);
		tfData[1] = new TextField(VectorElement.getTransformPrefix(VectorElement.VAL_B, -1), "", 20, TextField.DECIMAL);
		tfData[2] = new TextField(VectorElement.getTransformPrefix(VectorElement.DIV_A, -1), "", 20, TextField.DECIMAL);
		tfData[3] = new TextField(VectorElement.getTransformPrefix(VectorElement.DIV_B, -1), "", 20, TextField.DECIMAL);
		tfData[4] = new TextField(VectorElement.getTransformPrefix(VectorElement.DIV_C, -1), "", 20, TextField.DECIMAL);
		tfData[5] = new TextField(VectorElement.getTransformPrefix(VectorElement.DIV_D, -1), "", 20, TextField.DECIMAL);
		tfData[6] = new TextField(VectorElement.getTransformPrefix(VectorElement.INT_A, -1), "", 20, TextField.ANY | TextField.NON_PREDICTIVE);
		tfData[7] = new TextField(VectorElement.getTransformPrefix(VectorElement.INT_B, -1), "", 20, TextField.ANY | TextField.NON_PREDICTIVE);
		
		tfData[6].setItemCommandListener(this);
		tfData[7].setItemCommandListener(this);
		
		addCommand(new Command(Locale.getString(this, CustomLocale.OK_CMD), Command.BACK, 1));
		setCommandListener(this);
		
		setItemStateListener(this);
	}
	
	public void setCurrentTransform(Transform transform, VectorImage image)
	{
		this.transform = transform;
		this.image = image;
		
		//deleteAll();
		
		tfName.setString(transform.getName());
		
		tfStartFrame.setString(Integer.toString(transform.getStartFrame()));
		tfEndFrame.setString(Integer.toString(transform.getEndFrame()));
		tfPreGap.setString(Integer.toString(transform.getPreGap()));
		tfPostGap.setString(Integer.toString(transform.getPostGap()));
		
		cgMode.setSelectedIndex(transform.getMode(), true);
		
		cgParam.setSelectedIndex(transform.getParam(), true);
		
		tfSubParam.setString(Integer.toString(transform.getSubParam()));
		
		data = transform.getData();
		
		cgFunction.setSelectedIndex(data.type, true);
		
		tfData[0].setString(Double.toString(data.vala));
		tfData[1].setString(Double.toString(data.valb));
		tfData[2].setString(Double.toString(data.diva));
		tfData[3].setString(Double.toString(data.divb));
		tfData[4].setString(Double.toString(data.divc));
		tfData[5].setString(Double.toString(data.divd));
		
		try
		{
			tfData[6].removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		try
		{
			tfData[7].removeCommand(cmdPalette);
			removeCommand(cmdPalette);
		}
		catch(Exception e)
		{
		}
		
		if(transform.getParam() == VectorElement.COLOR)
		{
			tfData[6].setString(Integer.toHexString(data.inta).toUpperCase());
			tfData[7].setString(Integer.toHexString(data.intb).toUpperCase());
			
			tfData[6].addCommand(cmdPalette);
			tfData[7].addCommand(cmdPalette);
		}
		else
		{
			tfData[6].setString(Integer.toString(data.inta));
			tfData[7].setString(Integer.toString(data.intb));
		}
		
		append(tfName);
		append(tfStartFrame);
		append(tfEndFrame);
		append(tfPreGap);
		append(tfPostGap);
		append(cgMode);
		append(cgParam);
		append(tfSubParam);
		append(cgFunction);
		append(tfData[0]);
		append(tfData[1]);
		append(tfData[2]);
		append(tfData[3]);
		append(tfData[4]);
		append(tfData[5]);
		append(tfData[6]);
		append(tfData[7]);
	}
	
	public void itemStateChanged(Item item)
	{
		if(item == tfName)
		{
			transform.setName(tfName.getString());
		}
		else if(item == tfStartFrame ||
		        item == tfEndFrame ||
		        item == tfPreGap ||
		        item == tfPostGap)
		{
			transform.setBounds(Integer.parseInt(tfStartFrame.getString()),
			                    Integer.parseInt(tfEndFrame.getString()),
			                    Integer.parseInt(tfPreGap.getString()),
			                    Integer.parseInt(tfPostGap.getString()));
		}
		else if(item == cgMode)
		{
			transform.setMode(cgMode.getSelectedIndex());
		}
		else if(item == cgParam)
		{
			transform.setParam(cgParam.getSelectedIndex());
			
			transform.setName(image.currentTransformName(transform.getParam(), transform.getSubParam()));
			tfName.setString(transform.getName());
			
			try
			{
				tfData[6].removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			try
			{
				tfData[7].removeCommand(cmdPalette);
				removeCommand(cmdPalette);
			}
			catch(Exception e)
			{
			}
			
			if(transform.getParam() == VectorElement.COLOR)
			{
				tfData[6].setString(Integer.toHexString(data.inta).toUpperCase());
				tfData[7].setString(Integer.toHexString(data.intb).toUpperCase());
				
				tfData[6].addCommand(cmdPalette);
				tfData[7].addCommand(cmdPalette);
			}
			else
			{
				tfData[6].setString(Integer.toString(data.inta));
				tfData[7].setString(Integer.toString(data.intb));
			}
		}
		else if(item == tfSubParam)
		{
			transform.setSubParam(Integer.parseInt(tfSubParam.getString()));
			
			transform.setName(image.currentTransformName(transform.getParam(), transform.getSubParam()));
			tfName.setString(transform.getName());
		}
		else if(item == cgFunction)
		{
			data.type = cgFunction.getSelectedIndex();
		}
		else if(item == tfData[0])
		{
			data.vala = Double.parseDouble(tfData[0].getString());
		}
		else if(item == tfData[1])
		{
			data.valb = Double.parseDouble(tfData[1].getString());
		}
		else if(item == tfData[2])
		{
			data.diva = Double.parseDouble(tfData[2].getString());
		}
		else if(item == tfData[3])
		{
			data.divb = Double.parseDouble(tfData[3].getString());
		}
		else if(item == tfData[4])
		{
			data.divc = Double.parseDouble(tfData[4].getString());
		}
		else if(item == tfData[5])
		{
			data.divd = Double.parseDouble(tfData[5].getString());
		}
		else if(item == tfData[6])
		{
			try
			{
				if(transform.getParam() == VectorElement.COLOR)
				{
					data.inta = (int)Long.parseLong(tfData[6].getString(), 16);
				}
				else
				{
					data.inta = Integer.parseInt(tfData[6].getString());
				}
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		else if(item == tfData[7])
		{
			try
			{
				if(transform.getParam() == VectorElement.COLOR)
				{
					data.intb = (int)Long.parseLong(tfData[7].getString(), 16);
				}
				else
				{
					data.intb = Integer.parseInt(tfData[7].getString());
				}
			}
			catch(NumberFormatException nfe)
			{
			}
		}
	}
	
	public void commandAction(Command c, Item item)
	{
		if(c == cmdPalette)
		{
			if(item instanceof TextField)
			{
				try
				{
					VIArt.showPalette(this, (int)Long.parseLong(((TextField)item).getString(), 16), false);
					clritem = (TextField)item;
				}
				catch(NumberFormatException nfe)
				{
				}
			}
		}
	}
	
	public void commandAction(Command c, Displayable dp)
	{
		if(dp instanceof Renderer)
		{
			PaintableObject po = ((Renderer)dp).getCurrent();
			
			if(po instanceof Palette)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showColorSelector(this, ((Palette)po).getColor());
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((Palette)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showTransformEditor(null, null);
						break;
				}
			}
			else if(po instanceof ColorSelector)
			{
				switch(c.getCommandType())
				{
					case Command.ITEM:
						VIArt.showPalette(this, ((ColorSelector)po).getColor(), true);
						break;
					
					case Command.OK:
						clritem.setString(Integer.toHexString(((ColorSelector)po).getColor()).toUpperCase());
						itemStateChanged(clritem);
					
					default:
						VIArt.showTransformEditor(null, null);
						break;
				}
			}
		}
		else if(dp == this)
		{
			image.nextTransformName(transform.getParam(), transform.getSubParam());
			VIArt.showObjectBrowser(ObjectBrowser.VIEW_CURRENT);
		}
	}
}