package modules.viart;

import com.one.FileSystemObject;
import com.classpath.zip.GZIPOutputStream;
import com.one.GIFFile;
import com.one.PNGFile;
import com.one.PaintableObject;
import com.one.file.Connector;
import com.one.file.FileConnection;
import com.one.vector.ArrayData;
import com.one.vector.Bitmap;
import com.one.vector.Effect;
import com.one.vector.Group;
import com.one.vector.Transform;
import com.one.vector.VectorElement;
import com.one.vector.VectorImage;
import com.vmx.Locale;
import filemanager.ColorSelector;
import filemanager.GraphicAlert;
import filemanager.ListMenu;
import filemanager.MenuListener;
import filemanager.Palette;
import filemanager.TemplateManager;
import filemanager.main;
import filemanager.options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

public class VIArt
{
	public static final String EXT_MVI = ".mvi";
	public static final String EXT_GIF = ".gif";
	public static final String EXT_PNG = ".png";
	public static final String EXT_SVG = ".svg";
	public static final String EXT_SVGZ = ".svgz";
	
	protected static EditCanvas edc;
	protected static MainMenu mn;
	protected static ListMenu lm;
	protected static FileBrowser fbr;
	protected static ObjectBrowser obr;
	protected static ObjectEditor oe;
	protected static ImageProperties ip;
	protected static TransformEditor te;
	protected static EffectEditor ee;
	protected static ColorSelector cs;
	protected static Palette plt;
	protected static DrawOptions opt;
	
	protected static TextBox tb;
	protected static int export;

	protected static String nextFile;

	protected static boolean alreadyStarted = false;
	
	public static void load()
	{
		if(alreadyStarted)
		{
			return;
		}

		alreadyStarted = true;

		SplashScreen splash = new SplashScreen();
		splash.setMaxState(8);
		splash.setMessage(Locale.getString(VIArt.class.getName(), CustomLocale.PRESS_ANY_KEY));
		main.dsp.setCurrent(splash);
		
		try
		{
			edc = new EditCanvas();
			splash.nextState();

			Listener listener = new Listener();
			
			mn = new MainMenu();
			mn.setMenuListener(listener);
			splash.nextState();
			
			lm = new ListMenu();
			splash.nextState();
			
			fbr = new FileBrowser(new FileSystemObject(), lm);
			splash.nextState();
			
			obr = new ObjectBrowser(lm);
			splash.nextState();
			
			//oe = new ObjectEditor();
			//splash.nextState();
			
			//ip = new ImageProperties();
			//splash.nextState();
			
			//te = new TransformEditor();
			//splash.nextState();
			
			//ee = new EffectEditor();
			//splash.nextState();
			
			plt = new Palette();
			splash.nextState();
			
			cs = new ColorSelector();
			splash.nextState();
			
			//opt = new DrawOptions();
			//splash.nextState();
			
			tb = new TextBox(Locale.getString(VIArt.class.getName(), CustomLocale.FILE_NAME), "", 256, TextField.ANY);
			tb.addCommand(new Command(Locale.getString(VIArt.class.getName(), CustomLocale.OK_CMD), Command.OK, 1));
			tb.addCommand(new Command(Locale.getString(VIArt.class.getName(), Locale.TEMPLATES_CMD), Command.ITEM, 2));
			tb.addCommand(new Command(Locale.getString(VIArt.class.getName(), CustomLocale.CANCEL_CMD), Command.BACK, 3));
			tb.setCommandListener(listener);
			splash.nextState();
			
			updateRuntimeOptions();
			Thread.sleep(100);
			splash.setState(-1);
		}
		catch(Throwable t)
		{
			t.printStackTrace();
			
			splash.setMessage(null);
			splash.setState(-1);
		}
	}

	public static void unload()
	{
		alreadyStarted = false;
		
		edc = null;
		mn = null;
		lm = null;
		fbr = null;
		obr = null;
		plt = null;
		cs = null;
		tb = null;
	}

	public static void exit()
	{
		if(options.unloadModules)
		{
			unload();
		}

		main.FileSelect.showWait(main.currentFile);
	}
	
	public static void updateRuntimeOptions()
	{
		cs.setInteractive(!options.noEffects);
		edc.setZoomMode(!options.noEffects);
	}
	
	public static void showMainMenu()
	{
		main.dsp.setCurrent(mn);
	}
	
	public static void showMemoryMonitor(PaintableObject po)
	{
		main.monitor.show(po);
	}
	
	public static void showOptionsEditor()
	{
		(new OptionsEditor()).showEditor(main.dsp.getCurrent());
	}
	
	public static void showEdit(boolean create)
	{
		if(create)
		{
			edc.setCurrentImage(null);
			obr.setCurrentImage(edc.getCurrentImage());
			
			showImageProperties(edc.getCurrentImage());
		}
		else
		{
			main.dsp.setCurrent(edc);
		}
	}
	
	public static void setEditScaleMode(boolean flag)
	{
		edc.setScaleMode(flag);
	}
	
	public static void setEditCurrentGroup(Group grp)
	{
		edc.setCurrentGroup(grp);
	}
	
	public static void setEditCurrentElement(VectorElement ve)
	{
		edc.setCurrentElement(ve);
	}
	
	public static void showPalette(CommandListener listener, int color, boolean force)
	{
		if(plt.setColor(color) || force)
		{
			plt.setCommandListener(listener);
			main.dsp.setCurrent(plt);
		}
		else
		{
			cs.setColor(color);
			cs.setCommandListener(listener);
			main.dsp.setCurrent(cs);
		}
	}
	
	public static void showColorSelector(CommandListener listener, int color)
	{
		cs.setColor(color);
		cs.setCommandListener(listener);
		main.dsp.setCurrent(cs);
	}
	
	public static void showDrawOptions(boolean reset)
	{
		if(reset)
		{
			opt = new DrawOptions();
			opt.reset();
		}
		
		main.dsp.setCurrent(opt);
	}
	
	public static void showObjectBrowser(int view)
	{
		obr.init(view);
		main.dsp.setCurrent(lm);
	}
	
	public static void showObjectEditor(VectorElement element)
	{
		if(element != null)
		{
			oe = new ObjectEditor();
			oe.setCurrentElement(element);
		}
		
		main.dsp.setCurrent(oe);
	}
	
	public static void showTransformEditor(Transform transform, VectorImage image)
	{
		if(transform != null && image != null)
		{
			te = new TransformEditor();
			te.setCurrentTransform(transform, image);
		}
		
		main.dsp.setCurrent(te);
	}
	
	public static void showEffectEditor(Effect effect)
	{
		if(effect != null)
		{
			ee = new EffectEditor();
			ee.setCurrentEffect(effect);
		}
		
		main.dsp.setCurrent(ee);
	}
	
	public static void showImageProperties(VectorImage image)
	{
		if(image != null)
		{
			ip = new ImageProperties();
			ip.setCurrentImage(image);
		}
		
		main.dsp.setCurrent(ip);
	}
	
	public static void showToolList(CommandListener listener, boolean elements, boolean transforms, boolean effects, int sel)
	{
		lm.setTitle(Locale.getString(VIArt.class.getName(), CustomLocale.TOOLS_CMD));
		lm.setSubTitle(Locale.getString(VIArt.class.getName(), CustomLocale.ROOT), false);
		
		lm.deleteAll();
		
		int i;
		
		if(elements)
		{
			for(i = VectorElement.OFFSET_ELEMENTS; i < VectorElement.OFFSET_TRANSFORMS; i++)
			{
				lm.append(VectorElement.OBJECT_NAMES[i]);
			}
		}
		
		if(transforms)
		{
			for(i = VectorElement.OFFSET_TRANSFORMS; i < VectorElement.OFFSET_EFFECTS; i++)
			{
				lm.append(VectorElement.OBJECT_NAMES[i]);
			}
		}
		
		if(effects)
		{
			for(i = VectorElement.OFFSET_EFFECTS; i < VectorElement.OBJECT_NAMES.length; i++)
			{
				lm.append(VectorElement.OBJECT_NAMES[i]);
			}
		}
		
		lm.setSelectedIndex(sel);
		
		lm.removeAllCommands();
		lm.addCommand(new Command(Locale.getString(VIArt.class.getName(), CustomLocale.OK_CMD), Command.OK, 1));
		lm.addCommand(new Command(Locale.getString(VIArt.class.getName(), CustomLocale.CANCEL_CMD), Command.CANCEL, 2));
		
		lm.setCommandListener(listener);
		lm.setStateListener(null);
		
		main.dsp.setCurrent(lm);
	}
	
	public static void showFileBrowser(FileNameListener listener)
	{
		fbr.init(listener, FileBrowser.MODE_BROWSE);
		main.dsp.setCurrent(lm);
	}
	
	public static void showOpen()
	{
		fbr.init(null, FileBrowser.MODE_OPEN);
		main.dsp.setCurrent(lm);
	}
	
	public static void showSave()
	{
		fbr.init(null, FileBrowser.MODE_SAVE);
		main.dsp.setCurrent(lm);
	}
	
	public static void showSaveFileName(String fname, int fmt)
	{
		export = fmt;
		
		if(fmt == 1)
		{
			if(OptionsEditor.compressSVG)
			{
				if(!fname.endsWith(EXT_SVGZ))
				{
					fname += EXT_SVGZ;
				}
			}
			else
			{
				if(!fname.endsWith(EXT_SVG))
				{
					fname += EXT_SVG;
				}
			}
		}
		else if(fmt == 2)
		{
			if(!fname.endsWith(EXT_PNG))
			{
				fname += EXT_PNG;
			}
		}
		else if(fmt == 3)
		{
			if(!fname.endsWith(EXT_GIF))
			{
				fname += EXT_GIF;
			}
		}
		else
		{
			if(!fname.endsWith(EXT_MVI))
			{
				fname += EXT_MVI;
			}
		}
		
		tb.setString(fname);
		main.dsp.setCurrent(tb);
	}

	public static void setNextFile(String nextFile)
	{
		VIArt.nextFile = nextFile;
	}
	
	public static void importFile(String fname)
	{
		try
		{
			VectorImage vi = new VectorImage();
			
			Image img = Image.createImage(Connector.openInputStream("file:///" + fname));
			vi.setNativeSize(img.getWidth(), img.getHeight());
			img = null;
			
			edc.setCurrentImage(vi);
			obr.setCurrentImage(vi);
			edc.setScaleMode(OptionsEditor.scaleImported);
			
			Group grp = new Group();
			vi.addGroup(grp);
			
			Bitmap bitmap = new Bitmap();
			bitmap.setValue(fname, VectorElement.FILE, -1);
			bitmap.setValue(new Integer(OptionsEditor.scaleImported ? Bitmap.MODE_SCALE : Bitmap.MODE_NORMAL), VectorElement.MODE, -1);
			bitmap.setValue(new Double(1), VectorElement.WIDTH, -1);
			bitmap.setValue(new Double(1), VectorElement.HEIGHT, -1);
			bitmap.create();
			grp.addElement(bitmap);
			
			showEdit(false);
		}
		catch(IOException e)
		{
		}
	}
	
	public static void importFolder(String fname)
	{
		try
		{
			FileConnection fc = (FileConnection)Connector.open("file:///" + fname);
			Enumeration files = FileSystemObject.sortFileList(fc.list());
			fc.close();
			
			if(files == null)
			{
				return;
			}
			
			String s;
			InputStream is;
			Image img;
			
			Vector v = new Vector();
			
			int width = 0;
			int height = 0;
			
			while(files.hasMoreElements())
			{
				try
				{
					s = fname + (String)files.nextElement();
					
					if(s.endsWith("/"))
					{
						continue;
					}
					
					is = Connector.openInputStream("file:///" + s);
					img = Image.createImage(is);
					is.close();
					
					if(img.getWidth() > width && img.getHeight() > height)
					{
						width = img.getWidth();
						height = img.getHeight();
					}
					
					img = null;
					
					v.addElement(s);
				}
				catch(Throwable t)
				{
				}
			}
			
			files = v.elements();
			
			VectorImage vi = new VectorImage();
			vi.setNativeSize(width, height);
			
			edc.setCurrentImage(vi);
			obr.setCurrentImage(vi);
			edc.setScaleMode(OptionsEditor.scaleImported);
			
			Group grp = new Group();
			vi.addGroup(grp);
			
			Bitmap bitmap;
			
			while(files.hasMoreElements())
			{
				bitmap = new Bitmap();
				bitmap.setValue(files.nextElement(), VectorElement.FILE, -1);
				bitmap.setValue(new Integer(OptionsEditor.scaleImported ? Bitmap.MODE_SCALE : Bitmap.MODE_NORMAL), VectorElement.MODE, -1);
				bitmap.setValue(new Double(1), VectorElement.WIDTH, -1);
				bitmap.setValue(new Double(1), VectorElement.HEIGHT, -1);
				bitmap.create();
				grp.addElement(bitmap);
				
				bitmap.addTransform(new Transform(new ArrayData(0.0f, 1.0f), VectorElement.SHOW, vi.currentFrame(), vi.currentFrame(), Transform.TRIGGER), true);
				bitmap.addTransform(new Transform(new ArrayData(1.0f, 0.0f), VectorElement.SHOW, vi.currentFrame() + 1, vi.currentFrame() + 1, Transform.TRIGGER), true);
				
				vi.setMaxFrame(vi.getMaxFrame() + 1);
				vi.nextFrame();
			}
			
			vi.gotoFrame(0);
			vi.setMaxFrame(vi.getMaxFrame() - 1);
			
			showImageProperties(vi);
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public static void openFile(String fname)
	{
		FileConnection fc = null;
		DataInputStream dis = null;
		
		try
		{
			fc = (FileConnection)Connector.open("file:///" + fname);
			
			dis = fc.openDataInputStream();
			
			edc.setCurrentImage(new VectorImage(dis));
			obr.setCurrentImage(edc.getCurrentImage());
			
			dis.close();
			fc.close();
			
			showEdit(false);
		}
		catch(IOException e)
		{
			try
			{
				dis.close();
				fc.close();
			}
			catch(Exception e2)
			{
			}
			
			if(fname.endsWith("/"))
			{
				importFolder(fname);
			}
			else
			{
				importFile(fname);
			}
		}
		
		/*
		try
		{
			dis = new DataInputStream(new ByteArrayInputStream(edc.getCurrentImage().getExtra()));
			
			DrawOptions.readOptions(dis);
			edc.readWorkspaceState(dis);
			
			dis.close();
		}
		catch(Exception e)
		{
		}
		*/
	}
	
	public static void saveFile(String fname)
	{
		DataOutputStream dos;
		
		/*
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			dos = new DataOutputStream(baos);
			
			DrawOptions.writeOptions(dos);
			edc.writeWorkspaceState(dos);
			
			edc.getCurrentImage().setExtra(baos.toByteArray());
			
			dos.close();
		}
		catch(Exception e)
		{
		}
		*/
		
		try
		{
			FileConnection fc = (FileConnection)Connector.open("file:///" + fname);
			
			if(fc.exists())
			{
				fc.truncate(0);
			}
			else
			{
				fc.create();
			}
			
			dos = fc.openDataOutputStream();
			
			edc.getCurrentImage().write(dos);
			
			dos.close();
			fc.close();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		
		showMainMenu();
	}
	
	public static void exportSVG(String fname)
	{
		try
		{
			final VectorImage vi = edc.getCurrentImage();
			
			final FileConnection fc = (FileConnection)Connector.open("file:///" + fname);
			
			if(fc.exists())
			{
				fc.truncate(0);
			}
			else
			{
				fc.create();
			}
			
			final PrintStream ps;
			
			if(OptionsEditor.compressSVG)
			{
				ps = new PrintStream(new GZIPOutputStream(fc.openOutputStream()));
			}
			else
			{
				ps = new PrintStream(fc.openOutputStream());
			}
			
			final GraphicAlert alert = new GraphicAlert(Locale.getString(VIArt.class.getName(), CustomLocale.EXPORT_SVG_CMD), Locale.getString(VIArt.class.getName(), CustomLocale.PLEASE_WAIT), null, AlertType.WARNING);
			alert.setIndicator(true);
			main.dsp.setCurrent(alert);
			
			final String notice = "Generated-By: VIArt v" + main.loader.getAppProperty("MIDlet-Version");
			
			Runnable runnable = new Runnable()
			{
				public void run()
				{
					vi.writeSVG(ps, notice, alert);
					
					ps.close();
					
					try
					{
						fc.close();
					}
					catch(IOException e)
					{
						e.printStackTrace();
					}
					
					showMainMenu();
				}
			};
			
			(new Thread(runnable)).start();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public static void exportPNG(String fname)
	{
		try
		{
			final Image img = edc.getRenderImage();
			
			if(img == null)
			{
				return;
			}
			
			final FileConnection fc = (FileConnection)Connector.open("file:///" + fname);
			
			if(fc.exists())
			{
				fc.truncate(0);
			}
			else
			{
				fc.create();
			}
			
			final DataOutputStream dos = fc.openDataOutputStream();
			
			final GraphicAlert alert = new GraphicAlert(Locale.getString(VIArt.class.getName(), CustomLocale.EXPORT_PNG_CMD), Locale.getString(VIArt.class.getName(), CustomLocale.PLEASE_WAIT), null, AlertType.WARNING);
			alert.setIndicator(true);
			main.dsp.setCurrent(alert);
			
			Runnable runnable = new Runnable()
			{
				public void run()
				{
					try
					{
						PNGFile.writePNG(img, dos, PNGFile.TRUECOLOR, PNGFile.FILTER_AUTO, alert);
						
						dos.close();
						fc.close();
					}
					catch(IOException e)
					{
						e.printStackTrace();
					}
					
					showMainMenu();
				}
			};
			
			(new Thread(runnable)).start();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public static void frameoutPNG(String fname)
	{
		try
		{
			final Image img = edc.getRenderImage();
			
			if(img == null)
			{
				return;
			}
			
			final VectorImage vi = edc.getCurrentImage();
			final Graphics g = img.getGraphics();
			
			FileConnection conn = (FileConnection)Connector.open("file:///" + fname);
			
			if(!conn.exists())
			{
				conn.mkdir();
			}
			
			conn.close();
			
			final String dir = fname;
			
			final GraphicAlert alert = new GraphicAlert(Locale.getString(VIArt.class.getName(), CustomLocale.EXPORT_PNG_CMD), Locale.getString(VIArt.class.getName(), CustomLocale.PLEASE_WAIT), null, AlertType.WARNING);
			alert.setIndicator(true);
			main.dsp.setCurrent(alert);
			
			Runnable runnable = new Runnable()
			{
				public void run()
				{
					int prevframe = vi.currentFrame();
					vi.gotoFrame(0);
					
					String maxframe = Integer.toString(vi.getMaxFrame());
					String frame;
					
					int length = maxframe.length();
					
					try
					{
						do
						{
							frame = Integer.toString(vi.currentFrame());
							alert.setString(Locale.getString(this, CustomLocale.FRAMEOUT_MESSAGE) + " " + frame + " / " + maxframe);
							
							while(frame.length() < length)
							{
								frame = "0" + frame;
							}
							
							vi.paint(g, 0, 0);
							
							FileConnection fc = (FileConnection)Connector.open("file:///" + dir + frame + EXT_PNG);
							
							if(fc.exists())
							{
								fc.truncate(0);
							}
							else
							{
								fc.create();
							}
							
							DataOutputStream dos = fc.openDataOutputStream();
							
							PNGFile.writePNG(img, dos, PNGFile.TRUECOLOR, PNGFile.FILTER_AUTO, alert);
							
							dos.close();
							fc.close();
						}
						while(vi.nextFrame());
					}
					catch(IOException e)
					{
						e.printStackTrace();
					}
					
					vi.gotoFrame(prevframe);
					
					showMainMenu();
				}
			};
			
			(new Thread(runnable)).start();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
	
	public static void exportGIF(String fname)
	{
		try
		{
			final Image img = edc.getRenderImage();
			
			if(img == null)
			{
				return;
			}
			
			final VectorImage vi = edc.getCurrentImage();
			final Graphics g = img.getGraphics();
			
			final FileConnection fc = (FileConnection)Connector.open("file:///" + fname);
			
			if(fc.exists())
			{
				fc.truncate(0);
			}
			else
			{
				fc.create();
			}
			
			final GraphicAlert alert = new GraphicAlert(Locale.getString(VIArt.class.getName(), CustomLocale.EXPORT_GIF_CMD), Locale.getString(VIArt.class.getName(), CustomLocale.PLEASE_WAIT), null, AlertType.WARNING);
			alert.setIndicator(true);
			main.dsp.setCurrent(alert);
			
			int loop = vi.getLoopCount();
			
			if(loop < 0)
			{
				loop = 0;
			}
			else if(loop == 0)
			{
				loop = 1;
			}
			
			final OutputStream os = fc.openOutputStream();
			final GIFFile gif = new GIFFile(os, OptionsEditor.quantizeGIF ? null : Palette.UNIFIED_PALETTE, vi.getBackColor(), img.getWidth(), img.getHeight(), loop);
			
			Runnable runnable = new Runnable()
			{
				public void run()
				{
					int prevframe = vi.currentFrame();
					vi.gotoFrame(0);
					
					int prevloop = vi.getLoopCount();
					vi.setLoopCount(0);
					
					int delay = ((int)vi.getFrameDelay() + 5) / 10;
					
					String maxframe = Integer.toString(vi.getMaxFrame());
					String frame;
					
					try
					{
						do
						{
							frame = Integer.toString(vi.currentFrame());
							alert.setString(Locale.getString(this, CustomLocale.FRAMEOUT_MESSAGE) + " " + frame + " / " + maxframe);
							
							vi.paint(g, 0, 0);
							gif.writeImage(img, delay, OptionsEditor.quantizeGIF, OptionsEditor.ditherGIF, alert);
						}
						while(vi.nextFrame());
						
						gif.finish();
						os.close();
						fc.close();
					}
					catch(IOException e)
					{
						e.printStackTrace();
					}
					
					vi.gotoFrame(prevframe);
					vi.setLoopCount(prevloop);
					
					showMainMenu();
				}
			};
			
			(new Thread(runnable)).start();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}

	protected static class Listener implements MenuListener, CommandListener
	{
		public void menuAction(int string)
		{
			switch(string)
			{
				case CustomLocale.CREATE_CMD:
					showEdit(true);
					break;

				case CustomLocale.OPEN_CMD:
					showOpen();
					break;

				case CustomLocale.SAVE_CMD:
					if(edc.getCurrentImage() != null)
					{
						if(nextFile != null)
						{
							saveFile(nextFile);
							nextFile = null;
						}
						else
						{
							showSave();
							break;
						}
					}

				case CustomLocale.BACK_CMD:
					if(edc.getCurrentImage() != null)
					{
						showEdit(false);
					}
					break;

				case CustomLocale.PREFS_CMD:
					showOptionsEditor();
					break;

				case CustomLocale.EXIT_CMD:
					exit();
					break;
			}
		}

		public void commandAction(Command c, Displayable dp)
		{
			if(dp == tb)
			{
				if(c.getCommandType() == Command.OK)
				{
					if(export == 1)
					{
						exportSVG(tb.getString());
					}
					else if(export == 2)
					{
						String s = tb.getString();

						if(s.endsWith("/"))
						{
							s = s.substring(0, s.length() - 1);

							if(s.lastIndexOf('.') < s.lastIndexOf('/'))
							{
								frameoutPNG(tb.getString());
							}
							else
							{
								exportPNG(tb.getString());
							}
						}
						else
						{
							exportPNG(tb.getString());
						}
					}
					else if(export == 3)
					{
						exportGIF(tb.getString());
					}
					else
					{
						saveFile(tb.getString());
					}
				}
				else if(c.getCommandType() == Command.ITEM)
				{
					TemplateManager.showTemplateList(tb, tb);
				}
				else
				{
					showMainMenu();
				}
			}
		}
	};
}