package org.apache.commons.compress.compressors.bzip2;

import org.apache.commons.compress.compressors.SingleFileContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;

public class BZip2Archive extends SingleFileContainer
{
	public CompressorInputStream getCompressorInputStream(InputStream is) throws IOException
	{
		return new BZip2CompressorInputStream(is);
	}

	public CompressorOutputStream getCompressorOutputStream(OutputStream os) throws IOException
	{
		return new BZip2CompressorOutputStream(os);
	}
}
