package org.apache.commons.compress.compressors.gzip;

import org.apache.commons.compress.compressors.SingleFileContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;

public class GZipArchive extends SingleFileContainer
{
	public CompressorInputStream getCompressorInputStream(InputStream is) throws IOException
	{
		return new GzipCompressorInputStream(is);
	}

	public CompressorOutputStream getCompressorOutputStream(OutputStream os) throws IOException
	{
		return new GzipCompressorOutputStream(os);
	}
}
