package unifm;


import com.vmx.AuxClass;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.*;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ResetRMS extends MIDlet implements CommandListener
{
	protected Form form;
	protected ChoiceGroup cgrms;

	protected static final Command cmdClear = new Command("Clear", Command.OK, 1);
	protected static final Command cmdClearAll = new Command("Clear all", Command.OK, 2);
	protected static final Command cmdExit = new Command("Exit", Command.EXIT, 3);

	public ResetRMS()
	{
		form = new Form("Reset RMS");

		form.append("If you are encountering a problem running this application due to incorrectly done settings or wrong stored data, you might want to clear some or all of the RMS storages listed below. Clearing a storage will cause the program to re-write it with the appropriate data, as if it was the first time it was launched.");

		cgrms = new ChoiceGroup("RMS storages", Choice.MULTIPLE, AuxClass.STORE_NAMES, null);
		form.append(cgrms);

		form.addCommand(cmdClear);
		form.addCommand(cmdClearAll);
		form.addCommand(cmdExit);
		form.setCommandListener(this);
	}

	public void startApp()
	{
		Display.getDisplay(this).setCurrent(form);
	}

	public void pauseApp()
	{
		notifyPaused();
	}

	public void destroyApp(boolean unconditional)
	{
		notifyDestroyed();
	}

	public void commandAction(Command c, Displayable dp)
	{
		boolean flag = true;

		if(c == cmdClear)
		{
			for(int i = 0; i < AuxClass.STORE_NAMES.length; i++)
			{
				if(cgrms.isSelected(i))
				{
					try
					{
						RecordStore.deleteRecordStore(AuxClass.getStoreName(i));
					}
					catch(RecordStoreNotFoundException rsnfe)
					{
					}
					catch(Exception e)
					{
						form.append(e.toString());
						flag = false;
					}
				}
			}
		}
		else if(c == cmdClearAll)
		{
			String[] stores = RecordStore.listRecordStores();

			for(int i = 0; i < stores.length; i++)
			{
				try
				{
					RecordStore.deleteRecordStore(stores[i]);
				}
				catch(RecordStoreNotFoundException rsnfe)
				{
				}
				catch(Exception e)
				{
					form.append(e.toString());
					flag = false;
				}
			}
		}

		if(flag)
		{
			destroyApp(false);
		}
	}
}
