/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import ru.untaba.utils.zip.core.DeflaterHuffman;
import ru.untaba.utils.zip.utils.io.InternalError;

class DeflaterHuffman$Tree {
    short[] freqs;
    short[] codes;
    byte[] length;
    int[] bl_counts;
    int minNumCodes;
    int numCodes;
    int maxLength;
    private final DeflaterHuffman a;

    DeflaterHuffman$Tree(DeflaterHuffman deflaterHuffman, int n, int n2, int n3) {
        this.a = deflaterHuffman;
        this.minNumCodes = n2;
        this.maxLength = n3;
        this.freqs = new short[n];
        this.bl_counts = new int[n3];
    }

    void reset() {
        for (int i = 0; i < this.freqs.length; ++i) {
            this.freqs[i] = 0;
        }
        this.codes = null;
        this.length = null;
    }

    final void writeSymbol(int n) {
        this.a.pending.writeBits(this.codes[n] & 0xFFFF, this.length[n]);
    }

    final void checkEmpty() {
        boolean bl = true;
        for (int i = 0; i < this.freqs.length; ++i) {
            if (this.freqs[i] == 0) continue;
            System.err.println("freqs[" + i + "] == " + this.freqs[i]);
            bl = false;
        }
        if (!bl) {
            throw new InternalError();
        }
        System.err.println("checkEmpty suceeded!");
    }

    void setStaticCodes(short[] sArray, byte[] byArray) {
        this.codes = sArray;
        this.length = byArray;
    }

    public void buildCodes() {
        int n;
        int[] nArray = new int[this.maxLength];
        int n2 = 0;
        this.codes = new short[this.freqs.length];
        for (n = 0; n < this.maxLength; ++n) {
            nArray[n] = n2;
            n2 += this.bl_counts[n] << 15 - n;
        }
        for (n = 0; n < this.numCodes; ++n) {
            n2 = this.length[n];
            if (n2 <= 0) continue;
            this.codes[n] = DeflaterHuffman.bitReverse(nArray[n2 - 1]);
            int n3 = n2 - 1;
            nArray[n3] = nArray[n3] + (1 << 16 - n2);
        }
    }

    private void a(int[] nArray) {
        int n;
        this.length = new byte[this.freqs.length];
        int n2 = nArray.length / 2;
        int n3 = (n2 + 1) / 2;
        int n4 = 0;
        for (int i = 0; i < this.maxLength; ++i) {
            this.bl_counts[i] = 0;
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = nArray2;
        nArray2[n2 - 1] = 0;
        --n2;
        while (n2 >= 0) {
            if (nArray[n2 * 2 + 1] != -1) {
                n = nArray3[n2] + 1;
                if (n > this.maxLength) {
                    n = this.maxLength;
                    ++n4;
                }
                int n5 = n;
                nArray3[nArray[n2 * 2 + 1]] = n5;
                nArray3[nArray[n2 * 2]] = n5;
            } else {
                n = nArray3[n2];
                int n6 = n - 1;
                this.bl_counts[n6] = this.bl_counts[n6] + 1;
                this.length[nArray[n2 * 2]] = (byte)nArray3[n2];
            }
            --n2;
        }
        if (n4 == 0) {
            return;
        }
        n2 = this.maxLength - 1;
        while (true) {
            if (this.bl_counts[--n2] == 0) {
                continue;
            }
            do {
                int n7 = n2++;
                this.bl_counts[n7] = this.bl_counts[n7] - 1;
                int n8 = n2;
                this.bl_counts[n8] = this.bl_counts[n8] + 1;
            } while ((n4 -= 1 << this.maxLength - 1 - n2) > 0 && n2 < this.maxLength - 1);
            if (n4 <= 0) break;
        }
        int n9 = this.maxLength - 1;
        this.bl_counts[n9] = this.bl_counts[n9] + n4;
        int n10 = this.maxLength - 2;
        this.bl_counts[n10] = this.bl_counts[n10] - n4;
        n = n3 * 2;
        for (n2 = this.maxLength; n2 != 0; --n2) {
            n3 = this.bl_counts[n2 - 1];
            while (n3 > 0) {
                if (nArray[(n4 = 2 * nArray[n++]) + 1] != -1) continue;
                this.length[nArray[n4]] = (byte)n2;
                --n3;
            }
        }
    }

    void buildTree() {
        int n;
        int n2;
        int n3 = this.freqs.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            short s = this.freqs[n2];
            if (s == 0) continue;
            n5 = n4++;
            while (n5 > 0 && this.freqs[nArray[n = (n5 - 1) / 2]] > s) {
                nArray[n5] = nArray[n];
                n5 = n;
            }
            nArray[n5] = n2;
            n5 = n2;
        }
        while (n4 < 2) {
            n2 = n5 < 2 ? ++n5 : 0;
            nArray[n4++] = n2;
        }
        this.numCodes = Math.max(n5 + 1, this.minNumCodes);
        n2 = n4;
        int[] nArray2 = new int[n4 * 4 - 2];
        int[] nArray3 = new int[n4 * 2 - 1];
        n = n2;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3 * 2] = n2 = nArray[n3];
            nArray2[n3 * 2 + 1] = -1;
            nArray3[n3] = this.freqs[n2] << 8;
            nArray[n3] = n3;
        }
        do {
            n3 = nArray[0];
            n2 = nArray[--n4];
            int n6 = 0;
            int n7 = 1;
            while (n7 < n4) {
                if (n7 + 1 < n4 && nArray3[nArray[n7]] > nArray3[nArray[n7 + 1]]) {
                    ++n7;
                }
                nArray[n6] = nArray[n7];
                n6 = n7;
                n7 = (n7 << 1) + 1;
            }
            int n8 = nArray3[n2];
            while ((n7 = n6) > 0 && nArray3[nArray[n6 = (n7 - 1) / 2]] > n8) {
                nArray[n7] = nArray[n6];
            }
            nArray[n7] = n2;
            n6 = nArray[0];
            n2 = n++;
            nArray2[n2 * 2] = n3;
            nArray2[n2 * 2 + 1] = n6;
            n7 = Math.min(nArray3[n3] & 0xFF, nArray3[n6] & 0xFF);
            nArray3[n2] = n8 = nArray3[n3] + nArray3[n6] - n7 + 1;
            n6 = 0;
            n7 = 1;
            while (n7 < n4) {
                if (n7 + 1 < n4 && nArray3[nArray[n7]] > nArray3[nArray[n7 + 1]]) {
                    ++n7;
                }
                nArray[n6] = nArray[n7];
                n6 = n7;
                n7 = (n6 << 1) + 1;
            }
            while ((n7 = n6) > 0 && nArray3[nArray[n6 = (n7 - 1) / 2]] > n8) {
                nArray[n7] = nArray[n6];
            }
            nArray[n7] = n2;
        } while (n4 > 1);
        if (nArray[0] != nArray2.length / 2 - 1) {
            throw new RuntimeException("Weird!");
        }
        this.a(nArray2);
    }

    int getEncodedLength() {
        int n = 0;
        for (int i = 0; i < this.freqs.length; ++i) {
            n += this.freqs[i] * this.length[i];
        }
        return n;
    }

    void calcBLFreq(DeflaterHuffman$Tree deflaterHuffman$Tree) {
        byte by = -1;
        int n = 0;
        while (n < this.numCodes) {
            int n2;
            int n3 = 1;
            byte by2 = this.length[n];
            if (by2 == 0) {
                n2 = 138;
            } else {
                n2 = 6;
                if (by != by2) {
                    byte by3 = by2;
                    deflaterHuffman$Tree.freqs[by3] = (short)(deflaterHuffman$Tree.freqs[by3] + 1);
                    n3 = 0;
                }
            }
            by = by2;
            ++n;
            while (n < this.numCodes && by == this.length[n]) {
                ++n;
                if (++n3 < n2) continue;
            }
            if (n3 < 3) {
                byte by4 = by;
                deflaterHuffman$Tree.freqs[by4] = (short)(deflaterHuffman$Tree.freqs[by4] + n3);
                continue;
            }
            if (by != 0) {
                deflaterHuffman$Tree.freqs[16] = (short)(deflaterHuffman$Tree.freqs[16] + 1);
                continue;
            }
            if (n3 <= 10) {
                deflaterHuffman$Tree.freqs[17] = (short)(deflaterHuffman$Tree.freqs[17] + 1);
                continue;
            }
            deflaterHuffman$Tree.freqs[18] = (short)(deflaterHuffman$Tree.freqs[18] + 1);
        }
    }

    void writeTree(DeflaterHuffman$Tree deflaterHuffman$Tree) {
        byte by = -1;
        int n = 0;
        while (n < this.numCodes) {
            int n2;
            int n3 = 1;
            byte by2 = this.length[n];
            if (by2 == 0) {
                n2 = 138;
            } else {
                n2 = 6;
                if (by != by2) {
                    deflaterHuffman$Tree.writeSymbol(by2);
                    n3 = 0;
                }
            }
            by = by2;
            ++n;
            while (n < this.numCodes && by == this.length[n]) {
                ++n;
                if (++n3 < n2) continue;
            }
            if (n3 < 3) {
                while (n3-- > 0) {
                    deflaterHuffman$Tree.writeSymbol(by);
                }
                continue;
            }
            if (by != 0) {
                deflaterHuffman$Tree.writeSymbol(16);
                this.a.pending.writeBits(n3 - 3, 2);
                continue;
            }
            if (n3 <= 10) {
                deflaterHuffman$Tree.writeSymbol(17);
                this.a.pending.writeBits(n3 - 3, 3);
                continue;
            }
            deflaterHuffman$Tree.writeSymbol(18);
            this.a.pending.writeBits(n3 - 11, 7);
        }
    }
}

