/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class CoordinateLayout
extends Layout {
    private int a;
    private int b;

    public CoordinateLayout(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    public CoordinateLayout(Dimension dimension) {
        this(dimension.getWidth(), dimension.getHeight());
    }

    public void layoutContainer(Container container) {
        int n2 = container.getComponentCount();
        int n3 = container.getWidth();
        int n4 = container.getHeight();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponentAt(i2);
            int n5 = component.getX() * n3 / this.a;
            int n6 = component.getY() * n4 / this.b;
            component.setX(n5);
            component.setY(n6);
            component.setWidth(component.getPreferredW());
            component.setHeight(component.getPreferredH());
        }
        this.a = n3;
        this.b = n4;
    }

    public Dimension getPreferredSize(Container container) {
        Dimension dimension = new Dimension();
        int n2 = container.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponentAt(i2);
            dimension.setWidth(Math.max(dimension.getWidth(), component.getX() + component.getPreferredW()));
            dimension.setHeight(Math.max(dimension.getHeight(), component.getY() + component.getPreferredH()));
        }
        return dimension;
    }

    public boolean isOverlapSupported() {
        return true;
    }
}

