/*
 * Decompiled with CFR 0.152.
 */
package net.cachapa.weightwatch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.cachapa.weightwatch.util.MyDate;
import net.cachapa.weightwatch.util.Serialize;

public class Value
implements Serialize {
    public MyDate date;
    public double weight;
    public double trend;
    public int dbIndex;

    public Value() {
        this.date = new MyDate();
    }

    public Value(MyDate myDate, double d2) {
        this.date = myDate;
        this.weight = d2;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(this.date.getTime());
            dataOutputStream.writeDouble(this.weight);
            dataOutputStream.writeDouble(this.trend);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return null;
        }
    }

    public void fromByteArray(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.date = new MyDate(dataInputStream.readLong());
            this.weight = dataInputStream.readDouble();
            this.trend = dataInputStream.readDouble();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public String toString() {
        return this.date.toShortString() + ": " + this.weight + " Kg";
    }

    public long compareTo(Object object) {
        long l2 = this.date.getTime();
        long l3 = ((Value)object).date.getTime();
        return l2 - l3;
    }
}

