/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model.exercise.tasks;

import com.wordsteps.model.Word;

public abstract class WordDataSource {
    private Word word;

    public WordDataSource(Word word) {
        this.word = word;
    }

    protected Word getWord() {
        return this.word;
    }

    protected abstract String getStatement();

    protected abstract String getStatement(Word var1);

    protected abstract String getCorrectAnswer();

    protected abstract String getCorrectAnswer(Word var1);

    public static class ReverseTranslationDataSource
    extends WordDataSource {
        public ReverseTranslationDataSource(Word word) {
            super(word);
        }

        protected String getStatement() {
            return this.getWord().getTranslation();
        }

        protected String getStatement(Word word) {
            return word.getTranslation();
        }

        protected String getCorrectAnswer() {
            return this.getWord().getWord();
        }

        protected String getCorrectAnswer(Word word) {
            return word.getWord();
        }
    }

    public static class DirectTranslationDataSource
    extends WordDataSource {
        public DirectTranslationDataSource(Word word) {
            super(word);
        }

        protected String getStatement() {
            return this.getWord().getWord();
        }

        protected String getStatement(Word word) {
            return word.getWord();
        }

        protected String getCorrectAnswer() {
            return this.getWord().getTranslation();
        }

        protected String getCorrectAnswer(Word word) {
            return word.getTranslation();
        }
    }
}

