/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.common;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;

public class ProgressBar
extends Component {
    private int barCount = 5;
    private int maxValue = 100;
    private int currentValue = 0;
    private int barSize = 12;
    private int barGap = 2;
    private int bgColor = 0xFFFFFF;
    private int borderColor = 5935024;
    private int fillColor = 10207366;

    public ProgressBar() {
        this.getStyle().setBgColor(this.bgColor);
        this.getStyle().setFgColor(this.fillColor);
        this.getStyle().setBgTransparency(0);
    }

    public ProgressBar(int barCount, int barSize, int barGap, int maxValue, int bgColor, int borderColor, int fillColor) {
        this.barCount = barCount;
        this.barSize = barSize;
        this.barGap = barGap;
        this.maxValue = maxValue;
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.fillColor = fillColor;
        this.getStyle().setBgColor(bgColor);
        this.getStyle().setFgColor(fillColor);
        this.getStyle().setBgTransparency(0);
    }

    public void setCurrentValue(int value) {
        this.currentValue = value;
        this.repaint();
    }

    public void paint(Graphics g) {
        int x = this.getX();
        int y = this.getY();
        byte alpha = this.getStyle().getBgTransparency();
        int value = this.getCurrentValue();
        int delta = this.getMaxValue() / this.getBarCount();
        for (int i = 0; i < this.getBarCount(); ++i) {
            g.setColor(this.getBorderColor());
            g.drawRect(x, y, this.getBarSize(), this.getBarSize());
            g.setColor(this.getStyle().getFgColor());
            if (value >= delta) {
                g.fillRect(x + 1, y + 1, this.getBarSize() - 1, this.getBarSize() - 1);
            } else if (value > 0 && value < delta) {
                int width = (this.getBarSize() - 1) * value / delta;
                g.fillRect(x + 1, y + 1, width, this.getBarSize() - 1);
                g.setColor(this.getStyle().getBgColor());
                g.fillRect(x + 1 + width, y + 1, this.getBarSize() - width - 1, this.getBarSize() - 1, alpha);
            } else {
                g.setColor(this.getStyle().getBgColor());
                g.fillRect(x + 1, y + 1, this.getBarSize() - 1, this.getBarSize() - 1, alpha);
            }
            value -= delta;
            x += this.getBarSize() + this.getBarGap();
        }
    }

    protected Dimension calcPreferredSize() {
        int topPadding = this.getStyle().getPadding(0);
        int bottomPadding = this.getStyle().getPadding(2);
        int leftPadding = this.getStyle().getPadding(1);
        int rightPadding = this.getStyle().getPadding(3);
        Dimension size = new Dimension(this.getBarCount() * this.getBarSize() + (this.getBarCount() - 1) * this.getBarGap() + leftPadding + rightPadding, this.getBarSize() + topPadding + bottomPadding);
        return size;
    }

    public int getBarCount() {
        return this.barCount;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public int getBarSize() {
        return this.barSize;
    }

    public int getBarGap() {
        return this.barGap;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }
}

