/*
 * Decompiled with CFR 0.152.
 */
package maps.visual;

import javax.microedition.lcdui.Graphics;
import maps.visual.ViewPort;

public abstract class SpatialEntity {
    public int n = -1;
    public static final int STREET_OBJECT = 1;
    public static final int NORMAL = 3;
    public static final int SIMPLE_ROAD = 3;
    public static final int MEDIUM_ROAD = 4;
    public static final int MAJOR_ROAD = 5;
    public static final int RAIL_ROAD = 8;
    public static final int LAKE = 16;
    public static final int PARK = 17;
    public static final int PARK2 = 18;
    public static final int BUILD = 19;
    public static final int SPORT = 20;
    public static final int POLYGON = 2;
    public static final int HIGHLIGHT_ROUTE = 255;
    public int entityType = 0;
    public float[] o = null;
    public float[] p = null;
    public String label = null;
    public static int[] labelLayout = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    public float q = 0.0f;

    public SpatialEntity(float[] fArray, float[] fArray2, int n) {
        this(fArray, fArray2, n, null);
    }

    public SpatialEntity(float[] fArray, float[] fArray2, int n, String string) {
        if (fArray.length != fArray2.length) {
            throw new IllegalStateException("Illegal dimension!");
        }
        this.o = new float[fArray.length];
        this.p = new float[fArray2.length];
        System.arraycopy(fArray, 0, this.o, 0, fArray.length);
        System.arraycopy(fArray2, 0, this.p, 0, fArray2.length);
        this.entityType = n;
        this.label = string;
    }

    public abstract void draw(Graphics var1, ViewPort var2, int var3);

    public int getType() {
        return this.entityType;
    }

    public int[] getLabelLayout() {
        return labelLayout;
    }

    public int getPointsSize() {
        return (this.o.length + this.p.length) / 2;
    }

    public float getPointX(int n) {
        return this.o[n];
    }

    public float getPointY(int n) {
        return this.p[n];
    }

    public String getLabel() {
        return this.label;
    }

    public void setId(int n) {
        this.n = n;
    }

    public int getId() {
        return this.n;
    }

    public float getLabelAngle() {
        return this.q;
    }

    public void setLabelAngle(float f) {
        this.q = f;
    }
}

