/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SystemInfo {
    public static Hashtable hashtable = new Hashtable();
    private Display a;

    public SystemInfo(Display display) {
        this.a = display;
    }

    public void check_all() {
        this.check_platform();
        this.check_runtime();
        this.check_display();
        this.check_locale();
        this.check_cldc();
        this.check_midp();
        this.check_m3g();
        this.check_mmapi();
        this.check_bluetooth();
        this.check_pim();
        this.check_fc();
        this.check_svg();
        this.check_wma();
        this.check_location();
        this.check_sip();
        this.check_amms();
        this.check_jtwi();
        this.check_satsa();
        this.check_webparser();
        this.check_webrpc();
        this.check_chapi();
        this.check_mglobal();
        this.check_payment();
        this.check_msa();
        this.check_telephony();
        this.check_sensor();
        this.check_contactless();
        this.check_cdc();
        this.check_openGL_ES_Binding();
    }

    public void check_platform() {
        String string = System.getProperty("microedition.platform");
        if (string != null) {
            hashtable.put("platform_name", string);
            return;
        }
        hashtable.put("platform_name", "N/A");
    }

    public void check_display() {
        if (this.a == null) {
            return;
        }
        hashtable.put("display_iscolor", this.a.isColor() + "");
        hashtable.put("display_numcolors", this.a.numColors() + "");
    }

    public void check_runtime() {
        hashtable.put("runtime_freememory", Runtime.getRuntime().freeMemory() + "");
        hashtable.put("runtime_totalmemory", Runtime.getRuntime().totalMemory() + "");
    }

    public void check_locale() {
        String string;
        String string2 = System.getProperty("microedition.location.version");
        if (string2 != null) {
            hashtable.put("microedition.location.version", string2);
        }
        if ((string = System.getProperty("microedition.locale")) != null) {
            hashtable.put("microedition_locale", string);
        } else {
            hashtable.put("microedition_locale", "N/A");
        }
        string = System.getProperty("microedition.encoding");
        if (string != null) {
            hashtable.put("microedition_encoding", string);
            return;
        }
        hashtable.put("microedition_encoding", "N/A");
    }

    public void check_connectivity() {
        String string = System.getProperty("microedition.commports");
        if (string != null) {
            hashtable.put("microedition_commports", string);
        } else {
            hashtable.put("microedition_commports", "N/A");
        }
        string = System.getProperty("microedition.smartcardslots");
        if (string != null) {
            hashtable.put("microedition_smartcardslots", string);
        } else {
            hashtable.put("microedition_smartcardslots", "N/A");
        }
        string = System.getProperty("microedition.hostname");
        if (string != null) {
            hashtable.put("microedition_hostname", string);
            return;
        }
        hashtable.put("microedition_hostname", "N/A");
    }

    public void check_cldc() {
        String string = System.getProperty("microedition.configuration");
        if (string != null) {
            hashtable.put("microedition_configuration", string);
            if (string.indexOf("CLDC-1.1") != -1) {
                hashtable.put("cldc_version", "1.1");
                return;
            }
            if (string.indexOf("CLDC-1") != -1) {
                hashtable.put("cldc_version", "1.0");
                return;
            }
            hashtable.put("cldc_version", string);
            return;
        }
        hashtable.put("cldc_version", "N/A");
    }

    public void check_midp() {
        String string = System.getProperty("microedition.profiles");
        if (string != null) {
            hashtable.put("microedition_profiles", string);
            if (string.indexOf("MIDP-3") != -1) {
                hashtable.put("midp_version", "3.0");
            } else if (string.indexOf("MIDP-2") != -1) {
                hashtable.put("midp_version", "2.0");
            } else if (string.indexOf("MIDP-1") != -1) {
                hashtable.put("midp_version", "1.0");
            } else {
                hashtable.put("midp_version", "N/A");
            }
            new Form("");
            MIDP1Canvas mIDP1Canvas = new MIDP1Canvas(this);
            hashtable.put("midp_canvas_width", mIDP1Canvas.getWidth() + "");
            hashtable.put("midp_canvas_height", mIDP1Canvas.getHeight() + "");
            hashtable.put("midp_canvas_metric", mIDP1Canvas.getWidth() + "x" + mIDP1Canvas.getHeight());
            hashtable.put("midp_canvas_doublebuffered", mIDP1Canvas.isDoubleBuffered() + "");
            if (SystemInfo.asString("midp_version").indexOf("2") != -1 || SystemInfo.asString("midp_version").indexOf("3") != -1) {
                try {
                    APIPropertyChecker aPIPropertyChecker = (APIPropertyChecker)Class.forName("MIDP2PropertyChecker").newInstance();
                    aPIPropertyChecker.setDisplay(this.a);
                    aPIPropertyChecker.checkProperties(this);
                }
                catch (Throwable throwable) {}
            }
            try {
                Image.createImage((String)"/null.jpg");
                hashtable.put("is_jpeg_supported", "true");
            }
            catch (Throwable throwable) {
                hashtable.put("is_jpeg_supported", "false");
            }
            try {
                Image.createImage((String)"/null.svg");
                hashtable.put("is_svg_supported", "true");
            }
            catch (Throwable throwable) {
                hashtable.put("is_svg_supported", "false");
            }
            return;
        }
        hashtable.put("midp_version", "N/A");
    }

    public void check_m3g() {
        System.gc();
        String string = System.getProperty("microedition.m3g.version");
        if (string != null) {
            hashtable.put("m3g_version", string);
            try {
                APIPropertyChecker aPIPropertyChecker = (APIPropertyChecker)Class.forName("M3GPropertyChecker").newInstance();
                aPIPropertyChecker.checkProperties(this);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        hashtable.put("m3g_version", "No");
    }

    public void check_chapi() {
        String string = System.getProperty("microedition.chapi.version");
        if (string != null) {
            hashtable.put("chapi_version", string);
            return;
        }
        hashtable.put("chapi_version", "No");
    }

    public void check_payment() {
        String string = System.getProperty("microedition.payment.version");
        if (string != null) {
            hashtable.put("payment", "true");
            hashtable.put("payment_version", string);
            return;
        }
        hashtable.put("payment", "false");
        hashtable.put("payment_version", "No");
    }

    public void check_mglobal() {
        String string = System.getProperty("microedition.global.version");
        if (string != null) {
            hashtable.put("mglobal_version", string);
            return;
        }
        hashtable.put("mglobal_version", "No");
    }

    public void check_mmapi() {
        String string = System.getProperty("microedition.media.version");
        if (string != null) {
            hashtable.put("mmapi", "true");
            hashtable.put("mmapi_version", string);
        } else {
            String string2 = System.getProperty("supports.mixing");
            if (string2 != null) {
                hashtable.put("mmapi", "true");
                hashtable.put("mmapi_version", "1.0");
            } else {
                hashtable.put("mmapi", "false");
                hashtable.put("mmapi_version", "No");
            }
        }
        if (SystemInfo.asBoolean("mmapi")) {
            string = System.getProperty("supports.mixing");
            if (string != null && string.indexOf("true") != -1) {
                hashtable.put("mmapi_mixing", "true");
            } else {
                hashtable.put("mmapi_mixing", "false");
            }
            string = System.getProperty("supports.audio.capture");
            if (string != null && string.indexOf("true") != -1) {
                hashtable.put("mmapi_audio_capture", "true");
            } else {
                hashtable.put("mmapi_audio_capture", "false");
            }
            string = System.getProperty("supports.video.capture");
            if (string != null && string.indexOf("true") != -1) {
                hashtable.put("mmapi_video_capture", "true");
            } else {
                hashtable.put("mmapi_video_capture", "false");
            }
            string = System.getProperty("supports.recording");
            if (string != null && string.indexOf("true") != -1) {
                hashtable.put("mmapi_recording", "true");
            } else {
                hashtable.put("mmapi_recording", "false");
            }
            string = System.getProperty("audio.encodings");
            if (string != null) {
                hashtable.put("mmapi_audio_encodings", string);
            } else {
                hashtable.put("mmapi_audio_encodings", "None");
            }
            string = System.getProperty("video.encodings");
            if (string != null) {
                hashtable.put("mmapi_video_encodings", string);
            } else {
                hashtable.put("mmapi_video_encodings", "None");
            }
            string = System.getProperty("video.snapshot.encodings");
            if (string != null) {
                hashtable.put("mmapi_snapshot_encodings", string);
            } else {
                hashtable.put("mmapi_snapshot_encodings", "None");
            }
            string = System.getProperty("streamable.contents");
            if (string != null) {
                hashtable.put("mmapi_streamable_contents", "None");
                return;
            }
            hashtable.put("mmapi_streamable_contents", "None");
        }
    }

    public void check_bluetooth() {
        String string = System.getProperty("bluetooth.api.version");
        if (string != null) {
            Object object;
            try {
                Class.forName("javax.bluetooth.UUID");
                hashtable.put("bluetooth_version", "1.0");
                try {
                    object = (APIPropertyChecker)Class.forName("BTAPIPropertyChecker").newInstance();
                    ((APIPropertyChecker)object).checkProperties(this);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                hashtable.put("bluetooth_version", "No");
            }
            hashtable.put("bluetooth_version", string);
            object = System.getProperty("obex.api.version");
            if (object != null) {
                hashtable.put("obex_version", object);
            } else {
                hashtable.put("obex_version", "N/A");
            }
            object = System.getProperty("bluetooth.master.switch");
            if (object != null && ((String)object).indexOf("true") != -1) {
                hashtable.put("bluetooth_master_switch", "true");
            } else {
                hashtable.put("bluetooth_master_switch", "false");
            }
            object = System.getProperty("bluetooth.connected.inquiry.scan");
            if (object != null && ((String)object).indexOf("true") != -1) {
                hashtable.put("bluetooth_connected_inquiry_scan", "true");
            } else {
                hashtable.put("bluetooth_connected_inquiry_scan", "false");
            }
            object = System.getProperty("bluetooth.connected.page.scan");
            if (object != null && ((String)object).indexOf("true") != -1) {
                hashtable.put("bluetooth_connected_page_scan", "true");
            } else {
                hashtable.put("bluetooth_connected_page_scan", "false");
            }
            object = System.getProperty("bluetooth.connected.inquiry");
            if (object != null && ((String)object).indexOf("true") != -1) {
                hashtable.put("bluetooth_connected_inquiry", "true");
            } else {
                hashtable.put("bluetooth_connected_inquiry", "false");
            }
            object = System.getProperty("bluetooth.connected.page");
            if (object != null && ((String)object).indexOf("true") != -1) {
                hashtable.put("bluetooth_connected_page", "true");
            } else {
                hashtable.put("bluetooth_connected_page", "false");
            }
            object = System.getProperty("bluetooth.sd.attr.retrievable.max");
            if (object != null) {
                try {
                    hashtable.put("bluetooth_sd_attr_retrievable_max", object);
                }
                catch (Throwable throwable) {}
            }
            if ((object = System.getProperty("bluetooth.connected.devices.max")) != null) {
                try {
                    hashtable.put("bluetooth_connected_devices_max", object);
                }
                catch (Throwable throwable) {}
            }
            if ((object = System.getProperty("bluetooth.l2cap.receiveMTU.max")) != null) {
                try {
                    hashtable.put("bluetooth_l2cap_receiveMTU_max", object);
                }
                catch (Throwable throwable) {}
            }
            if ((object = System.getProperty("bluetooth.sd.trans.max")) != null) {
                try {
                    hashtable.put("bluetooth_sd_trans_max", object);
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        try {
            Class.forName("javax.bluetooth.UUID");
            hashtable.put("bluetooth_version", "1.0");
            try {
                APIPropertyChecker aPIPropertyChecker = (APIPropertyChecker)Class.forName("BTAPIPropertyChecker").newInstance();
                aPIPropertyChecker.checkProperties(this);
            }
            catch (Throwable throwable) {}
            return;
        }
        catch (Throwable throwable) {
            hashtable.put("bluetooth_version", "No");
            return;
        }
    }

    public void check_openGL_ES_Binding() {
        try {
            APIPropertyChecker aPIPropertyChecker = (APIPropertyChecker)Class.forName("OpenGlBindingPropertyChecker").newInstance();
            aPIPropertyChecker.checkProperties(this);
            return;
        }
        catch (Throwable throwable) {
            try {
                APIPropertyChecker aPIPropertyChecker = (APIPropertyChecker)Class.forName("OpenGl10BindingPropertyChecker").newInstance();
                aPIPropertyChecker.checkProperties(this);
                return;
            }
            catch (Throwable throwable2) {
                hashtable.put("openglbinding_version", "No");
                throwable2.printStackTrace();
                return;
            }
        }
    }

    public void check_pim() {
        String string = System.getProperty("microedition.pim.version");
        if (string != null) {
            hashtable.put("pim_version", string);
            return;
        }
        hashtable.put("pim_version", "No");
    }

    public void check_fc() {
        String string = System.getProperty("microedition.io.file.FileConnection.version");
        if (string != null) {
            hashtable.put("fc_version", string);
            String[] stringArray = new String[]{"fileconn.dir.photos", "fileconn.dir.videos", "fileconn.dir.graphics", "fileconn.dir.tones", "fileconn.dir.music", "fileconn.dir.recordings", "fileconn.dir.private", "fileconn.dir.photos.name", "fileconn.dir.videos.name", "fileconn.dir.graphics.name", "fileconn.dir.tones.name", "fileconn.dir.music.name", "fileconn.dir.recordings.name", "fileconn.dir.private.name", "fileconn.dir.roots.names"};
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string2 = System.getProperty(stringArray[i]);
                    if (string2 == null) continue;
                    hashtable.put(stringArray[i], string2);
                    continue;
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        hashtable.put("fc_version", "No");
    }

    public void check_svg() {
        String string;
        String string2 = System.getProperty("microedition.m2g.version");
        if (string2 != null) {
            hashtable.put("microedition.m2g.version", string2);
            hashtable.put("svg_version", string2);
        } else {
            try {
                Class.forName("javax.microedition.m2g.SVGAnimator");
                hashtable.put("svg_version", "1.0");
            }
            catch (Throwable throwable) {
                hashtable.put("svg_version", "No");
            }
        }
        String string3 = System.getProperty("microedition.m2g.svg.baseProfile");
        if (string3 != null) {
            hashtable.put("microedition.m2g.svg.baseProfile", string3);
        }
        if ((string = System.getProperty("microedition.m2g.svg.version")) != null) {
            hashtable.put("microedition.m2g.svg.version", string);
        }
    }

    public void check_wma() {
        String string = System.getProperty("wireless.messaging.sms.smsc");
        String string2 = System.getProperty("wireless.messaging.mms.mmsc");
        String string3 = System.getProperty("wireless.messaging.version");
        if (string2 != null) {
            hashtable.put("wma_mmsc", string2);
        } else {
            hashtable.put("wma_mmsc", "N/A");
        }
        if (string3 != null) {
            hashtable.put("wireless.messaging.version", string3);
        }
        if (string != null) {
            hashtable.put("wma_version", "1.1");
            hashtable.put("wma_smsc", string);
            try {
                Class.forName("javax.wireless.messaging.SizeExceededException");
                hashtable.put("wma_version", "2.0");
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        hashtable.put("wma_smsc", "N/A");
        try {
            Class.forName("javax.wireless.messaging.MessageConnection");
            hashtable.put("wma_version", "1.1");
            try {
                Class.forName("javax.wireless.messaging.SizeExceededException");
                hashtable.put("wma_version", "2.0");
            }
            catch (Throwable throwable) {}
            return;
        }
        catch (Throwable throwable) {
            hashtable.put("wma_version", "No");
            return;
        }
    }

    public void check_location() {
        String string = System.getProperty("microedition.location.version");
        if (string != null) {
            hashtable.put("location_version", string);
            return;
        }
        hashtable.put("location_version", "No");
    }

    public void check_sip() {
        String string = System.getProperty("microedition.sip.version");
        if (string != null) {
            hashtable.put("sip_version", string);
            return;
        }
        hashtable.put("sip_version", "No");
    }

    public void check_amms() {
        String string = System.getProperty("microedition.amms.version");
        if (string != null) {
            hashtable.put("amms_version", string);
            string = System.getProperty("supports.mediacapabilities");
            if (string != null) {
                String string2;
                block49: {
                    if (string.indexOf("music") != -1) {
                        hashtable.put("amms_music", "true");
                    } else {
                        hashtable.put("amms_music", "false");
                    }
                    if (string.indexOf("audio3d") != -1) {
                        hashtable.put("amms_audio3d", "true");
                        string2 = System.getProperty("audio3d.simultaneouslocations");
                        if (string2 != null) {
                            try {
                                hashtable.put("amms_audio3d_simultaneouslocations", string2);
                            }
                            catch (Throwable throwable) {
                                hashtable.put("amms_audio3d_simultaneouslocations", "0");
                            }
                        }
                    } else {
                        hashtable.put("amms_audio3d", "false");
                    }
                    if (string.indexOf("imageencoding") != -1) {
                        hashtable.put("amms_imageencoding", "true");
                    } else {
                        hashtable.put("amms_imageencoding", "false");
                    }
                    if (string.indexOf("imagepostprocessing") != -1) {
                        hashtable.put("amms_imagepostprocessing", "true");
                    } else {
                        hashtable.put("amms_imagepostprocessing", "false");
                    }
                    if (string.indexOf("camera") != -1) {
                        int n;
                        int n2;
                        hashtable.put("amms_camera", "true");
                        string2 = System.getProperty("camera.orientations");
                        if (string2 != null && (n2 = string2.indexOf(":")) != -1) {
                            n = string2.indexOf(":", n2 + 1);
                            if (n != -1) {
                                if (string2.indexOf("inwards", n) != -1) {
                                    hashtable.put("amms_camera1_orientation", "inwards");
                                } else if (string2.indexOf("outwards", n) != -1) {
                                    hashtable.put("amms_camera1_orientation", "outwards");
                                } else if (string2.indexOf("unknown", n) != -1) {
                                    hashtable.put("amms_camera1_orientation", "unknown");
                                } else {
                                    hashtable.put("amms_camera1_orientation", "N/A");
                                }
                                string2 = string2.substring(0, n);
                            }
                            if (string2.indexOf("inwards") != -1) {
                                hashtable.put("amms_camera0_orientation", "inwards");
                            } else if (string2.indexOf("outwards") != -1) {
                                hashtable.put("amms_camera0_orientation", "outwards");
                            } else if (string2.indexOf("unknown") != -1) {
                                hashtable.put("amms_camera0_orientation", "unknown");
                            } else {
                                hashtable.put("amms_camera0_orientation", "N/A");
                            }
                        }
                        if ((string2 = System.getProperty("camera.resolutions")) != null && (n2 = string2.indexOf(":")) != -1) {
                            int n3;
                            int n4;
                            n = string2.indexOf(":", n2 + 1);
                            if (n != -1) {
                                n4 = string2.indexOf("x", n + 1);
                                if (n4 != -1) {
                                    try {
                                        hashtable.put("amms_camera1_res_width", string2.substring(n + 1, n4));
                                        n3 = string2.indexOf(" ", n4);
                                        if (n3 != -1) {
                                            hashtable.put("amms_camera1_res_height", string2.substring(n4 + 1, n3));
                                        } else {
                                            hashtable.put("amms_camera1_res_height", string2.substring(n4 + 1));
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        hashtable.put("amms_camera1_res_width", "0");
                                        hashtable.put("amms_camera1_res_height", "0");
                                    }
                                }
                                string2 = string2.substring(0, string2.indexOf(" "));
                            }
                            if ((n4 = string2.indexOf("x", n2 + 1)) != -1) {
                                try {
                                    hashtable.put("amms_camera0_res_width", string2.substring(n2 + 1, n4));
                                    n3 = string2.indexOf(" ", n4);
                                    if (n3 != -1) {
                                        hashtable.put("amms_camera0_res_height", string2.substring(n4 + 1, n3));
                                        break block49;
                                    }
                                    hashtable.put("amms_camera0_res_height", string2.substring(n4 + 1));
                                }
                                catch (Throwable throwable) {
                                    hashtable.put("amms_camera0_res_width", "0");
                                    hashtable.put("amms_camera0_res_height", "0");
                                }
                            }
                        }
                    } else {
                        hashtable.put("amms_camera", "false");
                    }
                }
                if (string.indexOf("tuner") != -1) {
                    hashtable.put("amms_tuner", "true");
                    string2 = System.getProperty("tuner.modulations");
                    if (string2 != null) {
                        if (string2.indexOf("fm") != -1) {
                            hashtable.put("amms_tuner_fm", "true");
                        } else {
                            hashtable.put("amms_tuner_fm", "false");
                        }
                        if (string2.indexOf("am") != -1) {
                            hashtable.put("amms_tuner_am", "true");
                        } else {
                            hashtable.put("amms_tuner_am", "false");
                        }
                    }
                } else {
                    hashtable.put("amms_tuner", "false");
                }
            }
            if ((string = System.getProperty("audio.samplerates")) != null) {
                hashtable.put("amms_audio_samplerates", string);
                return;
            }
        } else {
            hashtable.put("amms_version", "No");
        }
    }

    public void check_jtwi() {
        String string = System.getProperty("microedition.jtwi.version");
        if (string != null) {
            hashtable.put("jtwi_version", string);
            return;
        }
        hashtable.put("jtwi_version", "No");
    }

    public void check_satsa() {
        String[] stringArray = new String[]{"microedition.satsa.crypto.version", "microedition.satsa.apdu.version", "microedition.satsa.pki.version", "microedition.smartcardslots"};
        String string = System.getProperty("microedition.satsa.crypto.version");
        if (string == null) {
            string = System.getProperty("microedition.satsa.apdu.version");
        }
        if (string == null) {
            string = System.getProperty("microedition.satsa.pki.version");
        }
        if (string != null) {
            hashtable.put("satsa_version", "1.0");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string2 = System.getProperty(stringArray[i]);
                    if (string2 == null) continue;
                    hashtable.put(stringArray[i], string2);
                    continue;
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        try {
            Class.forName("java.security.GeneralSecurityException");
            hashtable.put("satsa_version", "1.0");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string3 = System.getProperty(stringArray[i]);
                    if (string3 == null) continue;
                    hashtable.put(stringArray[i], string3);
                    continue;
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        catch (Throwable throwable) {
            hashtable.put("satsa_version", "No");
            return;
        }
    }

    public void check_webparser() {
        try {
            Class.forName("org.xml.sax.SAXParseException");
            hashtable.put("webparser", "true");
            hashtable.put("webparser_version", "1.0");
            String string = System.getProperty("xml.jaxp.subset.version");
            if (string != null) {
                hashtable.put("xml.jaxp.subset.version", string);
            }
            return;
        }
        catch (Throwable throwable) {
            hashtable.put("webparser", "false");
            hashtable.put("webparser_version", "No");
            return;
        }
    }

    public void check_webrpc() {
        try {
            Class.forName("java.rmi.RemoteException");
            hashtable.put("webrpc_version", "1.0");
            String string = System.getProperty("xml.rpc.subset.version");
            if (string != null) {
                hashtable.put("xml.rpc.subset.version", string);
            }
            return;
        }
        catch (Throwable throwable) {
            hashtable.put("webrpc_version", "No");
            return;
        }
    }

    public void check_msa() {
        String string = System.getProperty("microedition.msa.version");
        if (string != null) {
            hashtable.put("msa_version", string);
            return;
        }
        hashtable.put("msa_version", "No");
    }

    public void check_telephony() {
        String string = System.getProperty("javax.microedition.telephony");
        if (string != null) {
            hashtable.put("telephony_version", string);
        } else {
            hashtable.put("telephony_version", "No");
        }
        string = System.getProperty("javax.microedition.telephony.charging");
        if (string != null) {
            hashtable.put("telephonycharging_version", string);
            return;
        }
        hashtable.put("telephonycharging_version", "No");
    }

    public void check_sensor() {
        String string = System.getProperty("microedition.sensor.version");
        if (string != null) {
            hashtable.put("sensor_version", string);
        } else {
            hashtable.put("sensor_version", "No");
        }
        string = System.getProperty("microedition.sensor.control.version");
        if (string != null) {
            hashtable.put("sensor_control_version", string);
            return;
        }
        hashtable.put("sensor_control_version", "No");
    }

    public void check_contactless() {
        String string = System.getProperty("microedition.contactless.version");
        if (string != null) {
            hashtable.put("contactless_version", string);
            return;
        }
        hashtable.put("contactless_version", "No");
    }

    public void check_cdc() {
        String[] stringArray = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.ext.dirs", "os.name", "os.arch", "os.version", "java.library.path", "java.io.tmpdir", "java.compiler", "java.rmi.server.codebase", "java.rmi.server.hostname", "java.rmi.dgc.leaseValue", "java.rmi.server.logCalls", "java.rmi.server.useCodebaseOnly", "java.rmi.server.useLocalHostname", "java.rmi.activation.activator.class"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = System.getProperty(stringArray[i]);
                if (string == null) continue;
                hashtable.put("cdc_" + stringArray[i], string);
                continue;
            }
            catch (Throwable throwable) {}
        }
    }

    public static String asString(String string) {
        if (hashtable.get(string) == null) {
            return "";
        }
        return (String)hashtable.get(string);
    }

    public static boolean asBoolean(String string) {
        boolean bl = false;
        String string2 = (String)hashtable.get(string);
        if (string2 != null && string2.indexOf("true") != -1) {
            bl = true;
        }
        return bl;
    }

    public static int asInt(String string) {
        int n = -1;
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Throwable throwable) {}
        }
        return n;
    }

    public static void put(String string, String string2) {
        if (string != null && string2 != null) {
            hashtable.put(string, string2);
        }
    }

    public class MIDP1Canvas
    extends Canvas {
        public MIDP1Canvas(SystemInfo systemInfo) {
        }

        public void paint(Graphics graphics) {
        }
    }
}

