/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class BoxLayout
extends Layout {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    private int axis;

    public BoxLayout(int axis) {
        this.axis = axis;
    }

    public void layoutContainer(Container parent) {
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(3) - parent.getStyle().getPadding(1);
        int height = parent.getLayoutHeight() - parent.getBottomGap() - parent.getStyle().getPadding(2) - parent.getStyle().getPadding(0);
        int x = parent.getStyle().getPadding(1);
        int y = parent.getStyle().getPadding(0);
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            if (this.axis == 2) {
                int cmpBottom = height;
                int cmpH = cmp.getPreferredH();
                if ((y += cmp.getStyle().getMargin(0)) >= cmpBottom) {
                    cmpH = 0;
                } else if (y + cmpH > cmpBottom) {
                    cmpH = cmpBottom - y - cmp.getStyle().getMargin(2);
                }
                cmp.setWidth(width - cmp.getStyle().getMargin(1) - cmp.getStyle().getMargin(3));
                cmp.setHeight(cmpH);
                cmp.setX(x + cmp.getStyle().getMargin(1));
                cmp.setY(y);
                y += cmp.getHeight() + cmp.getStyle().getMargin(2);
                continue;
            }
            int cmpRight = width;
            int cmpW = cmp.getPreferredW();
            if ((x += cmp.getStyle().getMargin(1)) >= cmpRight) {
                cmpW = 0;
            } else if (x + cmpW > cmpRight) {
                cmpW = cmpRight - x - cmp.getStyle().getMargin(3);
            }
            cmp.setWidth(cmpW);
            cmp.setHeight(height - cmp.getStyle().getMargin(0) - cmp.getStyle().getMargin(2));
            cmp.setX(x);
            cmp.setY(y + cmp.getStyle().getMargin(0));
            x += cmp.getWidth() + cmp.getStyle().getMargin(3);
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            if (this.axis == 2) {
                height += cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2);
                width = Math.max(width, cmp.getPreferredW() + cmp.getStyle().getMargin(1) + cmp.getStyle().getMargin(3));
                continue;
            }
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2));
            width += cmp.getPreferredW() + cmp.getStyle().getMargin(1) + cmp.getStyle().getMargin(3);
        }
        return new Dimension(width + parent.getStyle().getPadding(1) + parent.getStyle().getPadding(3), height + parent.getStyle().getPadding(0) + parent.getStyle().getPadding(2));
    }
}

