/*
 * Decompiled with CFR 0.152.
 */
package bomber;

import bomber.Bomber;
import bomber.GameScreen;
import bomber.HighScores;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MenuScreen
extends Canvas
implements CommandListener {
    public static final byte MODE_MENU = 1;
    private byte mode;
    private Command quitComm;
    private Command backComm;
    private Command okComm;
    private Command continueGameComm;
    private Command newGameComm;
    private Command instructionsComm;
    private Command highScoresComm;
    private Command settingsComm;
    private Form highScoresForm;
    private Form instructionsForm;
    private Form settingsForm;
    public Form nameForm;
    private TextField nameField;
    public ChoiceGroup balls;
    public ChoiceGroup difficulty;
    public HighScores hs;
    private String[] ballStrings = new String[]{"2", "3"};
    private String[] difficultyStrings = new String[]{"Beginner", "Intermediate", "Game Addict", "Guru", "God"};
    public GameScreen gameScreen;
    private Image splashScreen;

    public MenuScreen() {
        this.setCommandListener(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            this.gameScreen = new GameScreen(this);
            this.splashScreen = Bomber.getImage("splash");
            this.quitComm = new Command("Quit", 6, 1);
            this.backComm = new Command("Back", 2, 1);
            this.okComm = new Command("Ok", 4, 1);
            this.continueGameComm = new Command("Continue", 1, 2);
            this.newGameComm = new Command("Play Game", 1, 3);
            this.settingsComm = new Command("Settings", 1, 4);
            this.instructionsComm = new Command("Instructions", 1, 5);
            this.highScoresComm = new Command("High Scores", 1, 6);
            this.highScoresForm = new Form("High Scores");
            this.highScoresForm.addCommand(this.backComm);
            this.highScoresForm.setCommandListener((CommandListener)this);
            this.hs = HighScores.loadHighScores();
            this.settingsForm = new Form("Settings");
            this.balls = new ChoiceGroup("Balls", 1, this.ballStrings, null);
            this.difficulty = new ChoiceGroup("Difficulty", 1, this.difficultyStrings, null);
            this.settingsForm.addCommand(this.backComm);
            this.settingsForm.setCommandListener((CommandListener)this);
            this.nameForm = new Form("New high score!");
            this.nameField = new TextField("Your name:", "", 10, 0);
            this.nameForm.append((Item)this.nameField);
            this.nameForm.addCommand(this.okComm);
            this.nameForm.setCommandListener((CommandListener)this);
            this.instructionsForm = new Form("Instructions");
            this.instructionsForm.append("The objective of the game is to find your way through the mazes and caves to the exit door of each level. In most levels, you also need to clear the monsters from the area.\n");
            this.instructionsForm.append("Your character is equipped with bombs. You can place a bomb on any floor tile. After you place a bomb, it will explode after a short period of time. The explosion will spread flames in the four main directions. You can destroy monsters by hitting them with flames. Some monsters will take several hits to destroy.\n");
            this.instructionsForm.append("There is a limit to how many bombs you can place at a time. If you have the maximum number of bombs placed you cannot place more until some of them have exploded. You have an unlimited supply of standard bombs. \n");
            this.instructionsForm.append("Most of the walls and other stationary objects can be broken or otherwise manipulated. Hit different objects with explosions to see how they react. You will need to manipulate objects to make it to the door in some levels.\n");
            this.instructionsForm.addCommand(this.backComm);
            this.instructionsForm.setCommandListener((CommandListener)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command.getCommandType() == 6) {
                Bomber.quitApp();
            } else if (command == this.continueGameComm) {
                this.continueGame();
            } else if (command == this.newGameComm) {
                this.newGame();
            } else if (command == this.instructionsComm) {
                this.showInstructions();
            } else if (command == this.settingsComm) {
                this.showSettings();
            } else if (command == this.highScoresComm) {
                this.showHighScores();
            } else if (command == this.backComm) {
                if (displayable == this.highScoresForm || displayable == this.instructionsForm || displayable == this.settingsForm) {
                    this.showMenu();
                }
            } else if (command == this.okComm && displayable == this.nameForm) {
                this.showHighScores();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showMenu() {
        try {
            this.removeCommand(this.okComm);
            this.removeCommand(this.backComm);
            this.addCommand(this.quitComm);
            this.addCommand(this.newGameComm);
            this.addCommand(this.instructionsComm);
            this.mode = 1;
            Bomber.instance.setDisplayable((Displayable)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showInstructions() {
        Bomber.instance.setDisplayable((Displayable)this.instructionsForm);
    }

    public void showSettings() {
        Bomber.instance.setDisplayable((Displayable)this.settingsForm);
    }

    public void showHighScores() {
        try {
            int n;
            for (n = this.highScoresForm.size(); n > 0; --n) {
                this.highScoresForm.delete(0);
            }
            for (n = 0; n < 10; ++n) {
                this.highScoresForm.append(String.valueOf(String.valueOf(new StringBuffer("").append(n + 1).append(". ").append(this.hs.getScore(n)).append(" ").append(this.hs.getName(n)).append('\n'))));
            }
            Bomber.instance.setDisplayable((Displayable)this.highScoresForm);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void newGame() {
        block3: {
            block2: {
                if (this.gameScreen.mode == 5) break block2;
                if (this.gameScreen.mode != 2 || this.gameScreen.level != 1 || this.gameScreen.player.points != 0) break block3;
            }
            this.gameScreen.newGame();
        }
        Bomber.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void continueGame() {
        Bomber.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void paint(Graphics graphics) {
        this.renderMenuMode(graphics);
    }

    private void renderMenuMode(Graphics graphics) {
        try {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(255, 255, 255);
            graphics.drawString("B-Man", n / 2, n2 / 2, 65);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanUp() {
    }

    static {
        MODE_MENU = 1;
    }
}

