/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class CFrontend
extends FullCanvas {
    public final int FRONTEND_QUIT;
    public final int FRONTEND_IFONE;
    public final int FRONTEND_ATARI;
    public final int FRONTEND_MAIN;
    public final int FRONTEND_NAME;
    public final int FRONTEND_RANK;
    public final int FRONTEND_SPLASH;
    public int iFrontendState = 3;
    public Image m_ifone = null;
    public Image m_atari = null;
    public Image m_splash = null;
    public Image m_logo = null;
    public Image m_menu = null;
    public Image m_play = null;
    public Image m_selector = null;
    public Image m_Select = null;
    public Image m_Quit = null;
    public int m_iOption = 0;
    public boolean bDebounce = false;
    public boolean bDrawFrontend = true;
    public boolean bStart = true;
    public boolean bPaint = true;
    public final int IFONE_TIME;
    public final int ATARI_TIME;
    public final int SPLASH_TIME;
    public long IntroTimer;
    public byte[] gScoreTable = null;
    public static final int NAME_SIZE = 3;
    public static final int SCORE_SIZE = 7;
    public static final int ENTRY_SIZE = 10;
    public static final int NUM_ENTRY = 10;
    public static final int TABLE_SIZE = 100;
    public static final String FILE_NAME = "_BREAKOUT_HS";
    public int iSERow = 0;
    public int iSECol = 0;
    public char[] cNameEntry = null;
    public int iNumLetters = 0;
    boolean bNameFull = false;
    int screenW = this.getWidth();
    int screenH = this.getHeight();
    private Font gameFont;
    public int iBorderL = 5;
    public int iBorderR = 5;
    public int iBorderT = 22;
    public int iScreenW = this.getWidth();
    public int iScreenH = this.getHeight();

    public CFrontend() {
        this.FRONTEND_QUIT = 0;
        this.FRONTEND_IFONE = 1;
        this.FRONTEND_ATARI = 2;
        this.FRONTEND_MAIN = 3;
        this.FRONTEND_NAME = 4;
        this.FRONTEND_RANK = 5;
        this.FRONTEND_SPLASH = 6;
        this.IFONE_TIME = 2000;
        this.ATARI_TIME = 4000;
        this.SPLASH_TIME = 8000;
        this.cNameEntry = new char[3];
        this.gameFont = Font.getFont((int)64, (int)0, (int)8);
        this.LoadSplash();
        this.LoadFrontendArt();
    }

    public void LoadSplash() {
        try {
            this.m_ifone = Image.createImage((String)"/iFone.png");
            this.m_atari = Image.createImage((String)"/Atari.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void UnloadLoadSplash() {
        this.m_ifone = null;
        this.m_atari = null;
    }

    public void LoadFrontendArt() {
        try {
            this.m_logo = Image.createImage((String)"/logo.png");
            this.m_menu = Image.createImage((String)"/menu.png");
            this.m_play = Image.createImage((String)"/play.png");
            this.m_selector = Image.createImage((String)"/selector.png");
            this.m_Select = Image.createImage((String)"/select.png");
            this.m_Quit = Image.createImage((String)"/quit.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void RunFrontend() {
        breakout.display.setCurrent((Displayable)this);
        this.bDrawFrontend = true;
        this.IntroTimer = System.currentTimeMillis();
        if (this.bStart) {
            this.iFrontendState = 1;
            this.bStart = false;
        } else if (this.iFrontendState != 4 && this.iFrontendState != 6) {
            this.iFrontendState = 3;
        }
        while (this.iFrontendState != 0) {
            long l;
            if (this.iFrontendState == 1) {
                l = System.currentTimeMillis();
                if (l - this.IntroTimer > 2000L) {
                    this.IntroTimer = System.currentTimeMillis();
                    this.iFrontendState = 2;
                    this.LoadData();
                }
            } else if (this.iFrontendState == 2) {
                l = System.currentTimeMillis();
                if (l - this.IntroTimer > 4000L) {
                    this.IntroTimer = System.currentTimeMillis();
                    this.iFrontendState = 3;
                }
            } else if (this.iFrontendState == 6 && (l = System.currentTimeMillis()) - this.IntroTimer > 8000L) {
                this.IntroTimer = System.currentTimeMillis();
                this.iFrontendState = 3;
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.iFrontendState == 1) {
            graphics.fillRect(0, 0, this.screenW, this.screenH);
            graphics.drawImage(this.m_ifone, 0, 0, 20);
        } else if (this.iFrontendState == 2) {
            graphics.fillRect(0, 0, this.screenW, this.screenH);
            graphics.drawImage(this.m_atari, 0, 0, 20);
        } else if (this.iFrontendState == 3) {
            if (this.bDrawFrontend) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.screenW, this.screenH);
                graphics.drawImage(this.m_logo, (this.screenW - this.m_logo.getWidth()) / 2, 0, 20);
                if (this.m_iOption == 0) {
                    graphics.drawImage(this.m_selector, (this.screenW - this.m_selector.getWidth()) / 2, this.m_logo.getHeight(), 20);
                } else {
                    graphics.drawImage(this.m_selector, (this.screenW - this.m_selector.getWidth()) / 2, this.m_logo.getHeight() + this.m_selector.getHeight(), 20);
                }
                graphics.drawImage(this.m_play, (this.screenW - this.m_play.getWidth()) / 2, this.m_logo.getHeight() + this.m_selector.getHeight() / 4, 20);
                graphics.drawImage(this.m_menu, (this.screenW - this.m_menu.getWidth()) / 2, this.m_logo.getHeight() + this.m_selector.getHeight() + this.m_selector.getHeight() / 4, 20);
                graphics.drawImage(this.m_Quit, 0, this.screenH, 36);
                graphics.drawImage(this.m_Select, this.screenW, this.screenH, 0x20 | 8);
                this.bDrawFrontend = false;
            }
        } else if (this.iFrontendState == 6) {
            graphics.fillRect(0, 0, this.screenW, this.screenH);
            graphics.drawImage(this.m_splash, 0, 0, 20);
        }
    }

    private void draw(String string, int n, int n2, Graphics graphics) {
        graphics.drawString(string, n, n2, 20);
    }

    public void keyPressed(int n) {
        if (this.bDebounce) {
            return;
        }
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
            if (this.iFrontendState == 3) {
                if (n2 == 1) {
                    if (this.m_iOption == 0) {
                        this.m_iOption = 1;
                    } else if (this.m_iOption == 1) {
                        this.m_iOption = 0;
                    }
                    this.bDrawFrontend = true;
                    this.bDebounce = true;
                } else if (n2 == 6) {
                    if (this.m_iOption == 0) {
                        this.m_iOption = 1;
                    } else if (this.m_iOption == 1) {
                        this.m_iOption = 0;
                    }
                    this.bDrawFrontend = true;
                    this.bDebounce = true;
                } else if (n == -7) {
                    if (this.m_iOption == 0) {
                        this.iFrontendState = 0;
                        breakout.iAppState = 2;
                    } else {
                        this.iFrontendState = 0;
                        breakout.iAppState = 3;
                    }
                } else if (n == -6) {
                    this.iFrontendState = 0;
                    breakout.iAppState = 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void keyReleased(int n) {
        this.bDebounce = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void LoadData() {
        RecordStore recordStore = null;
        try {
            try {
                this.gScoreTable = new byte[100];
                recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
                recordStore.getRecord(1, this.gScoreTable, 0);
                recordStore.closeRecordStore();
                return;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                try {
                    recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
                    this.populateTable();
                    recordStore.addRecord(this.gScoreTable, 0, 100);
                    recordStore.closeRecordStore();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            recordStore = null;
            throw throwable;
        }
    }

    private boolean save() {
        RecordStore recordStore = null;
        boolean bl = false;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
                recordStore.setRecord(1, this.gScoreTable, 0, 100);
                recordStore.closeRecordStore();
                bl = true;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                try {
                    recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
                    int n = recordStore.addRecord(this.gScoreTable, 0, 100);
                    recordStore.setRecord(1, this.gScoreTable, 0, 100);
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException2) {
                    recordStoreNotFoundException.printStackTrace();
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    recordStoreNotFoundException.printStackTrace();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreNotFoundException.printStackTrace();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        recordStore = null;
        System.gc();
        return bl;
    }

    public void SaveScore() {
        String string = new String(this.cNameEntry, 0, this.iNumLetters);
        this.insertEntry(breakout.Game.iRank, breakout.Game.iScore, string);
    }

    private void populateTable() {
        int n = 0;
        int n2 = 0;
        while (n2 < 10) {
            byte[] byArray = "             ".getBytes();
            if (n2 == 0) {
                byArray = "P H           ".getBytes();
            } else if (n2 == 1) {
                byArray = "GHL           ".getBytes();
            } else if (n2 == 2) {
                byArray = "ADE           ".getBytes();
            } else if (n2 == 3) {
                byArray = "HIP           ".getBytes();
            } else if (n2 == 4) {
                byArray = "HOP           ".getBytes();
            } else if (n2 == 5) {
                byArray = "DOL           ".getBytes();
            } else if (n2 == 6) {
                byArray = "END           ".getBytes();
            } else if (n2 == 7) {
                byArray = "TIM           ".getBytes();
            } else if (n2 == 8) {
                byArray = "MOR           ".getBytes();
            } else if (n2 == 9) {
                byArray = "PET           ".getBytes();
            }
            System.arraycopy(byArray, 0, this.gScoreTable, n, 3);
            this.putScore(n2, 200 - n2 * 20);
            n += 10;
            ++n2;
        }
    }

    private void putScore(int n, int n2) {
        int n3 = n * 10 + 3;
        int n4 = n3 + 7 - 1;
        while (n4 >= n3) {
            this.gScoreTable[n4--] = (byte)(48 + n2 % 10);
            n2 /= 10;
        }
    }

    public int getScore(int n) {
        int n2 = n * 10 + 3;
        int n3 = 7;
        int n4 = 0;
        while (n3-- > 0) {
            n4 = n4 * 10 + (this.gScoreTable[n2++] - 48);
        }
        return n4;
    }

    private void insertEntry(int n, int n2, String string) {
        int n3 = n * 10;
        if (n < 10) {
            int n4 = (10 - n) * 10 - 10;
            System.arraycopy(this.gScoreTable, n3, this.gScoreTable, n3 + 10, n4);
        }
        byte[] byArray = (string + "           ").getBytes();
        System.arraycopy(byArray, 0, this.gScoreTable, n3, 3);
        this.putScore(n, n2);
        this.save();
    }
}

