/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.cartridge.CartridgeFactory;
import gameboy.core.cartridge.MBC;
import gameboy.core.driver.ClockDriver;
import gameboy.core.driver.StoreDriver;

public class Cartridge {
    public static boolean verifyHeader = true;
    private byte[] rom;
    private byte[] ram;
    private MBC mbc;
    private StoreDriver store;
    private ClockDriver clock;

    public Cartridge(StoreDriver store, ClockDriver clock) {
        this.store = store;
        this.clock = clock;
    }

    public final String getTitle() {
        int length;
        byte[] title = new byte[14];
        for (int index = 0; index < title.length; ++index) {
            title[index] = this.rom[308 + index];
        }
        for (length = 0; length < title.length && title[length] != 0; ++length) {
        }
        return new String(title, 0, length);
    }

    public final int getCartridgeType() {
        return this.rom[327] & 0xFF;
    }

    public final byte[] getROM() {
        return this.rom;
    }

    public final int getROMSize() {
        int romSize = this.rom[328] & 0xFF;
        if (romSize >= 0 && romSize <= 7) {
            return 32768 << romSize;
        }
        return -1;
    }

    public final int getRAMSize() {
        int ramSize = 0;
        switch (this.rom[329]) {
            case 0: {
                ramSize = 0;
                break;
            }
            case 1: {
                ramSize = 8192;
                break;
            }
            case 2: {
                ramSize = 8192;
                break;
            }
            case 3: {
                ramSize = 32768;
            }
        }
        return ramSize;
    }

    public final int getDestinationCode() {
        return this.rom[330] & 0xFF;
    }

    public final int getLicenseeCode() {
        return this.rom[331] & 0xFF;
    }

    public final int getROMVersion() {
        return this.rom[332] & 0xFF;
    }

    public final int getHeaderChecksum() {
        return this.rom[333] & 0xFF;
    }

    public final int getChecksum() {
        return ((this.rom[334] & 0xFF) << 8) + (this.rom[335] & 0xFF);
    }

    public final String getDescription() {
        return CartridgeFactory.getCartridgeDescription(this.getCartridgeType());
    }

    public final boolean hasBattery() {
        return CartridgeFactory.hasCartridgeBattery(this.getCartridgeType());
    }

    public final void reset() {
        if (!this.hasBattery()) {
            for (int index = 0; index < this.ram.length; ++index) {
                this.ram[index] = -1;
            }
        }
        this.mbc.reset();
    }

    public final int read(int address) {
        return this.mbc.read(address);
    }

    public final void write(int address, int data) {
        this.mbc.write(address, data);
    }

    public final void load(String cartridgeName) {
        int romSize = this.store.getCartridgeSize(cartridgeName);
        if (romSize == 0) {
            return;
        }
        this.rom = new byte[romSize];
        this.store.readCartridge(cartridgeName, this.rom);
        if (verifyHeader && !this.verifyHeader()) {
            throw new RuntimeException("Cartridge header is corrupted");
        }
        if (romSize < this.getROMSize()) {
            throw new RuntimeException("Cartridge is truncated");
        }
        int ramSize = this.getRAMSize();
        if (this.getCartridgeType() >= 5 && this.getCartridgeType() <= 6) {
            ramSize = 512;
        }
        this.ram = new byte[ramSize];
        for (int index = 0; index < ramSize; ++index) {
            this.ram[index] = -1;
        }
        if (this.store.hasBattery(cartridgeName)) {
            this.store.readBattery(cartridgeName, this.ram);
        }
        this.mbc = CartridgeFactory.createBankController(this.getCartridgeType(), this.rom, this.ram, this.clock);
    }

    public final void save(String cartridgeName) {
        if (this.hasBattery()) {
            this.store.writeBattery(cartridgeName, this.ram);
        }
    }

    public final boolean verify() {
        int checksum = 0;
        for (int address = 0; address < this.rom.length; ++address) {
            if (address == 334 || address == 335) continue;
            checksum = checksum + (this.rom[address] & 0xFF) & 0xFFFF;
        }
        return checksum == this.getChecksum();
    }

    private final boolean verifyHeader() {
        if (this.rom.length < 336) {
            return false;
        }
        int checksum = 231;
        for (int address = 308; address <= 332; ++address) {
            checksum = checksum - (this.rom[address] & 0xFF) & 0xFF;
        }
        return checksum == this.getHeaderChecksum();
    }

    public final String toString() {
        return "Title=" + this.getTitle() + " Type=" + this.getCartridgeType() + " Destination=" + this.getDestinationCode();
    }
}

