/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.MBC;

public class MBC2
implements MBC {
    private static final int RAM_BANK_SIZE = 512;
    private byte[] rom;
    private byte[] ram;
    private int romSize;
    private int romBank;
    private boolean ramEnable;

    public MBC2(byte[] rom, byte[] ram) {
        this.setROM(rom);
        this.setRAM(ram);
    }

    public final void reset() {
        this.romBank = 16384;
        this.ramEnable = false;
    }

    public final int read(int address) {
        if (address <= 16383) {
            return this.rom[address] & 0xFF;
        }
        if (address <= Short.MAX_VALUE) {
            return this.rom[this.romBank + (address & 0x3FFF)] & 0xFF;
        }
        if (address >= 40960 && address <= 41471) {
            return this.ram[address & 0x1FF] & 0xF;
        }
        return 255;
    }

    public final void write(int address, int data) {
        if (address <= 8191) {
            if ((address & 0x100) == 0) {
                this.ramEnable = (data & 0xA) == 10;
            }
        } else if (address <= 16383) {
            if ((address & 0x100) != 0) {
                if ((data & 0xF) == 0) {
                    data = 1;
                }
                this.romBank = (data & 0xF) << 14 & this.romSize;
            }
        } else if (address >= 40960 && address <= 41471 && this.ramEnable) {
            this.ram[address & 0x1FF] = (byte)(data & 0xF);
        }
    }

    private void setROM(byte[] buffer) {
        int banks = buffer.length / 16384;
        if (banks < 2 || banks > 16) {
            throw new RuntimeException("Invalid MBC2 ROM size");
        }
        this.rom = buffer;
        this.romSize = 16384 * banks - 1;
    }

    private void setRAM(byte[] buffer) {
        if (buffer.length != 512) {
            throw new RuntimeException("Invalid MBC2 RAM size");
        }
        this.ram = buffer;
    }
}

