/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.MBC;

public class MBC5
implements MBC {
    private byte[] rom;
    private byte[] ram;
    private int romSize;
    private int ramSize;
    private int romBank;
    private int ramBank;
    private boolean ramEnable;
    private boolean rumble;

    public MBC5(byte[] rom, byte[] ram, boolean rumble) {
        this.rumble = rumble;
        this.setROM(rom);
        this.setRAM(ram);
    }

    public final void reset() {
        this.romBank = 16384;
        this.ramBank = 0;
        this.ramEnable = false;
    }

    public final int read(int address) {
        if (address <= 16383) {
            return this.rom[address] & 0xFF;
        }
        if (address <= Short.MAX_VALUE) {
            return this.rom[this.romBank + (address & 0x3FFF)] & 0xFF;
        }
        if (address >= 40960 && address <= 49151) {
            return this.ram[this.ramBank + (address & 0x1FFF)] & 0xFF;
        }
        return 255;
    }

    public final void write(int address, int data) {
        if (address <= 8191) {
            if (this.ramSize > 0) {
                this.ramEnable = (data & 0xA) == 10;
            }
        } else if (address <= 12287) {
            this.romBank = (this.romBank & 0x400000) + ((data & 0xFF) << 14) & this.romSize;
        } else if (address <= 16383) {
            this.romBank = (this.romBank & 0x3FC000) + ((data & 1) << 22) & this.romSize;
        } else if (address <= 20479) {
            this.ramBank = this.rumble ? (data & 7) << 13 & this.ramSize : (data & 0xF) << 13 & this.ramSize;
        } else if (address >= 40960 && address <= 49151 && this.ramEnable) {
            this.ram[this.ramBank + (address & 0x1FFF)] = (byte)data;
        }
    }

    private void setROM(byte[] buffer) {
        int banks = buffer.length / 16384;
        if (banks < 2 || banks > 512) {
            throw new RuntimeException("Invalid MBC5 ROM size");
        }
        this.rom = buffer;
        this.romSize = 16384 * banks - 1;
    }

    private void setRAM(byte[] buffer) {
        int banks = buffer.length / 8192;
        if (banks < 0 || banks > 16) {
            throw new RuntimeException("Invalid MBC5 RAM size");
        }
        this.ram = buffer;
        this.ramSize = 8192 * banks - 1;
    }
}

