/*
 * Decompiled with CFR 0.152.
 */
package gameboy.ui;

import gameboy.core.driver.JoypadDriver;
import javax.microedition.lcdui.game.GameCanvas;

public class Joypad
implements JoypadDriver {
    private int[] keyCodes = new int[8];
    private GameCanvas canvas;
    private int buttons;
    private int directions;
    private int currentState;

    public Joypad(GameCanvas canvas) {
        this.canvas = canvas;
        this.buttons = 0;
        this.directions = 0;
        this.currentState = 0;
    }

    public final void setKeyCodes(int[] keyCodes) {
        this.keyCodes = keyCodes;
    }

    public final int getButtons() {
        return this.buttons ^ 0xF;
    }

    public final int getDirections() {
        return this.directions ^ 0xF;
    }

    public final boolean isRaised() {
        int state = this.canvas.getKeyStates();
        if (state != this.currentState) {
            this.currentState = state;
            this.buttons = 0;
            this.directions = 0;
            if ((state & this.keyCodes[0]) != 0) {
                this.directions |= 4;
            }
            if ((state & this.keyCodes[1]) != 0) {
                this.directions |= 8;
            }
            if ((state & this.keyCodes[2]) != 0) {
                this.directions |= 2;
            }
            if ((state & this.keyCodes[3]) != 0) {
                this.directions |= 1;
            }
            if ((state & this.keyCodes[4]) != 0) {
                this.buttons |= 1;
            }
            if ((state & this.keyCodes[5]) != 0) {
                this.buttons |= 2;
            }
            if ((state & this.keyCodes[7]) != 0) {
                this.buttons |= 4;
            }
            if ((state & this.keyCodes[6]) != 0) {
                this.buttons |= 8;
            }
            if (this.buttons != 0 || this.directions != 0) {
                return true;
            }
        }
        return false;
    }
}

