/*
 * Decompiled with CFR 0.152.
 */
package gameboy.ui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class KeysGrabber
extends GameCanvas
implements Runnable {
    private final int LEFT_MARGIN;
    private final int TOP_MARGIN;
    private Displayable nextDisplayable;
    private Graphics g;
    private String[] keyLabels;
    private boolean grabKeys = true;
    private boolean fullScreenMode = false;
    private Display display;
    private Thread thread;
    private String pressKeyLabel = "Press key for";
    private String pressJoystickLabel = "Press joystick";
    private int[] keyCodes;
    private int width;
    private int height;

    public KeysGrabber() {
        super(true);
        this.LEFT_MARGIN = 3;
        this.TOP_MARGIN = 3;
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.clearScreen();
        this.reset();
    }

    public int getHeight() {
        String platform = System.getProperty("microedition.platform");
        if (platform != null) {
            if ((platform = platform.toLowerCase()).indexOf("nokia") >= 0 && platform.indexOf("6630") >= 0) {
                if (this.fullScreenMode) {
                    return 208;
                }
                return 144;
            }
            return super.getHeight();
        }
        return super.getHeight();
    }

    public void setFullScreenMode(boolean mode) {
        super.setFullScreenMode(mode);
        this.fullScreenMode = mode;
    }

    public final void clearScreen() {
        this.g.setColor(0x446688);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.setColor(-1);
    }

    public final void reset() {
        this.keyLabels = new String[8];
        this.keyCodes = new int[this.keyLabels.length];
        this.keyLabels[0] = "UP";
        this.keyLabels[1] = "DOWN";
        this.keyLabels[2] = "LEFT";
        this.keyLabels[3] = "RIGHT";
        this.keyLabels[4] = "A";
        this.keyLabels[5] = "B";
        this.keyLabels[6] = "START";
        this.keyLabels[7] = "SELECT";
        this.keyCodes[0] = 2;
        this.keyCodes[1] = 64;
        this.keyCodes[2] = 4;
        this.keyCodes[3] = 32;
        this.keyCodes[4] = 1024;
        this.keyCodes[5] = 512;
        this.keyCodes[6] = 256;
        this.keyCodes[7] = 2048;
    }

    public void setPressKeyLabel(String pressKeyLabel) {
        this.pressKeyLabel = pressKeyLabel;
    }

    public void setPressJoystickLabel(String pressJoystickLabel) {
        this.pressJoystickLabel = pressJoystickLabel;
    }

    public final void setLabelsNCodes(String[] keyLabels, int[] keyCodes) {
        if (keyLabels.length != keyCodes.length) {
            throw new RuntimeException("keyLabels.length & keyCodes.length should be equal");
        }
        this.keyLabels = keyLabels;
        this.keyCodes = keyCodes;
    }

    public final void setKeyCodes(int[] keyCodes) {
        this.keyCodes = keyCodes;
    }

    public final int[] getKeyCodes() {
        return this.keyCodes;
    }

    public final void setKeyCode(String forKey, int code) {
        forKey = forKey.toUpperCase().trim();
        for (int i = 0; i < this.keyCodes.length; ++i) {
            if (!this.keyLabels[i].equals(forKey)) continue;
            this.keyCodes[i] = code;
            break;
        }
    }

    public final int myGetKeyCode(String forKey) {
        forKey = forKey.toUpperCase().trim();
        for (int i = 0; i < this.keyCodes.length; ++i) {
            if (!this.keyLabels[i].equals(forKey)) continue;
            return this.keyCodes[i];
        }
        return 0;
    }

    public final void grabKeys(Displayable nextDisplayable, Display display) {
        this.nextDisplayable = nextDisplayable;
        this.display = display;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.grabKeys = true;
            this.thread.start();
        }
    }

    public final void showKeys(Displayable nextDisplayable, Display display) {
        this.nextDisplayable = nextDisplayable;
        this.display = display;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.grabKeys = false;
            this.thread.start();
        }
    }

    private String myGetKeyName(int keyCode) {
        if (keyCode == 2) {
            return this.getKeyName(this.getKeyCode(1));
        }
        if (keyCode == 64) {
            return this.getKeyName(this.getKeyCode(6));
        }
        if (keyCode == 4) {
            return this.getKeyName(this.getKeyCode(2));
        }
        if (keyCode == 32) {
            return this.getKeyName(this.getKeyCode(5));
        }
        if (keyCode == 512) {
            return this.getKeyName(this.getKeyCode(9));
        }
        if (keyCode == 1024) {
            return this.getKeyName(this.getKeyCode(10));
        }
        if (keyCode == 2048) {
            return this.getKeyName(this.getKeyCode(11));
        }
        if (keyCode == 4096) {
            return this.getKeyName(this.getKeyCode(12));
        }
        if (keyCode == 256) {
            return this.getKeyName(this.getKeyCode(8));
        }
        return null;
    }

    private void showKeys() {
        String keys = "";
        int y = 3;
        this.clearScreen();
        for (int i = 0; i < this.keyCodes.length; ++i) {
            keys = this.keyLabels[i] + "  -  " + this.myGetKeyName(this.keyCodes[i]);
            this.g.drawString(keys, 3, y, 20);
            y += this.g.getFont().getHeight() + 2;
        }
        this.g.drawString(this.pressJoystickLabel, 3, y += 2, 20);
        while ((this.getKeyStates() & 0x100) == 0) {
            this.flushGraphics();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.display.setCurrent(this.nextDisplayable);
        this.thread = null;
    }

    private void grabKeys() {
        String keys = "";
        int previousState = 0;
        this.clearScreen();
        for (int i = 0; i < this.keyCodes.length; ++i) {
            int state;
            int y = 3;
            this.g.drawString(this.pressKeyLabel + " " + this.keyLabels[i], 3, y, 20);
            this.flushGraphics();
            while ((state = this.getKeyStates()) == 0 || state == previousState) {
                this.flushGraphics();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            previousState = state;
            if ((state & 0x40) != 0) {
                this.keyCodes[i] = 64;
            } else if ((state & 0x100) != 0) {
                this.keyCodes[i] = 256;
            } else if ((state & 0x200) != 0) {
                this.keyCodes[i] = 512;
            } else if ((state & 0x400) != 0) {
                this.keyCodes[i] = 1024;
            } else if ((state & 0x800) != 0) {
                this.keyCodes[i] = 2048;
            } else if ((state & 0x1000) != 0) {
                this.keyCodes[i] = 4096;
            } else if ((state & 4) != 0) {
                this.keyCodes[i] = 4;
            } else if ((state & 0x20) != 0) {
                this.keyCodes[i] = 32;
            } else if ((state & 2) != 0) {
                this.keyCodes[i] = 2;
            }
            this.clearScreen();
            this.flushGraphics();
        }
        this.showKeys();
        this.display.setCurrent(this.nextDisplayable);
        this.thread = null;
    }

    public final void run() {
        try {
            if (this.grabKeys) {
                this.grabKeys();
            } else {
                this.showKeys();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

