/*
 * Decompiled with CFR 0.152.
 */
package def;

import Exceptions.NumberNotFoundException;
import Exceptions.WrongNumberLengthException;
import FileUtils.TextFileReader;
import StringUtils.StringCollection;
import StringUtils.StringOperations;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class NumberResolver {
    public String Resolve(String number) throws WrongNumberLengthException, NumberNotFoundException, UnsupportedEncodingException, IOException {
        String line;
        String result = null;
        if ((number = number.replace('+', '\u0000').trim()).length() != 11) {
            throw new WrongNumberLengthException();
        }
        int def = Integer.parseInt(number.substring(1, 4));
        int num = Integer.parseInt(number.substring(4, 11));
        TextFileReader reader = new TextFileReader("/" + def + ".jda", true, "UTF-8");
        while ((line = reader.readLine()) != null) {
            StringCollection ops = StringOperations.Split(line, ";");
            if (Integer.parseInt(ops.get(0)) > num || Integer.parseInt(ops.get(1)) < num) continue;
            reader = new TextFileReader("/tm.jda", true, "UTF-8");
            while ((line = reader.readLine()) != null) {
                StringCollection tm = StringOperations.Split(line, ";");
                if (!tm.get(0).equals(ops.get(2))) continue;
                ops.set(tm.get(1), 2);
                break;
            }
            result = ops.get(2) + " (" + ops.get(3) + ")";
            break;
        }
        if (result == null) {
            throw new NumberNotFoundException();
        }
        return result;
    }

    public static String qResolve(String number) {
        String result = null;
        NumberResolver resolver = new NumberResolver();
        try {
            result = resolver.Resolve(number);
        }
        catch (NumberNotFoundException e) {
            result = "\u041f\u043e \u0412\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043d\u0435\u0442";
        }
        catch (UnsupportedEncodingException e) {
            result = "\u041f\u043e \u0412\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043d\u0435\u0442";
        }
        catch (WrongNumberLengthException e) {
            result = "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c 11 \u0446\u0438\u0444\u0440 \u0438 \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 8, \u043b\u0438\u0431\u043e \u0441 +7";
        }
        catch (IOException e) {
            result = "\u041f\u043e \u0412\u0430\u0448\u0435\u043c\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043d\u0435\u0442";
        }
        return result;
    }

    public static String qResolve(String number, boolean noExceptions) {
        String result = null;
        NumberResolver resolver = new NumberResolver();
        try {
            result = resolver.Resolve(number);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }
}

