/*
 * Decompiled with CFR 0.152.
 */
package example.fireworks;

import example.fireworks.ListItem;
import javax.microedition.lcdui.Graphics;

class Spark
extends ListItem {
    private static final int DRAG_FACTOR = 25;
    private static final int GRAVITATIONAL_ACCELERATION = 25;
    private int x;
    private int y;
    private int oldX;
    private int oldY;
    private int vx;
    private int vy;
    private final int colour;
    private int ticksToLive;

    Spark(int x, int y, int vx, int vy, int colour, int ticksToLive) {
        this.x = x;
        this.y = y;
        this.oldX = x;
        this.oldY = y;
        this.vx = vx;
        this.vy = vy;
        this.colour = colour;
        this.ticksToLive = ticksToLive;
    }

    void tick() {
        if (--this.ticksToLive <= 0) {
            this.remove();
        } else {
            this.oldX = this.x;
            this.oldY = this.y;
            this.x += this.vx;
            this.y += this.vy;
            this.vx -= this.vx * 25 >> 8;
            this.vy -= this.vy * 25 >> 8;
            this.vy += 25;
        }
    }

    void draw(Graphics g) {
        g.setColor(this.colour);
        g.drawLine(this.x >> 8, this.y >> 8, this.oldX >> 8, this.oldY >> 8);
    }

    static {
        DRAG_FACTOR = 25;
        GRAVITATIONAL_ACCELERATION = 25;
    }
}

