package app;

import java.io.InputStream;
import javax.microedition.lcdui.*;

public class GBACanvas extends Canvas {

    //public int[] fb = new int[240 * 160];
    private int frame_count;
    private int sleep;
    private boolean fpsOff;
    private String messageStr;
    private int skippedFrameCount;
    private long startTime;
    private int last_frame;
    private int frameSkip;
    private int fps;
    private long lastTime;
    GBACore core;
    private boolean romload;
    private boolean displayClear;
	private boolean rp = true;

    public GBACanvas() {
        fpsOff = false;
        frameSkip = 4;
        core = new GBACore(this);
        loadRom();
    }

    protected void paint(Graphics g) {
        //g.drawRGB(fb, 0, 240, 0, 0, 240, 160, false);
		rp = false;
		core.drawLine();
		g.drawRGB(core.pixels, 0, 240, 0, 0, 240, 160, false);
		if (!fpsOff) {
			g.setColor(0xffffff);
			g.drawString(messageStr, 0, 0, Graphics.TOP | Graphics.LEFT);
		}
		rp = true;
    }

    public boolean startFrame() {
        frame_count++;
        if (sleep == 2) {
            double ftime, dtime;
            long ctime;
            if (frame_count % 61 == 0) {
                if (!fpsOff) {
                    messageStr = (60 - skippedFrameCount) + "/60 frames.";
                }
                skippedFrameCount = 0;
            }
            ctime = System.currentTimeMillis();
            ftime = startTime + 16.66666 * frame_count;
            dtime = ctime - ftime;
            if (dtime > 500 || dtime < -500) {
                startTime = System.currentTimeMillis();
                frame_count = 0;
                last_frame = 0;
            }
            if (ctime < ftime) {
                return true;
            } else {
                skippedFrameCount++;
                if (skippedFrameCount == 60) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return frame_count % frameSkip == 0;
        }
    }

    public void endFrame() {
        if (frame_count - last_frame >= 60) {
            long current = System.currentTimeMillis();
            fps = 60000 / (int) (current - lastTime);
            last_frame += 60;
            lastTime = current;

            if (!fpsOff && sleep < 2) {
                messageStr = fps + "FPS FS=" + frameSkip;
            }
        }
        if( rp ) repaint();
        if (sleep == 1) {
            long tm = startTime + (long) (1667 * frameSkip / 100);
            do {
                startTime = System.currentTimeMillis();
            } while (tm > startTime);
            long delay = (startTime - tm);
            if (delay > 0 && delay < 50) {
                startTime -= delay;
            }
        }
    }

    public short readJoyPad() {
		if( (short)Input<0 ){
			Input &= 0x3FF;
			return (short)( Input | 0x8000 );
        }else return (short) Input;
    }

	static int Input = 0x03FF;

 final static int keyInp( int k ){
  if( k==49 | k==53 ) return 1; // KEY_A
  else if( k==-5 || k==51 ) return 2; // KEY_B
  else if( k==-7 ) return 4; // KEY_SELECT
  else if( k==-6 ) return 8; // KEY_START
  else if( k==-4 || k==54 ) return 16; // KEY_RIGHT
  else if( k==-3 || k==52 ) return 32; // KEY_LEFT
  else if( k==-1 || k==50 ) return 64; // KEY_UP
  else if( k==-2 || k==56 ) return 128; // KEY_DOWN
  else if( k==57 ) return 256; // KEY_R
  else if( k==55 ) return 512; // KEY_L
  else return 0;
 }

 public void keyPressed( int k ){
	if( k==(int)'*' ){ if( frameSkip>1 )frameSkip--; }else
	if( k==(int)'#' ) frameSkip++; else
	if( k==(int)'0' ) fpsOff = !fpsOff; else{
		Input &= ~keyInp( k );
		Input |= 0x8000;
	}
 }

 public void keyReleased(int k){
	Input |= keyInp( k ) | 0x8000;
 }

    private void loadRom() {
        try {
            core.request(GBACore.REQUEST_STOP, 0);
            core = new GBACore(this);
            System.gc();
            //is = getClass().getResourceAsStream("/rom.gba");
            if (App.is != null) {
                int c = core.loadROM(App.is, App.is.available());
                if (c == 0) {
                    romload = true;
                    displayClear = true;
                    messageStr = "";
                    core.reset();
                    core.start();
                    core.request(GBACore.REQUEST_START, 0);
                }
            }
        } catch (Exception e) {
        } catch (Error err) {
            throw err;
        } finally {
            App.is = null;
        }
    }
}
