/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.framework.graphics;

import com.foxmobile.ghostcamera.framework.graphics.ZLIB;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class PNG {
    static int[] crcTable = null;

    public static Image toImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = PNG.toPNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = PNG.createHeaderChunk(width, height);
        byte[] data = PNG.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = PNG.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static byte[] toPNG(int width, int height, int[] argb) {
        try {
            byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            byte[] header = PNG.createHeaderChunk(width, height);
            byte[] data = PNG.createDataChunk(width, height, argb);
            byte[] trailer = PNG.createTrailerChunk();
            ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
            png.write(signature);
            png.write(header);
            png.write(data);
            png.write(trailer);
            return png.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return PNG.toChunk("IHDR", baos.toByteArray());
    }

    public static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        int y = 0;
        while (y < height) {
            raw[dest++] = 0;
            int x = 0;
            while (x < width) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
                ++x;
            }
            ++y;
        }
        return PNG.toChunk("IDAT", PNG.toZLIB(raw));
    }

    public static byte[] createDataChunk(int width, int height, int[] argb) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        int y = 0;
        while (y < height) {
            raw[dest++] = 0;
            int x = 0;
            while (x < width) {
                int value = argb[source++];
                raw[dest++] = (byte)(value >> 16 & 0xFF);
                raw[dest++] = (byte)(value >> 8 & 0xFF);
                raw[dest++] = (byte)(value & 0xFF);
                raw[dest++] = (byte)(value >> 24 & 0xFF);
                ++x;
            }
            ++y;
        }
        return PNG.toChunk("IDAT", PNG.toZLIB(raw));
    }

    public static byte[] createTrailerChunk() throws IOException {
        return PNG.toChunk("IEND", new byte[0]);
    }

    public static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        int i = 0;
        while (i < 4) {
            bid[i] = (byte)id.charAt(i);
            ++i;
        }
        ((OutputStream)chunk).write(bid);
        ((OutputStream)chunk).write(raw);
        int crc = -1;
        crc = PNG.updateCRC(crc, bid);
        crc = PNG.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    public static void createCRCTable() {
        crcTable = new int[256];
        int i = 0;
        while (i < 256) {
            int c = i;
            int k = 0;
            while (k < 8) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
                ++k;
            }
            PNG.crcTable[i] = c;
            ++i;
        }
    }

    public static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            PNG.createCRCTable();
        }
        int i = 0;
        while (i < raw.length) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
            ++i;
        }
        return crc;
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        return ZLIB.toZLIB(raw);
    }
}

