/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.GraphViewer;
import graph.InsertFunctionList;
import graph.LanguageList;
import graph.MainMenu;
import graph.MyDisplayable;
import graph.WelcomeScreen;
import graph.lang.Phrases;
import java.util.Hashtable;
import java.util.Stack;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class CommandHandler {
    private GraphViewer midlet = null;
    private Hashtable displayables = new Hashtable();
    private Hashtable cmd2EndPoint = new Hashtable();
    private Hashtable listItemIndex2cmd = new Hashtable();
    private static final int GLOBAL_BACK_COMMAND_PRIORITY = -5;
    private Display display;
    private static CommandHandler commandHandler = null;
    private Stack previousDisplayables = new Stack();

    public static final Command getGlobalBackCommand() {
        return new Command(Phrases.Back, 2, -5);
    }

    public final boolean isBackCommand(Command command) {
        return command.getCommandType() == 2;
    }

    public static final Command getGlobalExitCommand() {
        return new Command(Phrases.Exit, 7, 0);
    }

    public static CommandHandler getInstance() {
        if (commandHandler == null) {
            commandHandler = new CommandHandler();
        }
        return commandHandler;
    }

    public void initialize(GraphViewer midlet) {
        this.midlet = midlet;
        this.display = Display.getDisplay((MIDlet)midlet);
    }

    public void registerDisplayable(Displayable displayable) {
        this.displayables.put(displayable.getClass().getName(), displayable);
    }

    public void registerCommand(Command cmd, String endPoint) {
        this.cmd2EndPoint.put(cmd, endPoint);
    }

    public void registerListItemIndex2command(List list, int index, Command cmd) {
        if (list != null && cmd != null) {
            this.listItemIndex2cmd.put(String.valueOf(list.getClass().getName()) + "#" + index, cmd);
        }
    }

    public boolean handleCommand(Command cmd) {
        Displayable endPoint;
        if (this.isBackCommand(cmd)) {
            this.goBack();
            return true;
        }
        if (cmd == List.SELECT_COMMAND && this.display.getCurrent() instanceof List) {
            List list = (List)this.display.getCurrent();
            int index = list.getSelectedIndex();
            cmd = (Command)this.listItemIndex2cmd.get(String.valueOf(list.getClass().getName()) + "#" + index);
        }
        if (cmd == null) {
            return false;
        }
        if (cmd.getCommandType() == 7) {
            this.midlet.saveEverything();
            this.midlet.notifyDestroyed();
            return true;
        }
        String endPointName = (String)this.cmd2EndPoint.get(cmd);
        if (endPointName != null && (endPoint = this.getDisplayable(endPointName)) != null) {
            this.setCurrentDisplayable(endPoint);
            return true;
        }
        return false;
    }

    public Displayable getPreviousDisplayable() {
        return (Displayable)this.previousDisplayables.peek();
    }

    private void saveCurrentDisplayble() {
        Displayable currentDisplayable = this.getCurrentDisplayable();
        if (this.isMainMenu(currentDisplayable)) {
            this.previousDisplayables = new Stack();
        }
        if (this.previousDisplayables.contains(currentDisplayable)) {
            while (this.previousDisplayables.pop() != currentDisplayable) {
            }
        }
        if (this.hasToSaveDisplayable(currentDisplayable)) {
            this.previousDisplayables.addElement(currentDisplayable);
        }
    }

    private boolean isMainMenu(Displayable displayable) {
        return displayable instanceof MainMenu;
    }

    private Displayable getMainMenu() {
        return GraphViewer.mainMenu;
    }

    private boolean hasToSaveDisplayable(Displayable displayable) {
        return !(displayable instanceof InsertFunctionList) && !(displayable instanceof LanguageList) && !(displayable instanceof WelcomeScreen) && !(displayable instanceof Alert);
    }

    public void goBack() {
        Displayable previousDisplayable = (Displayable)this.previousDisplayables.pop();
        if (previousDisplayable != null) {
            while (this.getCurrentDisplayable().getClass().equals(previousDisplayable.getClass())) {
                previousDisplayable = (Displayable)this.previousDisplayables.pop();
            }
            if (this.isMainMenu(previousDisplayable)) {
                previousDisplayable = this.getMainMenu();
            }
            try {
                if (this.getCurrentDisplayable() != null && this.getCurrentDisplayable() instanceof MyDisplayable) {
                    ((MyDisplayable)this.getCurrentDisplayable()).hide(previousDisplayable);
                }
                this.display.setCurrent(previousDisplayable);
            }
            catch (Exception e) {
                this.alertException(e);
                e.printStackTrace();
            }
        } else {
            this.setCurrentDisplayable((Displayable)GraphViewer.mainMenu);
        }
    }

    public void goBackTo(Displayable newDisplayable) {
        this.setCurrentDisplayable(newDisplayable);
    }

    public void setCurrentDisplayableName(String displayableName) {
        this.setCurrentDisplayable(this.getDisplayable(displayableName));
    }

    public void setCurrentDisplayable(Displayable nextDisplayable) {
        try {
            this.saveCurrentDisplayble();
            if (this.getCurrentDisplayable() instanceof MyDisplayable) {
                ((MyDisplayable)this.getCurrentDisplayable()).hide(nextDisplayable);
            }
            if (nextDisplayable instanceof MyDisplayable) {
                ((MyDisplayable)nextDisplayable).show(this.getCurrentDisplayable());
            }
            this.display.setCurrent(nextDisplayable);
        }
        catch (Exception e) {
            this.alertException(e);
            e.printStackTrace();
        }
    }

    public void setCurrentAlert(Alert alert, Displayable nextDisplayable) {
        try {
            this.saveCurrentDisplayble();
            if (this.getCurrentDisplayable() instanceof MyDisplayable) {
                ((MyDisplayable)this.getCurrentDisplayable()).hide(nextDisplayable);
            }
            if (nextDisplayable instanceof MyDisplayable) {
                ((MyDisplayable)nextDisplayable).show(this.getCurrentDisplayable());
            }
            this.display.setCurrent(alert, nextDisplayable);
        }
        catch (Exception e) {
            this.alertException(e);
            e.printStackTrace();
        }
    }

    public void setCurrentItem(Item item) {
        try {
            this.saveCurrentDisplayble();
            if (this.getCurrentDisplayable() instanceof MyDisplayable) {
                ((MyDisplayable)this.getCurrentDisplayable()).hide(this.getCurrentDisplayable());
            }
            this.display.setCurrentItem(item);
        }
        catch (Exception e) {
            this.alertException(e);
            e.printStackTrace();
        }
    }

    public Displayable getCurrentDisplayable() {
        return this.display.getCurrent();
    }

    public GraphViewer getMidlet() {
        return this.midlet;
    }

    public Displayable getDisplayable(String endPointName) {
        return (Displayable)this.displayables.get(endPointName);
    }

    public void alertException(String message) {
        Displayable current = this.getCurrentDisplayable();
        if (!(current instanceof Alert)) {
            this.alertException(message, current);
        } else {
            Displayable previousDisplayable = this.getPreviousDisplayable();
            if (!(previousDisplayable instanceof Alert)) {
                this.alertException(message, previousDisplayable);
            }
        }
    }

    public void alertException(String message, Displayable nextDisplayable) {
        Alert alert = new Alert(Phrases.error, message, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.setCurrentAlert(alert, nextDisplayable);
    }

    public void alertMessage(String title, String message, Displayable displayable) {
        Alert alert = new Alert(title, message, null, AlertType.INFO);
        alert.setTimeout(2000);
        if (!(displayable instanceof Alert)) {
            this.setCurrentAlert(alert, displayable);
        }
    }

    public void alertException(Exception exc) {
        this.alertException(exc.getMessage());
    }

    public static interface InvokeAble {
        public void invoke();
    }
}

