/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.MyDisplayable;
import graph.lang.Phrases;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;

public class InsertFunctionList
extends List
implements CommandListener,
MyDisplayable {
    Command insertCommand = new Command(Phrases.insertShort, 8, 0);
    private TextField textfield;
    private int currentSetIndex = 0;
    private static String[] functions0 = new String[]{"+", "-", "*", "/(x)", "^(x)", "sqrt(x)", "exp(x)", "pi", "x^2+x+1", "log(x)", "ln(x)", "I(0,3,x)", "D(x)", "f(1)", Phrases.goniometricFunctions};
    private static String[] functions1 = new String[]{"+", "-", "*", "/()", "^()", "sqrt()", "exp()", "pi", "log()", "ln()", "I(0,3,x)", "D(x)", "P(4,2)", "C(4,2)", "round(x)", "abs(x)", Phrases.goniometricFunctions};
    private static String[] goniometricFunctions = new String[]{"sin(x)", "cos(x)", "tan(x)", "asin(x)", "acos(x)", "atan(x)", "sinh(x)", "cosh(x)", "tanh(x)", "deg(x)", "rad(x)"};
    private static String[][] functionSets = new String[][]{functions0, functions1, goniometricFunctions};

    public InsertFunctionList(TextField textfieldToInsertIn, int functionSet) {
        super(Phrases.insertShort, 3, functions0, null);
        try {
            this.ndsInit(textfieldToInsertIn, functionSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ndsInit(TextField textfield, int functionSet) throws Exception {
        this.textfield = textfield;
        this.setFunctionSet(functionSet);
        this.setCommandListener(this);
        this.setSelectCommand(this.insertCommand);
        this.addCommand(CommandHandler.getGlobalBackCommand());
    }

    private void setFunctionSet(int setIndex) {
        this.currentSetIndex = setIndex;
        this.deleteAll();
        String[] functionSet = functionSets[setIndex];
        int i = 0;
        while (i < functionSet.length) {
            this.append(functionSet[i], null);
            ++i;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.insertCommand) {
            if (this.currentSetIndex < 2 && this.getSelectedIndex() == functionSets[this.currentSetIndex].length - 1) {
                this.setFunctionSet(2);
            } else {
                this.textfield.insert(functionSets[this.currentSetIndex][this.getSelectedIndex()], this.textfield.getCaretPosition());
                CommandHandler.getInstance().goBack();
            }
        } else {
            CommandHandler.getInstance().handleCommand(command);
        }
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

