/*
 * Decompiled with CFR 0.152.
 */
package hideme;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Options {
    private static final String STORE_NAME = "HideMeOptions";
    private static final String DEFAULT_PIN = "";

    public String getPin() {
        String ret = DEFAULT_PIN;
        try {
            RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            RecordEnumeration r = store.enumerateRecords((RecordFilter)new HeadFilter("PIN"), null, false);
            if (r.hasNextElement()) {
                byte[] data = r.nextRecord();
                ret = new String(data, 3, data.length - 3);
            }
            store.closeRecordStore();
            return ret;
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setPin(String pin) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            RecordEnumeration r = store.enumerateRecords((RecordFilter)new HeadFilter("PIN"), null, false);
            byte[] data = ("PIN" + pin).getBytes();
            if (r.hasNextElement()) {
                store.setRecord(r.nextRecordId(), data, 0, data.length);
            } else {
                store.addRecord(data, 0, data.length);
            }
            store.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public class HeadFilter
    implements RecordFilter {
        private final String head;

        public HeadFilter(String head) {
            this.head = head;
        }

        public boolean matches(byte[] candidate) {
            return new String(candidate).startsWith(this.head);
        }
    }
}

