/*
 * Decompiled with CFR 0.152.
 */
package jack;

import jack.AnimationTask;
import jack.GameScreen;
import jack.Jack;
import jack.Options;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class GameOver
extends Canvas
implements CommandListener,
Runnable {
    private Timer animationTimer;
    private static int maxX;
    private static int maxY;
    private int state;
    private int y;
    private static Image go;
    static TextField name;

    public GameOver() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            go = Image.createImage((String)"/jack/gameover.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        maxX = this.getWidth();
        maxY = this.getHeight();
        this.setCommandListener(this);
        this.addCommand(new Command("OK", 4, 1));
    }

    public void startAnimation() {
        this.state = -go.getHeight();
        this.y = maxY - 2 - GameScreen.jackY;
        this.animationTimer = new Timer();
        this.animationTimer.scheduleAtFixedRate((TimerTask)new AnimationTask(this), 0L, 50L);
    }

    private void stopAnimation() {
        this.animationTimer.cancel();
    }

    public void run() {
        ++this.state;
        if (this.state >= (maxY - go.getHeight()) / 2) {
            this.stopAnimation();
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 2) {
            Options.bestName = name.getString();
            Options.bestScore = Jack.gameScreen.gameMaxLevel;
            Options.saveScore();
            Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.mainMenu);
        }
        if (command.getCommandType() == 4) {
            if (Jack.gameScreen.gameMaxLevel > Options.bestScore) {
                Form in = new Form("New high score");
                in.append("You became the best jumper. Please enter your name\n");
                in.append((Item)name);
                in.addCommand(new Command("OK", 2, 1));
                in.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)in);
            } else {
                Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.mainMenu);
            }
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, maxX, maxY);
        g.setColor(0);
        g.drawLine(0, maxY - 1, maxX, maxY - 1);
        g.drawLine(0, maxY - 2, maxX, maxY - 2);
        if (this.state < this.y) {
            g.drawImage(GameScreen.icon[GameScreen.stateIcon[14 + Math.abs(this.state) % 2]], (maxX - GameScreen.jackX) / 2, this.y, 20);
        }
        g.drawImage(go, maxX / 2, this.state, 17);
    }

    static {
        name = new TextField("", "", 20, 0);
    }
}

