/*
 * Decompiled with CFR 0.152.
 */
package jack;

import jack.AnimationTask;
import jack.Digit;
import jack.Enemy;
import jack.Jack;
import jack.Options;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameScreen
extends Canvas
implements CommandListener,
Runnable {
    protected static Image[] icon;
    protected static int[] stateIcon;
    static int keyLeft;
    static int keyRight;
    static int keyUp;
    static int maxX;
    static int maxY;
    static int maxLines;
    static int holeMaxPos;
    static int lineSpace;
    static int jackX;
    static int jackY;
    static int indentY;
    static int enemySize;
    static Random gameRND;
    static Command pauseCommand;
    static Command unpauseCommand;
    static Command backCommand;
    Timer gameTimer;
    int state;
    int innerState;
    int posX;
    int posY;
    int newState;
    boolean jumpChecked;
    int gameLevel;
    int gameLives;
    int gameMaxLevel;
    int gameSpeed;
    Vector enemies;

    public GameScreen() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        gameRND = new Random();
        try {
            icon = new Image[21];
            GameScreen.icon[0] = Image.createImage((String)"/jack/stand1.png");
            GameScreen.icon[1] = Image.createImage((String)"/jack/stand2.png");
            GameScreen.icon[2] = Image.createImage((String)"/jack/stand3.png");
            GameScreen.icon[3] = Image.createImage((String)"/jack/runleft1.png");
            GameScreen.icon[4] = Image.createImage((String)"/jack/runleft2.png");
            GameScreen.icon[5] = Image.createImage((String)"/jack/runleft3.png");
            GameScreen.icon[6] = Image.createImage((String)"/jack/runleft4.png");
            GameScreen.icon[7] = Image.createImage((String)"/jack/runright1.png");
            GameScreen.icon[8] = Image.createImage((String)"/jack/runright2.png");
            GameScreen.icon[9] = Image.createImage((String)"/jack/runright3.png");
            GameScreen.icon[10] = Image.createImage((String)"/jack/runright4.png");
            GameScreen.icon[11] = Image.createImage((String)"/jack/jump1.png");
            GameScreen.icon[12] = Image.createImage((String)"/jack/block1.png");
            GameScreen.icon[13] = Image.createImage((String)"/jack/block2.png");
            GameScreen.icon[14] = Image.createImage((String)"/jack/fall1.png");
            GameScreen.icon[15] = Image.createImage((String)"/jack/fall2.png");
            GameScreen.icon[16] = Image.createImage((String)"/jack/fall3.png");
            GameScreen.icon[17] = Image.createImage((String)"/jack/lives.png");
            GameScreen.icon[18] = Image.createImage((String)"/jack/stand4.png");
            GameScreen.icon[19] = Image.createImage((String)"/jack/enemy1.png");
            GameScreen.icon[20] = Image.createImage((String)"/jack/enemy2.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            icon = null;
        }
        this.enemies = new Vector();
        maxX = this.getWidth();
        maxY = this.getHeight();
        holeMaxPos = maxX + enemySize;
        indentY = maxY <= 54 ? 1 : 8;
        if (!Options.readKeys()) {
            Options.keyLeft = this.getKeyCode(2);
            Options.keyRight = this.getKeyCode(5);
            Options.keyUp = this.getKeyCode(1);
        }
        this.setCommandListener(this);
    }

    private void startGameTimer() {
        this.removeCommand(unpauseCommand);
        this.removeCommand(backCommand);
        this.addCommand(pauseCommand);
        this.addCommand(backCommand);
        this.gameTimer = new Timer();
        this.gameTimer.scheduleAtFixedRate((TimerTask)new AnimationTask(this), 0L, (long)this.gameSpeed);
    }

    private void stopGameTimer() {
        this.gameTimer.cancel();
    }

    private void initGame() {
        maxLines = maxY / (1 + lineSpace + jackY);
        this.newState = -1;
        keyLeft = Options.keyLeft;
        keyRight = Options.keyRight;
        keyUp = Options.keyUp;
    }

    public void startNewGame() {
        this.initGame();
        indentY = 1;
        this.state = 0;
        this.innerState = 0;
        this.posX = (maxX - jackX) / 2;
        this.posY = 0;
        this.gameLevel = 0;
        this.gameMaxLevel = 0;
        this.gameLives = 1;
        this.gameSpeed = 60;
        this.enemies.removeAllElements();
        this.enemies.addElement(new Enemy(1, maxX, -1, 0));
        this.startGameTimer();
    }

    public void resumeGame() {
        this.initGame();
        this.startGameTimer();
    }

    private void moveLeft() {
        this.posX -= 2;
        if (this.posX < 0) {
            this.posX = maxX + this.posX;
        }
    }

    private void moveRight() {
        this.posX += 2;
        if (this.posX > maxX) {
            this.posX -= maxX;
        }
    }

    private void moveUp() {
        if (!this.jumpChecked && this.posY + 2 > lineSpace) {
            this.jumpChecked = true;
            boolean blocked = true;
            for (int i = 0; i < this.enemies.size() && blocked; ++i) {
                Enemy x = (Enemy)this.enemies.elementAt(i);
                if (x.line != this.gameLevel + 1 || Math.abs(x.pos - this.posX) >= enemySize / 2 && Math.abs(x.pos + enemySize - (this.posX + jackX - maxX)) >= enemySize / 2) continue;
                blocked = false;
            }
            if (blocked) {
                this.innerState = 0;
                this.state = 16;
            }
        } else {
            this.posY += 2;
            if (this.posY > lineSpace + jackY) {
                Enemy x;
                this.posY = 0;
                if (this.gameLevel++ == maxLines - 2) {
                    indentY = 0;
                }
                if (this.gameLevel > this.gameMaxLevel) {
                    this.gameMaxLevel = this.gameLevel;
                    if (this.gameMaxLevel % 50 == 0) {
                        ++this.gameLives;
                    }
                    if (this.gameMaxLevel % 15 == 0 && this.gameSpeed > 10) {
                        this.gameSpeed -= 10;
                        this.gameTimer.cancel();
                        this.startGameTimer();
                    }
                    if (this.gameMaxLevel % 10 == 0) {
                        x = new Enemy(this.gameMaxLevel, maxX, -1, 1);
                        this.enemies.addElement(x);
                    }
                }
                if (this.enemies.size() < this.gameMaxLevel + 2) {
                    x = new Enemy(Math.abs(gameRND.nextInt()) % (this.gameMaxLevel + 2) + 1, Math.abs(gameRND.nextInt()) % (maxX + enemySize) - enemySize, gameRND.nextInt(), 0);
                    this.enemies.addElement(x);
                }
                this.state = this.newState != -1 ? this.newState : 0;
                this.newState = -1;
            }
        }
    }

    private void moveDown() {
        this.posY -= 2;
        if (this.posY < 0) {
            if (this.gameLevel == maxLines - 2) {
                indentY = 1;
            }
            this.posY = 0;
            this.innerState = 0;
            this.state = 14;
        }
    }

    private boolean checkFall() {
        boolean fall = false;
        boolean hole = false;
        for (int i = 0; i < this.enemies.size() && !fall; ++i) {
            Enemy x = (Enemy)this.enemies.elementAt(i);
            if (x.line != this.gameLevel || Math.abs(x.pos - this.posX) >= enemySize / 4 && Math.abs(x.pos + enemySize - (this.posX + jackX - maxX)) >= enemySize / 4) continue;
            fall = true;
            hole = x.type == 0;
        }
        if (fall) {
            if (hole) {
                this.posY = lineSpace + jackY;
                --this.gameLevel;
            }
            this.innerState = 0;
            this.state = hole ? 13 : 14;
        }
        return fall;
    }

    private void moveEnemies() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            Enemy x = (Enemy)this.enemies.elementAt(i);
            x.pos += x.dir;
            if (x.pos < -enemySize) {
                ++x.line;
                if (x.line > this.gameMaxLevel + 2) {
                    x.line = 1;
                }
                x.pos = maxX;
            }
            if (x.pos <= maxX) continue;
            --x.line;
            if (x.line < 1) {
                x.line = this.gameMaxLevel + 2;
            }
            x.pos = -enemySize;
        }
    }

    private void changeState() {
        if (this.state < 4) {
            if (!this.checkFall()) {
                ++this.innerState;
                if (this.innerState >= 10) {
                    this.innerState = 0;
                    ++this.state;
                    this.state %= 4;
                }
            }
        } else if (this.state < 8) {
            if (!this.checkFall()) {
                this.moveLeft();
                ++this.state;
                this.state = 4 + (this.state - 4) % 4;
            }
        } else if (this.state < 12) {
            if (!this.checkFall()) {
                this.moveRight();
                ++this.state;
                this.state = 8 + (this.state - 8) % 4;
            }
        } else if (this.state == 12) {
            this.moveUp();
        } else if (this.state == 13) {
            this.moveDown();
        } else if (this.state < 16) {
            if (!this.checkFall()) {
                ++this.state;
                this.state = 14 + (this.state - 14) % 2;
                if (++this.innerState > 40) {
                    this.state = this.newState != -1 ? this.newState : 0;
                    this.newState = -1;
                    if (this.gameLevel == 0 && --this.gameLives == 0) {
                        this.stopGameTimer();
                        Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.gameOver);
                        Jack.gameOver.startAnimation();
                    }
                }
            }
        } else if (this.state == 16) {
            ++this.innerState;
            if (this.innerState > 4) {
                this.innerState = 0;
                this.state = 17;
            }
        } else if (this.state == 17) {
            ++this.innerState;
            if (this.innerState > 4) {
                this.state = 13;
            }
        }
    }

    public void run() {
        this.changeState();
        this.moveEnemies();
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == keyLeft && this.state < 4) {
            this.state = 4;
        } else if (keyCode == keyLeft && this.state >= 12 && this.state <= 17) {
            this.newState = 4;
        } else if (keyCode == keyRight && this.state < 4) {
            this.state = 8;
        } else if (keyCode == keyRight && this.state >= 12 && this.state <= 17) {
            this.newState = 8;
        } else if (keyCode == keyUp && this.state < 12) {
            this.innerState = this.state;
            this.jumpChecked = false;
            this.state = 12;
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == keyLeft) {
            if (this.state >= 4 && this.state < 8) {
                this.state = 2;
                this.innerState = 0;
            } else {
                this.newState = -1;
            }
        } else if (keyCode == keyRight) {
            if (this.state >= 8 && this.state < 12) {
                this.state = 0;
                this.innerState = 0;
            } else {
                this.newState = -1;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            this.stopGameTimer();
            if (this.gameMaxLevel > Options.bestScore) {
                Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.gameOver);
                Jack.gameOver.startAnimation();
            } else {
                Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.mainMenu);
            }
        }
        if (command.getCommandType() == 1) {
            this.stopGameTimer();
            this.removeCommand(pauseCommand);
            this.removeCommand(backCommand);
            this.addCommand(unpauseCommand);
            this.addCommand(backCommand);
        }
        if (command.getCommandType() == 4) {
            this.resumeGame();
        }
    }

    protected void paint(Graphics g) {
        int y;
        int i;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, maxX, maxY);
        g.setColor(0);
        for (int i2 = 0; i2 < this.gameLives; ++i2) {
            g.drawImage(icon[17], 1 + 7 * i2, 0, 20);
        }
        int x1 = Integer.toString(this.gameLevel).length();
        int x2 = Integer.toString(this.gameMaxLevel).length();
        Digit.drawHNumber(g, maxX - 5 * (x1 + x2 + 1), 0, this.gameLevel, 3);
        g.drawLine(maxX - 5 * (x2 + 1) + 1, 6, maxX - 5 * x2 - 2, 0);
        Digit.drawHNumber(g, maxX - 5 * x2, 0, this.gameMaxLevel, 3);
        for (i = 0; i <= maxLines; ++i) {
            int y2 = maxY - 1 - indentY - (lineSpace + jackY + 1) * i + (this.gameLevel < maxLines - 2 ? 0 : this.posY);
            g.drawLine(0, y2, maxX, y2);
        }
        if (this.gameLevel < maxLines - 1) {
            y = maxY - indentY + (this.gameLevel < maxLines - 2 ? 0 : this.posY);
            g.drawLine(0, y, maxX, y);
        }
        for (i = 0; i < this.enemies.size(); ++i) {
            Enemy x = (Enemy)this.enemies.elementAt(i);
            if (x.line > this.gameLevel + maxLines) continue;
            int y3 = maxY - 1 - indentY - (lineSpace + jackY + 1) * (x.line - (this.gameLevel <= maxLines - 2 ? 0 : this.gameLevel - maxLines + 2)) + (this.gameLevel < maxLines - 2 ? 0 : this.posY);
            if (x.type == 0) {
                g.setColor(0xFFFFFF);
                g.drawLine(x.pos, y3, x.pos + enemySize - 1, y3);
                continue;
            }
            g.setColor(0);
            g.drawImage(icon[18 + x.type + Math.abs(x.pos) % 2], x.pos, y3 - jackY, 20);
        }
        g.setColor(0);
        y = maxY - 1 - indentY - (lineSpace + jackY + 1) * (this.gameLevel < maxLines - 2 ? this.gameLevel : maxLines - 2) - jackY - (this.gameLevel < maxLines - 2 ? this.posY : 0);
        g.drawImage(icon[stateIcon[this.state]], this.posX, y, 20);
        if (this.posX >= maxX - jackX) {
            g.drawImage(icon[stateIcon[this.state]], this.posX - maxX, y, 20);
        }
    }

    static {
        stateIcon = new int[]{0, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 12, 13};
        lineSpace = 2;
        jackX = 16;
        jackY = 16;
        enemySize = 16;
        pauseCommand = new Command("Pause", 1, 1);
        unpauseCommand = new Command("Unpause", 4, 1);
        backCommand = new Command("Exit", 7, 2);
    }
}

