/*
 * Decompiled with CFR 0.152.
 */
package jack;

import jack.AnimationTask;
import jack.GameScreen;
import jack.Jack;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Splash
extends Canvas
implements CommandListener,
Runnable {
    private Timer animationTimer;
    int state;
    int innerState;
    private static int maxX;
    private static int maxY;
    private static int y;
    private static int[] jumpIcons;
    private static int[] heigh;
    private static Image logo;

    public Splash() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            logo = Image.createImage((String)"/jack/logo.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        maxX = this.getWidth();
        maxY = this.getHeight();
        y = Math.min((maxY - logo.getHeight()) / 2, maxY - 2 - GameScreen.jackY - logo.getHeight() - 2);
        this.setCommandListener(this);
    }

    public void startAnimation() {
        this.state = 0;
        this.innerState = 0;
        this.animationTimer = new Timer();
        this.animationTimer.scheduleAtFixedRate((TimerTask)new AnimationTask(this), 0L, 75L);
    }

    public void run() {
        ++this.innerState;
        if (this.innerState > maxX) {
            if (this.state == 0) {
                ++this.state;
                this.innerState = 0;
                this.stopAnimation();
                this.animationTimer = new Timer();
                this.animationTimer.scheduleAtFixedRate((TimerTask)new AnimationTask(this), 0L, 100L);
            } else {
                this.stopAnimation();
                this.menu();
                return;
            }
        }
        this.repaint();
    }

    private void menu() {
        Display.getDisplay((MIDlet)Jack.instance).setCurrent((Displayable)Jack.mainMenu);
    }

    private void stopAnimation() {
        this.animationTimer.cancel();
    }

    protected void keyPressed(int keyCode) {
        this.stopAnimation();
        this.menu();
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, maxX, maxY);
        g.setColor(0);
        g.drawLine(0, maxY - 1, maxX, maxY - 1);
        g.drawLine(0, maxY - 2, maxX, maxY - 2);
        g.drawImage(logo, maxX / 2, y, 17);
        if (this.state == 0) {
            g.drawImage(GameScreen.icon[GameScreen.stateIcon[4 + this.innerState % 4]], maxX - this.innerState, maxY - 2 - GameScreen.jackY, 20);
        } else {
            g.drawImage(GameScreen.icon[jumpIcons[this.innerState % jumpIcons.length]], 0, maxY - 2 - GameScreen.jackY - heigh[this.innerState % heigh.length], 20);
        }
    }

    static {
        jumpIcons = new int[]{0, 18, 14, 18, 0, 0};
        heigh = new int[]{0, 1, 2, 1, 0, 0};
    }
}

