/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.core.attributes.verification;

import java.io.IOException;
import ru.andrew.jclazz.core.Clazz;
import ru.andrew.jclazz.core.ClazzException;
import ru.andrew.jclazz.core.attributes.verification.AppendFrame;
import ru.andrew.jclazz.core.attributes.verification.ChopFrame;
import ru.andrew.jclazz.core.attributes.verification.FullFrame;
import ru.andrew.jclazz.core.attributes.verification.SameFrame;
import ru.andrew.jclazz.core.attributes.verification.SameFrameExtended;
import ru.andrew.jclazz.core.attributes.verification.SameLocals1StackItemFrame;
import ru.andrew.jclazz.core.attributes.verification.SameLocals1StackItemFrameExtended;
import ru.andrew.jclazz.core.io.ClazzInputStream;
import ru.andrew.jclazz.core.io.ClazzOutputStream;

public abstract class StackMapFrame {
    public int a;

    public StackMapFrame(int n) {
        this.a = n;
    }

    public abstract void load(ClazzInputStream var1, Clazz var2) throws IOException, ClazzException;

    public abstract void store(ClazzOutputStream var1) throws IOException;

    public abstract int getOffsetDelta();

    public static StackMapFrame loadStackMapFrame(ClazzInputStream clazzInputStream, Clazz clazz) throws IOException, ClazzException {
        StackMapFrame stackMapFrame;
        int n = clazzInputStream.readU1();
        if (n >= 0 && n <= 63) {
            stackMapFrame = new SameFrame(n);
        } else if (n >= 64 && n <= 127) {
            stackMapFrame = new SameLocals1StackItemFrame(n);
        } else {
            if (n >= 128 && n <= 246) {
                throw new ClazzException("Unsupported StackMapFrame type");
            }
            if (n == 247) {
                stackMapFrame = new SameLocals1StackItemFrameExtended(n);
            } else if (n >= 248 && n <= 250) {
                stackMapFrame = new ChopFrame(n);
            } else if (n == 251) {
                stackMapFrame = new SameFrameExtended(n);
            } else if (n >= 252 && n <= 254) {
                stackMapFrame = new AppendFrame(n);
            } else if (n == 255) {
                stackMapFrame = new FullFrame(n);
            } else {
                throw new ClazzException("Unknown StackMapFrame type");
            }
        }
        ((StackMapFrame)stackMapFrame).load(clazzInputStream, clazz);
        return stackMapFrame;
    }

    public static String a(StackMapFrame stackMapFrame) {
        return stackMapFrame.getClass().getName().substring(stackMapFrame.getClass().getName().lastIndexOf(46) + 1) + " (+" + stackMapFrame.getOffsetDelta() + "): ";
    }
}

