/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.core.infoj;

import java.io.PrintStream;
import java.util.Enumeration;
import ru.andrew.jclazz.core.Clazz;
import ru.andrew.jclazz.core.FieldInfo;
import ru.andrew.jclazz.core.MethodInfo;
import ru.andrew.jclazz.core.attributes.AttributeInfo;
import ru.andrew.jclazz.core.attributes.Code;
import ru.andrew.jclazz.core.attributes.ExceptionTable;
import ru.andrew.jclazz.core.code.ops.Operation;
import ru.andrew.jclazz.core.constants.CONSTANT;
import ru.andrew.jclazz.core.constants.CONSTANT_Class;

public class ClazzPrinter {
    private PrintStream a;

    public ClazzPrinter(PrintStream printStream) {
        this.a = printStream;
    }

    public void close() {
        this.a.close();
    }

    public void print(Clazz clazz) {
        this.a.println("This Class  : " + clazz.getThisClassInfo().getFullyQualifiedName());
        this.a.println("Super Class : " + (clazz.getSuperClassInfo() != null ? clazz.getSuperClassInfo().getFullyQualifiedName() : ""));
        this.a.println("Implemented Interfaces:");
        CONSTANT_Class[] cONSTANT_ClassArray = clazz.getInterfaces();
        for (int i = 0; i < cONSTANT_ClassArray.length; ++i) {
            this.a.println("   " + cONSTANT_ClassArray[i].getFullyQualifiedName());
        }
        this.a.println();
        this.a.println("Version: " + clazz.getVersion());
        this.a.println("JVM supported: " + clazz.getJVMSupportedVersion());
        this.a.println();
        this.a.print("Access Flags: " + clazz.getAccessFlags() + " (");
        if ((clazz.getAccessFlags() & 1) > 0) {
            this.a.print(" PUBLIC ");
        }
        if ((clazz.getAccessFlags() & 0x10) > 0) {
            this.a.print(" FINAL ");
        }
        if ((clazz.getAccessFlags() & 0x20) > 0) {
            this.a.print(" SUPER ");
        }
        if ((clazz.getAccessFlags() & 0x200) > 0) {
            this.a.print(" INTERFACE ");
        }
        if ((clazz.getAccessFlags() & 0x400) > 0) {
            this.a.print(" ABSTRACT ");
        }
        if ((clazz.getAccessFlags() & 0x1000) > 0) {
            this.a.print(" SYNTHETIC ");
        }
        if ((clazz.getAccessFlags() & 0x2000) > 0) {
            this.a.print(" ANNOTATION ");
        }
        if ((clazz.getAccessFlags() & 0x4000) > 0) {
            this.a.print(" ENUM ");
        }
        this.a.println(")");
        this.a.println();
        this.a.println("Attributes:");
        AttributeInfo[] attributeInfoArray = clazz.getAttributes();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            this.a.println(attributeInfoArray[i].toString());
        }
        this.a.println();
        this.a.println("Fields:");
        FieldInfo[] fieldInfoArray = clazz.getFields();
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            ClazzPrinter.printField(this.a, fieldInfoArray[i]);
            this.a.println();
        }
        this.a.println();
        this.a.println("Methods:");
        MethodInfo[] methodInfoArray = clazz.getMethods();
        for (int i = 0; i < methodInfoArray.length; ++i) {
            ClazzPrinter.printMethod(this.a, methodInfoArray[i]);
            this.a.println();
        }
        this.a.println("Constant Pool:");
        CONSTANT[] cONSTANTArray = clazz.getConstant_pool();
        for (int i = 0; i < cONSTANTArray.length; ++i) {
            this.a.print(i + ": ");
            if (cONSTANTArray[i] != null) {
                String string = cONSTANTArray[i].getClass().getName();
                string = string.substring(string.indexOf(95) + 1);
                this.a.print(string + ": ");
                this.a.print(cONSTANTArray[i].getValue());
            }
            this.a.println();
        }
    }

    public static void printField(PrintStream printStream, FieldInfo fieldInfo) {
        printStream.println(fieldInfo.getName() + " : " + fieldInfo.getDescriptor().getFQN());
        printStream.println("{");
        printStream.print("    Access Flags: " + fieldInfo.getAccessFlags() + " (");
        if ((fieldInfo.getAccessFlags() & 1) > 0) {
            printStream.print(" PUBLIC ");
        }
        if ((fieldInfo.getAccessFlags() & 2) > 0) {
            printStream.print(" PRIVATE ");
        }
        if ((fieldInfo.getAccessFlags() & 4) > 0) {
            printStream.print(" PROTECTED ");
        }
        if ((fieldInfo.getAccessFlags() & 8) > 0) {
            printStream.print(" STATIC ");
        }
        if ((fieldInfo.getAccessFlags() & 0x10) > 0) {
            printStream.print(" FINAL ");
        }
        if ((fieldInfo.getAccessFlags() & 0x40) > 0) {
            printStream.print(" VOLATILE ");
        }
        if ((fieldInfo.getAccessFlags() & 0x80) > 0) {
            printStream.print(" TRANSIENT ");
        }
        if ((fieldInfo.getAccessFlags() & 0x1000) > 0) {
            printStream.print(" SYNTHETIC ");
        }
        if ((fieldInfo.getAccessFlags() & 0x4000) > 0) {
            printStream.print(" ENUM ");
        }
        printStream.println(")");
        printStream.println();
        printStream.println("    Attributes:");
        AttributeInfo[] attributeInfoArray = fieldInfo.getAttributes();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            printStream.println("        " + attributeInfoArray[i]);
        }
        printStream.println("}");
    }

    public static void printMethod(PrintStream printStream, MethodInfo methodInfo) {
        Object object;
        int n;
        printStream.println(methodInfo.getName() + " : " + methodInfo.getDescriptor());
        printStream.println("{");
        printStream.print("    Access Flags: " + methodInfo.getAccessFlags() + " (");
        if ((methodInfo.getAccessFlags() & 1) > 0) {
            printStream.print(" PUBLIC ");
        }
        if ((methodInfo.getAccessFlags() & 2) > 0) {
            printStream.print(" PRIVATE ");
        }
        if ((methodInfo.getAccessFlags() & 4) > 0) {
            printStream.print(" PROTECTED ");
        }
        if ((methodInfo.getAccessFlags() & 8) > 0) {
            printStream.print(" STATIC ");
        }
        if ((methodInfo.getAccessFlags() & 0x10) > 0) {
            printStream.print(" FINAL ");
        }
        if ((methodInfo.getAccessFlags() & 0x20) > 0) {
            printStream.print(" SYNCHRONIZED ");
        }
        if ((methodInfo.getAccessFlags() & 0x40) > 0) {
            printStream.print(" BRIDGE ");
        }
        if ((methodInfo.getAccessFlags() & 0x80) > 0) {
            printStream.print(" VARARGS ");
        }
        if ((methodInfo.getAccessFlags() & 0x100) > 0) {
            printStream.print(" NATIVE ");
        }
        if ((methodInfo.getAccessFlags() & 0x400) > 0) {
            printStream.print(" ABSTRACT ");
        }
        if ((methodInfo.getAccessFlags() & 0x800) > 0) {
            printStream.print(" STRICT ");
        }
        if ((methodInfo.getAccessFlags() & 0x1000) > 0) {
            printStream.print(" SYNTHETIC ");
        }
        printStream.println(")");
        printStream.println();
        printStream.println("    Attributes:");
        AttributeInfo[] attributeInfoArray = methodInfo.getAttributes();
        Code code = null;
        for (n = 0; n < attributeInfoArray.length; ++n) {
            if (attributeInfoArray[n] instanceof Code) {
                code = (Code)attributeInfoArray[n];
                continue;
            }
            object = attributeInfoArray[n].toString();
            printStream.println("    " + (String)object);
        }
        if (code != null) {
            printStream.println("    CODE");
            printStream.println("       (");
            printStream.println("        Max stack = " + code.getMaxStack());
            printStream.println("        Max locals = " + code.getMaxLocals());
            printStream.println("        Attributes:");
            for (n = 0; n < code.getAttributes().length; ++n) {
                object = code.getAttributes()[n].toString();
                printStream.println("            " + (String)object);
            }
            printStream.println("        Exceptions:");
            for (n = 0; n < code.getExceptionTable().length; ++n) {
                object = code.getExceptionTable()[n];
                printStream.println("            [" + ((ExceptionTable)object).start_pc + "-" + ((ExceptionTable)object).end_pc + "): " + ((ExceptionTable)object).handler_pc + (((ExceptionTable)object).catch_type != null ? " - " + ((ExceptionTable)object).catch_type.getFullyQualifiedName() : ""));
            }
            printStream.println("       )");
            printStream.println("    {");
            Enumeration enumeration = code.getOperations().elements();
            while (enumeration.hasMoreElements()) {
                object = (Operation)enumeration.nextElement();
                printStream.println("        " + ((Operation)object).asString());
            }
            printStream.println("    }");
        }
        printStream.println("}");
    }
}

