/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.midlet.MIDlet;

public class TeachForm
extends Form
implements CommandListener,
ItemStateListener {
    Dictionary dictionary;
    ChoiceGroup variants;
    boolean[] flags;
    Random rand;
    Vector repeat;
    int lang;
    int[] nWords;
    int nAttempts;
    int counter;
    int correctIndex;
    Pair question;
    static final int N_VARIANTS = 4;
    static final int REPEAT_ITERVAL = 5;
    static final int REPEAT_THRESHOLD = 10;

    TeachForm(Dictionary dictionary, boolean[] blArray) {
        super("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435");
        int n;
        this.dictionary = dictionary;
        this.flags = blArray;
        this.repeat = new Vector();
        this.nWords = new int[2];
        this.variants = new ChoiceGroup(null, 2);
        this.rand = new Random();
        for (n = 0; n < 4; ++n) {
            this.variants.append("?", null);
        }
        for (n = 0; n <= 1; ++n) {
            this.nWords[n] = dictionary.volumes[n][dictionary.nVolumes[n] - 1].index;
        }
        this.append((Item)this.variants);
        this.update();
        this.setItemStateListener(this);
        this.addCommand(Dictionary.TRANSLATE_CMD);
        this.addCommand(Dictionary.QUIT_CMD);
        this.setCommandListener(this);
        Display.getDisplay((MIDlet)dictionary).setCurrent((Displayable)this);
    }

    int next(int n) {
        return (this.rand.nextInt() & Integer.MAX_VALUE) % n;
    }

    private void update() {
        int n;
        do {
            this.lang = 1 - this.lang;
        } while (!this.flags[this.lang]);
        if (this.repeat.size() > 10 || this.repeat.size() != 0 && ++this.counter == 5) {
            this.counter = 0;
            n = this.next(this.repeat.size());
            this.question = (Pair)this.repeat.elementAt(n);
            this.repeat.removeElementAt(n);
        } else {
            this.question = this.dictionary.getWordPair(this.lang, this.next(this.nWords[this.lang]));
        }
        this.variants.setLabel(this.question.word);
        this.correctIndex = this.next(4);
        for (n = 0; n < 4; ++n) {
            int n2 = n == this.correctIndex ? this.question.index : this.next(this.nWords[1 - this.lang]);
            this.variants.set(n, this.dictionary.getWordPair((int)(1 - this.lang), (int)n2).word, null);
        }
        this.variants.setSelectedFlags(new boolean[4]);
        this.nAttempts = 0;
    }

    public void itemStateChanged(Item item) {
        boolean[] blArray = new boolean[4];
        this.variants.getSelectedFlags(blArray);
        if (!blArray[this.correctIndex]) {
            ++this.nAttempts;
            Alert alert = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430", "\u041d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e!", null, AlertType.ERROR);
            Display.getDisplay((MIDlet)this.dictionary).setCurrent(alert, (Displayable)this);
        } else {
            if (this.nAttempts != 0) {
                this.repeat.addElement(this.question);
            }
            this.update();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Dictionary.QUIT_CMD) {
            this.dictionary.destroyApp(true);
            this.dictionary.notifyDestroyed();
        } else if (command == Dictionary.TRANSLATE_CMD) {
            new TranslateForm(this.dictionary, this, this.question.word);
        }
    }
}

