/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.util;

import com.mot.j2me.midlets.util.AbstractMIDlet;
import com.mot.j2me.midlets.util.BasicInitNavigation;
import com.mot.j2me.midlets.util.Presentation;
import java.util.Hashtable;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public abstract class ApplicationController {
    public static final int PRESENTATION_SCREEN = -10;
    public static final int MAIN_MENU_SCREEN = -11;
    public static final int NO_SCREEN = -12;
    private Hashtable screenTable = new Hashtable();
    private int currentScreen = -12;
    private static ApplicationController instance;

    public void addScreen(int n, Displayable displayable) throws IllegalArgumentException {
        if (n == -10 || n == -11) {
            throw new IllegalArgumentException();
        }
        this.screenTable.put(new Integer(n), displayable);
    }

    public void changeScreen(int n) {
        Displayable displayable = (Displayable)this.screenTable.get(new Integer(n));
        if (displayable != null) {
            AbstractMIDlet.getDisplay().setCurrent(displayable);
            this.currentScreen = n;
        }
    }

    public int getCurrentScreen() {
        return this.currentScreen;
    }

    public static ApplicationController getInstance(String string) {
        if (instance == null) {
            try {
                instance = (ApplicationController)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    public Displayable getScreen(int n) throws IllegalArgumentException {
        return (Displayable)this.screenTable.get(new Integer(n));
    }

    public abstract void paintScreen(String var1, Graphics var2);

    public abstract void processAction(int var1);

    public void removeScreen(int n) {
        this.screenTable.remove(this.getScreen(n));
    }

    public void setMainMenu(BasicInitNavigation basicInitNavigation) {
        this.screenTable.put(new Integer(-11), basicInitNavigation);
    }

    public void setPresentation(Presentation presentation) {
        this.screenTable.put(new Integer(-10), presentation);
    }

    public abstract void startAppAction();
}

