/*
 * Decompiled with CFR 0.152.
 */
package midppy.pingpong;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import midppy.pingpong.AboutScreen;
import midppy.pingpong.GameModel;
import midppy.pingpong.HelpScreen;
import midppy.pingpong.MainMIDlet;
import midppy.pingpong.ManageableScreen;
import midppy.pingpong.ScoreScreen;
import midppy.pingpong.StageScreen;

public class ChooserScreen
extends List
implements ManageableScreen,
CommandListener {
    private final Command cmdSelect = new Command("Next", 6, 0);
    private final Command cmdHelp = new Command("Help", 6, 1);
    private final Command cmdAbout = new Command("About", 6, 2);
    private final Command cmdTopScores = new Command("Top Scores", 6, 3);
    private final Command cmdSoundOn = new Command("Sound on", 1, 4);
    private final Command cmdSoundOff = new Command("Sound off", 1, 5);
    private final Command cmdBack = new Command("Back", 1, 6);
    private MainMIDlet midlet;
    GameModel gm;

    public ChooserScreen() {
        super("Characters", 3);
    }

    public void initScreen(MainMIDlet mainMIDlet) {
        this.midlet = mainMIDlet;
        this.gm = mainMIDlet.gm;
        this.gm.resetGame();
        this.setTitle(mainMIDlet.getAppProperty("MIDlet-Name"));
        this.append("Forehand King", this.gm.imgCharacters[0]);
        this.append("Backhand King", this.gm.imgCharacters[1]);
        this.append("Balanced Player", this.gm.imgCharacters[2]);
        this.addCommand(this.cmdSelect);
        this.addCommand(this.cmdHelp);
        this.addCommand(this.cmdBack);
        this.addCommand(this.cmdAbout);
        this.addCommand(this.cmdTopScores);
    }

    public void startScreen() {
        this.setCommandListener(this);
        if (this.midlet.soundEnabled) {
            this.addCommand(this.cmdSoundOff);
            this.removeCommand(this.cmdSoundOn);
        } else {
            this.removeCommand(this.cmdSoundOff);
            this.addCommand(this.cmdSoundOn);
        }
    }

    public void disposeScreen() {
    }

    public void pauseScreen() {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdSelect) {
            StageScreen stageScreen = new StageScreen();
            GameModel gameModel = this.midlet.gm;
            gameModel.hindex = this.getSelectedIndex();
            gameModel.imgHumanMidppy = gameModel.imgCharacters[gameModel.hindex];
            gameModel.imgHumanMidppyJump = gameModel.imgCharactersJump[gameModel.hindex];
            if (this.midlet.debug) {
                System.out.println("select the character at " + gameModel.hindex);
            }
            stageScreen.initScreen(this.midlet);
            this.midlet.showScreen(stageScreen);
        } else if (command == this.cmdHelp) {
            this.midlet.showNMScreen(new HelpScreen(), this);
        } else if (command == this.cmdAbout) {
            this.midlet.showNMScreen(new AboutScreen(), this);
        } else if (command == this.cmdTopScores) {
            this.midlet.showNMScreen(new ScoreScreen(), this);
        } else if (command == this.cmdBack) {
            this.midlet.showScreen(this.midlet.mainScreen);
        } else if (command == this.cmdSoundOn) {
            this.removeCommand(this.cmdSoundOn);
            this.midlet.soundEnabled = true;
            this.addCommand(this.cmdSoundOff);
        } else if (command == this.cmdSoundOff) {
            this.removeCommand(this.cmdSoundOff);
            this.midlet.soundEnabled = false;
            this.addCommand(this.cmdSoundOn);
        }
    }
}

