/*
 * Decompiled with CFR 0.152.
 */
package midppy.pingpong;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class GameModel {
    public static final String IMG_PINGPONGTABLE = "/res/pingpong-table.png";
    public static final String[] IMG_ROBOTS = new String[]{"/res/midppy-g10.png", "/res/midppy-b10.png", "/res/midppy-r10.png"};
    public static final String[] IMG_ROBOTS_JUMP = new String[]{"/res/midppy-gj10.png", "/res/midppy-bj10.png", "/res/midppy-rj10.png"};
    public static final String[] IMG_CHARACTERS = new String[]{"/res/Midppy_ground_28x28_green.png", "/res/Midppy_ground_28x28_blue.png", "/res/Midppy_ground_28x28_orange.png"};
    public static final String[] IMG_CHARACTERS_JUMP = new String[]{"/res/Midppy_jump_28x28_green.png", "/res/Midppy_jump_28x28_blue.png", "/res/Midppy_jump_28x28_orange.png"};
    public static final int JUMP_LEFT = 10;
    public static final int JUMP_RIGHT = 11;
    public static final int HIT_LEFTMOST = 0;
    public static final int HIT_LEFT = 1;
    public static final int HIT_FORWARD = 2;
    public static final int HIT_RIGHT = 3;
    public static final int HIT_RIGHTMOST = 4;
    public static final int MAX_STAGE = 5;
    public static final int TWIDTH = 1000;
    public static final int TDEPTH = 2000;
    public static final int XRAIO = 11;
    public static final int MIN_POS = 1;
    public static final int MAX_POS = 7;
    public static final int XINTERVAL = 166;
    public static final int CREATED = 0;
    public static final int PLAYING = 1;
    public static final int STAGE_OVER = 2;
    public static final int GAME_OVER = 3;
    public static final int GAME_CHAMPION = 4;
    protected int status = 0;
    protected boolean indicator = true;
    protected int hindex;
    protected int hLatchedHit;
    protected Image[] imgRobots;
    protected Image[] imgRobotsJump;
    protected Image[] imgCharacters;
    protected Image[] imgCharactersJump;
    protected Image imgCover;
    protected Image imgCompMidppy;
    protected Image imgCompMidppyJump;
    protected Image imgHumanMidppy;
    protected Image imgHumanMidppyJump;
    protected Image imgTable;
    int[][] hMiss = new int[][]{{5, 4, 3, 2, 1, 0, 0}, {0, 0, 1, 2, 3, 4, 5}, {4, 2, 0, 0, 0, 2, 4}};
    int[] strikeDirs = new int[]{-286, -154, 0, 154, 286, -386, 386};
    int[] serviceBallHeights = new int[]{300, 200, 0, 200, 300, 240, 180, 0, 180, 240, 290};
    int[] serviceBallYPos = new int[]{2000, 1750, 1500, 1250, 1000, 850, 700, 500, 300, 150, 0};
    int[] strikeBallHeights = new int[]{280, 290, 270, 240, 200, 150, 90, 0, 90, 150, 280};
    int[] strikeBallYPos = new int[]{2000, 1750, 1500, 1250, 1000, 850, 700, 500, 300, 150, 0};
    protected int stage;
    protected int humanPos = 4;
    protected int humanOldPos = 4;
    protected int computerPos = 4;
    protected int computerOldPos = 4;
    protected int ballXPos = 500;
    protected int ballYPos = 2000;
    protected int ballOldYPos = 2000;
    protected int ballZPos = 300;
    boolean bService = true;
    boolean bRobotStriked = false;
    boolean bBallMoving = false;
    boolean bBallOut = false;
    boolean bBallMissed = false;
    boolean bBallHitTable = false;
    protected int ballXDirection = 0;
    protected int serviceIndex = 0;
    protected int strikeIndex = 0;
    protected int strikeCount = 0;
    protected int movementCount = 0;
    boolean ballStriked = false;
    public static final int MAX_POINT = 5;
    protected int[] cPoints;
    protected int[] hPoints;
    protected String[] tsNames;
    protected int[] tsScores;
    boolean forgive = true;
    protected Random ranSeed = new Random(System.currentTimeMillis());
    int curve = 0;

    public GameModel() {
        this.tsNames = new String[5];
        this.tsScores = new int[5];
        this.resetGame();
        this.imgCharacters = new Image[3];
        this.imgCharactersJump = new Image[3];
        this.imgRobots = new Image[3];
        this.imgRobotsJump = new Image[3];
        try {
            this.imgTable = Image.createImage((String)IMG_PINGPONGTABLE);
            int n = 0;
            while (n < 3) {
                this.imgCharacters[n] = Image.createImage((String)IMG_CHARACTERS[n]);
                this.imgCharactersJump[n] = Image.createImage((String)IMG_CHARACTERS_JUMP[n]);
                this.imgRobots[n] = Image.createImage((String)IMG_ROBOTS[n]);
                this.imgRobotsJump[n] = Image.createImage((String)IMG_ROBOTS_JUMP[n]);
                ++n;
            }
            this.imgCompMidppy = this.imgRobots[this.stage % this.imgRobots.length];
            this.imgCompMidppyJump = this.imgRobotsJump[this.stage % this.imgRobots.length];
            this.imgHumanMidppy = this.imgCharacters[1];
            this.imgHumanMidppyJump = this.imgCharactersJump[1];
        }
        catch (IOException iOException) {
            System.out.println("game model load img exception");
            iOException.printStackTrace();
        }
    }

    public synchronized void resetGame() {
        this.bService = true;
        this.stage = 0;
        this.cPoints = new int[5];
        this.hPoints = new int[5];
        this.humanPos = 4;
        this.humanOldPos = 4;
        this.computerPos = 4;
        this.computerOldPos = 4;
        this.nextPoint();
        this.status = 1;
    }

    public synchronized void addPoint() {
        if (this.bBallMoving) {
            this.bBallMoving = false;
            if (this.bRobotStriked) {
                if (this.bBallOut) {
                    int n = this.stage;
                    this.hPoints[n] = this.hPoints[n] + 1;
                } else if (this.bBallMissed) {
                    int n = this.stage;
                    this.cPoints[n] = this.cPoints[n] + 1;
                }
            } else if (this.bBallOut) {
                int n = this.stage;
                this.cPoints[n] = this.cPoints[n] + 1;
            } else if (this.bBallMissed) {
                int n = this.stage;
                this.hPoints[n] = this.hPoints[n] + 1;
            }
            if (this.stage == 5) {
                this.status = 4;
            } else if (this.cPoints[this.stage] == 5) {
                this.status = 3;
            } else if (this.hPoints[this.stage] == 5) {
                this.status = 2;
            }
        }
    }

    public synchronized void nextPoint() {
        this.serviceIndex = 0;
        this.bService = true;
        this.bRobotStriked = false;
        this.bBallMoving = false;
        this.bBallOut = false;
        this.bBallMissed = false;
        this.ballXPos = this.getHumanXPos();
        this.ballYPos = 2000;
        this.ballOldYPos = 2000;
        this.ballZPos = 300;
        this.ballXDirection = 0;
        this.strikeIndex = 0;
        this.hLatchedHit = -1;
        this.strikeCount = 0;
        this.movementCount = 0;
        this.curve = 0;
    }

    public synchronized void nextStage() {
        ++this.stage;
        this.cPoints[this.stage] = 0;
        this.hPoints[this.stage] = 0;
        this.imgCompMidppy = this.imgRobots[this.stage % this.imgRobots.length];
        this.imgCompMidppyJump = this.imgRobotsJump[this.stage % this.imgRobots.length];
        this.humanPos = 4;
        this.humanOldPos = 4;
        this.computerPos = 4;
        this.computerOldPos = 4;
        this.nextPoint();
        this.status = 1;
    }

    public int getTotalScore() {
        int n = this.stage * 100;
        int n2 = 0;
        while (n2 < this.stage) {
            n += (this.hPoints[n2] - this.cPoints[n2]) * 10;
            ++n2;
        }
        return n;
    }

    public synchronized boolean isBallStriked() {
        if (this.ballStriked) {
            this.ballStriked = false;
            return true;
        }
        return false;
    }

    public int getRobotXPos() {
        return (this.computerPos - 1) * 166;
    }

    public boolean isCloseToRobot() {
        boolean bl;
        int n = this.ballXPos - this.getRobotXPos();
        boolean bl2 = bl = Math.abs(n) < 166;
        if (bl) {
            return true;
        }
        if (this.ballXPos > 1000 && n > 0) {
            return true;
        }
        return this.ballXPos < 0 && n < 0;
    }

    public int getHumanXPos() {
        return (this.humanPos - 1) * 166;
    }

    public boolean isCloseToHuman() {
        boolean bl;
        int n = this.ballXPos - this.getHumanXPos();
        boolean bl2 = bl = Math.abs(n) < 111;
        if (bl) {
            return true;
        }
        return this.ballXPos > 1000 && n > 0 || this.ballXPos < 0 && n < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(int n) {
        if (!this.bBallMoving && this.serviceIndex != 0) {
            return;
        }
        switch (n) {
            case 10: {
                if (this.humanPos <= 1) break;
                --this.humanPos;
                if (this.bBallMoving) break;
                this.ballXPos = this.getHumanXPos();
                break;
            }
            case 11: {
                if (this.humanPos >= 7) break;
                ++this.humanPos;
                if (this.bBallMoving) break;
                this.ballXPos = this.getHumanXPos();
                break;
            }
            default: {
                if (this.ballYPos < 1500 || (this.bBallMoving || !this.bService) && (!this.bBallMoving || !this.bRobotStriked)) break;
                GameModel gameModel = this;
                synchronized (gameModel) {
                    if (this.hLatchedHit == -1) {
                        ++this.strikeCount;
                        this.hLatchedHit = n;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateBallPosition() {
        int n;
        int n2;
        if (this.bBallMoving) {
            this.ballOldYPos = this.ballYPos;
            if (this.bService) {
                if (this.serviceIndex < this.serviceBallHeights.length - 1) {
                    ++this.serviceIndex;
                    this.ballXPos += this.ballXDirection * Math.abs(this.serviceBallYPos[this.serviceIndex] - this.serviceBallYPos[this.serviceIndex - 1]) / 500;
                    this.ballYPos = this.serviceBallYPos[this.serviceIndex];
                    this.ballZPos = this.serviceBallHeights[this.serviceIndex];
                }
            } else if (this.strikeIndex < this.strikeBallHeights.length - 1) {
                ++this.strikeIndex;
                this.ballXPos += this.ballXDirection * Math.abs(this.strikeBallYPos[this.strikeIndex] - this.strikeBallYPos[this.strikeIndex - 1]) / 500;
                this.ballZPos = this.strikeBallHeights[this.strikeIndex];
                this.ballYPos = this.bRobotStriked ? 2000 - this.strikeBallYPos[this.strikeIndex] : this.strikeBallYPos[this.strikeIndex];
                this.ballXPos += this.curve * this.strikeIndex / 2;
            }
            if (this.ballZPos == 0 && (this.bRobotStriked && this.ballYPos > 1000 || !this.bRobotStriked)) {
                if (this.ballXPos < 0 || this.ballXPos > 1000) {
                    this.bBallOut = true;
                    this.bBallHitTable = false;
                    this.addPoint();
                } else {
                    this.bBallHitTable = true;
                    this.ballXPos += this.curve * this.strikeIndex / 2;
                }
                this.curve = 0;
            }
        }
        try {
            n2 = (this.computerPos - 1) * 166;
            n = Math.abs(this.ranSeed.nextInt() % 100);
            int n3 = this.stage * 40 - this.strikeCount * (10 - this.stage) - this.movementCount + 100;
            if (2000 - this.ballYPos > 0) {
                int n4 = this.ballXDirection * this.ballYPos / 500 + this.ballXPos;
                int n5 = n4 - n2;
                if (this.ballYPos > 10) {
                    if (this.bBallMoving) {
                        if (n5 < -55) {
                            if (this.computerPos >= 1) {
                                ++this.movementCount;
                                --this.computerPos;
                            } else if (this.movementCount > 0) {
                                --this.movementCount;
                            }
                        } else if (n5 > 55) {
                            if (this.computerPos <= 7) {
                                ++this.movementCount;
                                ++this.computerPos;
                            } else if (this.movementCount > 0) {
                                --this.movementCount;
                            }
                        }
                    }
                } else if (this.isCloseToRobot()) {
                    int n6 = Math.abs(this.ranSeed.nextInt() % 5);
                    int n7 = this.ranSeed.nextInt();
                    int n8 = n7 % ((5 - this.stage) * 50 + 1);
                    boolean bl = Math.abs(this.ranSeed.nextInt() % 2) == 0;
                    int n9 = Math.abs(this.ranSeed.nextInt() % 4);
                    boolean bl2 = Math.abs(this.ranSeed.nextInt() % 3) == 0;
                    ++this.strikeCount;
                    int n10 = Math.abs(this.ballXDirection / 4) - (this.stage + 1) * (this.stage + 1) * (this.stage + 1);
                    int n11 = n + n3 - n10;
                    if (n11 > -10 || this.ballXDirection == 0) {
                        if (this.bService) {
                            this.bService = false;
                            this.bRobotStriked = true;
                        } else {
                            this.bRobotStriked = !this.bRobotStriked;
                        }
                        this.strikeIndex = 0;
                        this.bBallHitTable = false;
                        switch (this.stage) {
                            case 0: {
                                this.ballXDirection = n7 % 120 - this.ballXDirection;
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (this.ballXDirection < 0 && bl) {
                                    this.ballXDirection = -this.ballXPos / 3 + n8 * 2;
                                    break;
                                }
                                this.ballXDirection = (1000 - this.ballXPos) / 3 - n8 * 2;
                                break;
                            }
                            default: {
                                if (n9 == this.stage) {
                                    this.curve = 0;
                                    if (this.ballXDirection < 0 && bl) {
                                        this.ballXDirection = -this.ballXPos / 3 + n8 * 2;
                                        break;
                                    }
                                    this.ballXDirection = (1000 - this.ballXPos) / 3 - n8 * 2;
                                    break;
                                }
                                if (this.humanPos == 4 && Math.abs(this.humanPos - this.computerPos) < 2) {
                                    if (this.stage == 3) {
                                        this.ballXDirection = 0;
                                        this.curve = Math.abs(this.ranSeed.nextInt() % 14);
                                        break;
                                    }
                                    this.ballXDirection = Math.abs(this.ranSeed.nextInt() % 40);
                                    if (this.ballXDirection == 0) {
                                        this.curve = Math.abs(this.ranSeed.nextInt() % 18);
                                        break;
                                    }
                                    this.curve = -this.ballXDirection / 2;
                                    break;
                                }
                                if (this.humanPos >= 4) {
                                    this.ballXDirection = -this.ballXPos / 3 + Math.abs(n8) + this.serviceBallYPos.length;
                                    this.curve = Math.abs(this.ranSeed.nextInt() % 4) * 2;
                                    if (this.stage != 4 || !bl) break;
                                    this.curve = this.ballXDirection / 16;
                                    this.ballXDirection = 0;
                                    break;
                                }
                                this.ballXDirection = (1000 - this.ballXPos) / 3 - Math.abs(n8) - this.serviceBallYPos.length;
                                this.curve = -Math.abs(this.ranSeed.nextInt() % 4) * 2;
                                if (this.stage != 4 || !bl) break;
                                this.curve = this.ballXDirection / 16;
                                this.ballXDirection = 0;
                            }
                        }
                        if (n11 > 5) {
                            int n12 = this.ballXDirection * 4 + this.ballXPos + 16 * this.curve;
                            if (n12 < 0) {
                                if (this.ballXDirection >= 0) {
                                    this.ballXDirection = -this.ballXPos / 3 + this.serviceBallYPos.length;
                                    if (this.stage > 2) {
                                        this.curve = Math.abs(this.ranSeed.nextInt() % 8);
                                    }
                                } else {
                                    this.ballXDirection = -this.ballXPos / 4 + this.serviceBallYPos.length;
                                    if (this.stage > 2) {
                                        this.curve = -Math.abs(this.ranSeed.nextInt() % 8);
                                    }
                                }
                            } else if (n12 > 1000) {
                                if (this.ballXDirection < 0) {
                                    this.ballXDirection = (1000 - this.ballXPos) / 3 - this.serviceBallYPos.length;
                                    if (this.stage > 2) {
                                        this.curve = -Math.abs(this.ranSeed.nextInt() % 8);
                                    }
                                } else {
                                    this.ballXDirection = (1000 - this.ballXPos) / 4 - this.serviceBallYPos.length;
                                    if (this.stage > 2) {
                                        this.curve = Math.abs(this.ranSeed.nextInt() % 8);
                                    }
                                }
                            }
                            if ((n12 = this.ballXDirection * 3 + this.ballXPos + 16 * this.curve) < 0) {
                                this.ballXDirection = -this.ballXPos / 3 + this.serviceBallYPos.length;
                            } else if (n12 > 1000) {
                                this.ballXDirection = (1000 - this.ballXPos) / 3 - this.serviceBallYPos.length;
                            }
                        }
                        this.ballStriked = true;
                    } else {
                        this.bBallMissed = true;
                        this.addPoint();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.bBallMoving) {
            if (!this.bBallHitTable && (this.ballXPos < 0 || this.ballXPos > 1000) && (!this.bRobotStriked && this.ballYPos == 0 || this.bRobotStriked && this.ballYPos == 2000)) {
                this.bBallOut = true;
                this.bBallHitTable = false;
                this.forgive = true;
                this.addPoint();
            } else if (this.ballYPos == 0 && !this.isCloseToRobot()) {
                this.bBallMissed = true;
                this.bBallHitTable = false;
                this.forgive = true;
                this.addPoint();
            } else if (this.ballYPos == 2000 && (!this.isCloseToHuman() || this.bBallMoving && this.ballOldYPos == this.ballYPos)) {
                if (this.forgive) {
                    this.forgive = false;
                } else {
                    this.forgive = true;
                    this.bBallMissed = true;
                    this.bBallHitTable = false;
                    this.addPoint();
                }
            }
        }
        if (this.hLatchedHit == -1) {
            return;
        }
        this.curve = 0;
        n2 = this.hLatchedHit;
        n = this.strikeDirs[n2];
        if (this.bService) {
            if (this.serviceIndex == 0 && this.isCloseToHuman()) {
                this.bRobotStriked = false;
                this.bBallMoving = true;
                this.ballXDirection = n;
                GameModel gameModel = this;
                synchronized (gameModel) {
                    this.ballStriked = true;
                    this.hLatchedHit = -1;
                }
            }
        } else if (this.strikeIndex == this.strikeBallHeights.length - 1 && this.bRobotStriked && this.isCloseToHuman() && Math.abs(this.ranSeed.nextInt() % 100) > this.hMiss[this.hindex][this.humanPos - 1]) {
            this.bRobotStriked = !this.bRobotStriked;
            this.strikeIndex = 0;
            this.bBallHitTable = false;
            this.ballXDirection = n;
            GameModel gameModel = this;
            synchronized (gameModel) {
                this.ballStriked = true;
                this.hLatchedHit = -1;
            }
        }
    }
}

