/*
 * Decompiled with CFR 0.152.
 */
package midppy.pingpong;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStoreException;
import midppy.pingpong.MainMIDlet;
import midppy.pingpong.ManageableScreen;

public class ScoreScreen
extends Canvas
implements ManageableScreen,
Runnable,
CommandListener {
    private final Command cmdMain = new Command("Main", 6, 1);
    private final Command cmdReset = new Command("Clear scores", 6, 2);
    private final int ANIMATION_DELAY;
    private final Object FMT_RANK = new Object();
    private final Object FMT_SCORE = new Object();
    private final Object FMT_PLAYER = new Object();
    private final Object FMT_SPACER = new Object();
    private final Font FONT_RANK = Font.getFont((int)32, (int)1, (int)0);
    private final Font FONT_SCORE = Font.getFont((int)32, (int)1, (int)0);
    private final Font FONT_PLAYER = Font.getFont((int)32, (int)1, (int)0);
    private final Font FONT_TITLE = Font.getFont((int)64, (int)1, (int)16);
    private Object[] script;
    private MainMIDlet midlet;
    private volatile Thread animationThread = null;
    int preferredOffset;
    int offset;
    boolean paused = false;

    public ScoreScreen() {
        this.ANIMATION_DELAY = 100;
    }

    public void initScreen(MainMIDlet mainMIDlet) {
        this.midlet = mainMIDlet;
        this.refresh();
        this.addCommand(this.cmdMain);
        this.addCommand(this.cmdReset);
        this.setCommandListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refresh() {
        Vector<Object> vector = new Vector<Object>(10);
        int n = 0;
        while (n < 10) {
            int n2 = this.midlet.rankingOrders[n];
            vector.addElement(this.FMT_RANK);
            vector.addElement("[" + (n + 1) + "]");
            vector.addElement(this.FMT_SCORE);
            vector.addElement(String.valueOf(this.midlet.rankingScores[n2]));
            vector.addElement(this.FMT_PLAYER);
            vector.addElement(this.midlet.rankingPlayers[n2]);
            ++n;
        }
        this.script = new Object[vector.size()];
        vector.copyInto(this.script);
        this.preferredOffset = -18 * 10;
    }

    public void disposeScreen() {
        this.animationThread = null;
    }

    public void startScreen() {
        this.offset = this.preferredOffset;
        if (this.animationThread == null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public void pauseScreen() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        block8: while (true) {
            try {
                while (thread == this.animationThread) {
                    long l = System.currentTimeMillis();
                    ScoreScreen scoreScreen = this;
                    synchronized (scoreScreen) {
                        if (!this.paused) {
                            this.offset += 4;
                            if (this.offset > 2) {
                                this.offset = 3;
                            }
                            this.repaint();
                        }
                    }
                    this.serviceRepaints();
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 >= 100L) continue;
                    ScoreScreen scoreScreen2 = this;
                    synchronized (scoreScreen2) {
                        this.wait(100L - l2);
                        continue block8;
                    }
                }
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (!this.isShown()) {
            return;
        }
        graphics.setColor(0x6699FF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setClip(0, 24, this.getWidth(), this.getHeight() - 24);
        graphics.translate(0, 24);
        ScoreScreen scoreScreen = this;
        synchronized (scoreScreen) {
            int n = this.offset;
            int n2 = 0;
            while (n2 < this.script.length) {
                if (this.script[n2] == this.FMT_RANK) {
                    graphics.setFont(this.FONT_RANK);
                    MainMIDlet.drawStyledString(graphics, this.script[++n2].toString(), 30, n, 24, 2, 0xFFCC66, 0, 0xFFFFFF);
                } else if (this.script[n2] == this.FMT_SCORE) {
                    graphics.setFont(this.FONT_SCORE);
                    MainMIDlet.drawStyledString(graphics, this.script[++n2].toString(), this.getWidth() - 2, n, 24, 2, 0xFFFF00, 0, 0xFFFFFF);
                } else if (this.script[n2] == this.FMT_PLAYER) {
                    graphics.setFont(this.FONT_PLAYER);
                    MainMIDlet.drawStyledString(graphics, this.script[++n2].toString(), 32, n, 20, 2, 0xFF0000, 0, 0xFFFFFF);
                    n += 17;
                } else if (this.script[n2] == this.FMT_SPACER) {
                    n += 20;
                }
                ++n2;
            }
            graphics.translate(0, -24);
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0xFF0000);
            graphics.drawLine(2, 22, this.getWidth() - 4, 22);
            graphics.setFont(this.FONT_TITLE);
            MainMIDlet.drawStyledString(graphics, "Score Ranking", this.getWidth() >> 1, 3, 17, 1, 0xFF0000, 0, 0xFFFFFF);
            if (this.offset >= 2) {
                this.animationThread = null;
            }
        }
    }

    public void keyPressed(int n) {
        this.paused = !this.paused;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdMain) {
            this.midlet.showScreen(this.midlet.mainScreen);
            this.disposeScreen();
        } else if (command == this.cmdReset) {
            this.pauseScreen();
            try {
                this.midlet.clearScores();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            this.refresh();
            this.startScreen();
        }
    }
}

