/*
 * Decompiled with CFR 0.152.
 */
package org.eaves.pocket;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import org.eaves.pocket.About;
import org.eaves.pocket.Intro;
import org.eaves.pocket.ItemEdit;
import org.eaves.pocket.ItemList;
import org.eaves.pocket.PocketAlert;
import org.eaves.pocket.SlowTask;
import org.eaves.pocket.Unlock;
import org.eaves.pocket.record.InvalidPassphraseException;
import org.eaves.pocket.record.PocketRecord;
import org.eaves.pocket.record.PocketStore;
import org.eaves.pocket.record.PocketStoreException;

public class PocketMidlet
extends MIDlet
implements CommandListener,
RecordListener {
    static final int NO_TASK = 0;
    static final int STORE_TASK = 1;
    static final int DECRYPT_TASK = 2;
    private final String NULL_VERSION;
    private final int NEW_RECORD;
    private final String STORE_NAME;
    private Display _display = Display.getDisplay((MIDlet)this);
    private Intro _intro = null;
    private About _about = null;
    private ItemList _items = null;
    private ItemEdit _edit = null;
    private Unlock _unlock = null;
    private PocketAlert _error = null;
    private Form _slowMsg;
    private int _currentSlowTask;
    private StringItem _decryptMsg;
    private StringItem _storeMsg;
    private String _version = null;
    private PocketStore _store = null;
    private boolean _dirtyStore = false;
    private boolean _storeExists = false;
    private String _passphrase = null;

    public PocketMidlet() {
        this.NULL_VERSION = "(null)";
        this.NEW_RECORD = -10;
        this.STORE_NAME = "Pocket.Store";
        try {
            this._version = this.getAppProperty("MIDlet-Version");
        }
        catch (NullPointerException nullPointerException) {
            this._version = "(null)";
        }
        if (this._version == null) {
            this._version = "(null)";
        }
        try {
            this._storeExists = PocketStore.exists("Pocket.Store");
        }
        catch (PocketStoreException pocketStoreException) {
            this.displayError(1, pocketStoreException.getMessage());
        }
        this._slowMsg = new Form("Please wait");
        this._decryptMsg = new StringItem(null, "Decrypting database ...");
        this._storeMsg = new StringItem(null, "Opening database ...\nPreparing key ...\nCreating cipher ...\nPlease wait.");
        this._slowMsg.append((Item)this._storeMsg);
        System.gc();
    }

    private void displayIntroScreen() {
        if (this._intro == null) {
            this._intro = new Intro();
        }
        this._intro.setCommandListener(this);
        this._display.setCurrent((Displayable)this._intro);
        System.gc();
    }

    private void displayAboutScreen() {
        if (this._about == null) {
            this._about = new About(this._version);
        }
        this._about.setCommandListener(this);
        this._display.setCurrent((Displayable)this._about);
        System.gc();
    }

    private void displayError(int n, String string) {
        if (this._error == null) {
            this._error = new PocketAlert(n, string);
        }
        this._error.setCommandListener(this);
        this._display.setCurrent((Displayable)this._error);
        System.gc();
    }

    private void displayItemListScreen() {
        this._intro = null;
        this._about = null;
        System.gc();
        if (this._passphrase == null) {
            this.displayUnlockScreen();
            return;
        }
        if (this._store == null) {
            this.setTask(1);
        } else if (this._dirtyStore || this._items == null) {
            this.setTask(2);
        } else {
            this.decryptionFinished();
        }
    }

    public void setTask(int n) {
        this._currentSlowTask = n;
        if (n == 2) {
            this._slowMsg.delete(0);
            this._slowMsg.append((Item)this._decryptMsg);
        } else if (n == 1) {
            this._slowMsg.delete(0);
            this._slowMsg.append((Item)this._storeMsg);
        } else {
            this._currentSlowTask = 0;
        }
        if (this._currentSlowTask != 0) {
            this._display.setCurrent((Displayable)this._slowMsg);
        }
        new SlowTask(this);
    }

    public int taskToDo() {
        return this._currentSlowTask;
    }

    public boolean storeOpen() {
        try {
            this._items = null;
            this._store = new PocketStore("Pocket.Store");
            this._store.open();
        }
        catch (PocketStoreException pocketStoreException) {
            this.displayError(1, pocketStoreException.getMessage());
            return false;
        }
        this._store.setPassphrase(this._passphrase);
        this._passphrase = "*set*";
        this._store.listener(this);
        return true;
    }

    public void openFinished() {
        int n = this._store.count();
        if (this._items == null) {
            this._items = new ItemList();
            if (n > 0) {
                this.setTask(2);
            }
        } else if (this._dirtyStore && n > 0) {
            this.setTask(2);
        }
        if (n > 0) {
            this._display.setCurrent((Displayable)this._slowMsg);
        } else {
            this.decryptionFinished();
        }
        System.gc();
    }

    public boolean itemsReload() {
        if (this._items == null) {
            this._items = new ItemList();
        }
        if (this._store.count() == 0) {
            return true;
        }
        try {
            this._items.reload(this._store);
        }
        catch (InvalidPassphraseException invalidPassphraseException) {
            this._store = null;
            this.displayError(100, invalidPassphraseException.getMessage());
            return false;
        }
        catch (PocketStoreException pocketStoreException) {
            this._store = null;
            this.displayError(6, pocketStoreException.getMessage());
            return false;
        }
        this._dirtyStore = false;
        System.gc();
        return true;
    }

    public void decryptionFinished() {
        this._items.setCommandListener(this);
        this._display.setCurrent((Displayable)this._items);
        System.gc();
    }

    private void displayUnlockScreen() {
        String string = "Enter your passphrase to unlock the storage";
        if (!this._storeExists) {
            string = "Enter a passphrase.  This will be used to secure the storage.  Make sure it is secret, and that you can remember it.";
        }
        if (this._unlock == null) {
            this._unlock = new Unlock(string);
        }
        this._unlock.setCommandListener(this);
        this._display.setCurrent((Displayable)this._unlock);
    }

    private void displayItemEditScreen(int n) {
        if (n == -1) {
            return;
        }
        PocketRecord pocketRecord = null;
        try {
            pocketRecord = this._store.getRecord(n);
        }
        catch (PocketStoreException pocketStoreException) {
            this.displayError(2, pocketStoreException.getMessage());
            return;
        }
        if (this._edit == null) {
            this._edit = new ItemEdit(pocketRecord);
        } else {
            this._edit.reload(pocketRecord);
        }
        this._edit.setCommandListener(this);
        this._display.setCurrent((Displayable)this._edit);
        System.gc();
    }

    private void deleteItem(int n) {
        if (n < 0) {
            return;
        }
        try {
            this._store.removeRecord(n);
            this._dirtyStore = true;
        }
        catch (PocketStoreException pocketStoreException) {
            this.displayError(3, pocketStoreException.getMessage());
            return;
        }
        this.displayItemListScreen();
    }

    public void commandAction(Command command, Displayable displayable) {
        PocketRecord pocketRecord;
        if (displayable == this._intro) {
            if (command == this._intro.getUseCommand()) {
                this.displayItemListScreen();
            } else if (command == this._intro.getAboutCommand()) {
                this.displayAboutScreen();
            }
            return;
        }
        if (displayable == this._about) {
            if (command == this._about.getUseCommand()) {
                this.displayItemListScreen();
            } else if (command == this._about.getExitCommand()) {
                this.exit();
            }
            return;
        }
        if (displayable == this._unlock) {
            if (command == this._unlock.getExitCommand()) {
                this.exit();
            }
            if (command == this._unlock.getOKCommand()) {
                this._passphrase = this._unlock.getToken();
                this._unlock.clearToken();
                if (this._passphrase.length() == 0) {
                    this._passphrase = null;
                    pocketRecord = new Alert("Blank Passphrase", "Entering a blank passphrase is not permitted", null, AlertType.ERROR);
                    pocketRecord.setTimeout(-2);
                    this._display.setCurrent((Alert)pocketRecord, (Displayable)this._unlock);
                } else {
                    this.displayItemListScreen();
                }
            }
        }
        if (displayable == this._items) {
            if (command == this._items.getNewCommand()) {
                this.displayItemEditScreen(-10);
            } else if (command == this._items.getOpenCommand() || command == List.SELECT_COMMAND) {
                int n = this._items.selected();
                this.displayItemEditScreen(n);
            } else if (command == this._items.getDeleteCommand()) {
                int n = this._items.selected();
                this.deleteItem(n);
            } else if (command == this._items.getExitCommand()) {
                this.exit();
            }
            return;
        }
        if (displayable == this._edit) {
            if (command == this._edit.getSaveCommand() && (pocketRecord = this._edit.getRecord()) != null) {
                if (pocketRecord.isBlank()) {
                    pocketRecord.setName("*blank*");
                }
                try {
                    this._store.saveRecord(pocketRecord);
                }
                catch (PocketStoreException pocketStoreException) {
                    this.displayError(7, pocketStoreException.getMessage());
                    return;
                }
            }
            this.displayItemListScreen();
            return;
        }
        if (displayable == this._error) {
            if (command == this._error.getExitCommand()) {
                this.exit();
            }
            if (command == this._error.getOKCommand()) {
                this.displayUnlockScreen();
            }
            return;
        }
    }

    protected void startApp() {
        if (!this._storeExists) {
            this.displayIntroScreen();
        } else {
            this.displayUnlockScreen();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pauseApp() {
        try {
            if (this._store != null) {
                this._store.close();
            }
            this._store = null;
            this._items = null;
            this._passphrase = null;
            return;
        }
        catch (PocketStoreException pocketStoreException) {
            this.displayError(5, pocketStoreException.getMessage());
            return;
        }
    }

    protected void destroyApp(boolean bl) {
        if (this._store != null) {
            try {
                this._store.close();
            }
            catch (PocketStoreException pocketStoreException) {
                this.displayError(4, pocketStoreException.getMessage());
                return;
            }
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void recordAdded(RecordStore recordStore, int n) {
        this._items = null;
    }

    public void recordChanged(RecordStore recordStore, int n) {
        this._items = null;
    }

    public void recordDeleted(RecordStore recordStore, int n) {
        this._items = null;
    }
}

