/*
 * Decompiled with CFR 0.152.
 */
package org.eaves.pocket.record;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.java.security.SecureRandom;
import org.eaves.pocket.record.InvalidPassphraseException;
import org.eaves.pocket.record.ObjectInputStream;
import org.eaves.pocket.record.PocketInputStream;
import org.eaves.pocket.record.PocketOutputStream;
import org.eaves.pocket.record.PocketRecord;
import org.eaves.pocket.record.PocketStoreException;

public class PocketStore {
    private static int KEY_SIZE = 128;
    private static String UNKNOWN_ERROR = "Error opening record store";
    private static String FULL_ERROR = "Full error opening record store";
    private static String NOTFND_ERROR = "Record store not found";
    private static String PASS_ERROR = "Passphrase not set on open";
    private static String ENCRYPT_ERROR = "Error during encryption";
    private static String DECRYPT_ERROR = "Invalid passphrase";
    private String _name = null;
    private boolean _open = false;
    private RecordStore _store = null;
    private CipherParameters _passphrase = null;
    private BufferedBlockCipher _cipher = null;
    private SHA1Digest _digest = null;
    private int _digestSize;
    private byte[] _digestResult;
    private SecureRandom _random;

    public PocketStore(String string) {
        this._name = string;
        this._cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()));
        this._digest = new SHA1Digest();
        this._digestSize = this._digest.getDigestSize();
        this._digestResult = new byte[this._digestSize];
    }

    public void listener(RecordListener recordListener) {
        this._store.addRecordListener(recordListener);
    }

    public void setPassphrase(String string) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(string.toCharArray()), null, 32);
        this._passphrase = ((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(KEY_SIZE);
    }

    public static boolean exists(String string) throws PocketStoreException {
        boolean bl = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            bl = true;
        }
        catch (RecordStoreException recordStoreException) {
            throw new PocketStoreException(recordStoreException.getMessage());
        }
        return bl;
    }

    public void open() throws PocketStoreException {
        if (!this._open) {
            try {
                this._store = RecordStore.openRecordStore((String)this._name, (boolean)true);
            }
            catch (RecordStoreFullException recordStoreFullException) {
                String string = recordStoreFullException.getMessage();
                if (string == null) {
                    string = FULL_ERROR;
                }
                throw new PocketStoreException(string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                throw new PocketStoreException(NOTFND_ERROR);
            }
            catch (RecordStoreException recordStoreException) {
                String string = recordStoreException.getMessage();
                if (string == null) {
                    string = UNKNOWN_ERROR;
                }
                throw new PocketStoreException(string);
            }
        }
        this._open = true;
    }

    public void close() throws PocketStoreException {
        if (this._open) {
            try {
                this._store.closeRecordStore();
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException) {
                String string = recordStoreException.getMessage();
                if (string == null) {
                    string = UNKNOWN_ERROR;
                }
                throw new PocketStoreException(string);
            }
        }
        this._open = false;
    }

    public int count() {
        int n;
        try {
            n = this._store.getNumRecords();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            n = -1;
        }
        return n;
    }

    public void removeRecord(int n) throws PocketStoreException {
        if (n < 0) {
            return;
        }
        if (!this._open) {
            this.open();
        }
        try {
            this._store.deleteRecord(n);
        }
        catch (RecordStoreException recordStoreException) {
            throw new PocketStoreException(recordStoreException.getMessage());
        }
    }

    public PocketRecord getRecord(int n) throws PocketStoreException {
        Object object;
        PocketRecord pocketRecord = null;
        if (this._passphrase == null) {
            throw new PocketStoreException(PASS_ERROR);
        }
        if (n < 0) {
            return pocketRecord;
        }
        if (!this._open) {
            this.open();
        }
        byte[] byArray = null;
        try {
            object = this._store.getRecord(n);
            byArray = this.decrypt((byte[])object);
        }
        catch (RecordStoreException recordStoreException) {
            throw new PocketStoreException(recordStoreException.getMessage());
        }
        object = new PocketInputStream(new DataInputStream(new ByteArrayInputStream(byArray)));
        try {
            pocketRecord = (PocketRecord)((ObjectInputStream)object).readObject();
        }
        catch (IOException iOException) {
            throw new PocketStoreException(DECRYPT_ERROR);
        }
        pocketRecord.setRID(n);
        if (pocketRecord.isBlank()) {
            pocketRecord.setName("*blank*");
        }
        return pocketRecord;
    }

    public Vector getRecords() throws PocketStoreException {
        int n;
        if (!this._open) {
            this.open();
        }
        if ((n = this.count()) < 1) {
            return null;
        }
        Vector vector = new Vector(n);
        try {
            RecordEnumeration recordEnumeration = this._store.enumerateRecords(null, null, false);
            PocketRecord pocketRecord = null;
            int n2 = 0;
            while (recordEnumeration.hasNextElement()) {
                n2 = recordEnumeration.nextRecordId();
                pocketRecord = this.getRecord(n2);
                this.insertSortedElement(vector, pocketRecord);
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            throw new PocketStoreException(recordStoreException.getMessage());
        }
        return vector;
    }

    private void insertSortedElement(Vector vector, PocketRecord pocketRecord) {
        int n = vector.size();
        if (n == 0) {
            vector.addElement(pocketRecord);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            PocketRecord pocketRecord2 = (PocketRecord)vector.elementAt(n2);
            if (pocketRecord2.compareTo(pocketRecord) >= 0) {
                vector.insertElementAt(pocketRecord, n2);
                return;
            }
            ++n2;
        }
        vector.addElement(pocketRecord);
    }

    public void saveRecord(PocketRecord pocketRecord) throws PocketStoreException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PocketOutputStream pocketOutputStream = new PocketOutputStream(new DataOutputStream(byteArrayOutputStream));
            try {
                pocketOutputStream.writeObject(pocketRecord);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = this.encrypt(byArray);
            if (pocketRecord.getRID() < 0) {
                this._store.addRecord(byArray2, 0, byArray2.length);
            } else {
                this._store.setRecord(pocketRecord.getRID(), byArray2, 0, byArray2.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            throw new PocketStoreException(recordStoreException.getMessage());
        }
    }

    private byte[] encrypt(byte[] byArray) throws PocketStoreException {
        this._cipher.init(true, this._passphrase);
        int n = this._cipher.getOutputSize(4 + this._digestSize + byArray.length);
        byte[] byArray2 = new byte[n];
        if (this._random == null) {
            this._random = new SecureRandom();
        }
        byte[] byArray3 = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray3[n2] = (byte)(this._random.nextInt() & 0xFF);
            ++n2;
        }
        int n3 = this._cipher.processBytes(byArray3, 0, 4, byArray2, 0);
        this._digest.reset();
        this._digest.update(byArray3, 0, 4);
        this._digest.update(byArray, 0, byArray.length);
        this._digest.doFinal(this._digestResult, 0);
        n3 += this._cipher.processBytes(this._digestResult, 0, this._digestSize, byArray2, n3);
        n3 += this._cipher.processBytes(byArray, 0, byArray.length, byArray2, n3);
        try {
            this._cipher.doFinal(byArray2, n3);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            invalidCipherTextException.printStackTrace();
            throw new PocketStoreException(ENCRYPT_ERROR);
        }
        return byArray2;
    }

    private byte[] decrypt(byte[] byArray) throws PocketStoreException {
        this._cipher.init(false, this._passphrase);
        byte[] byArray2 = new byte[this._cipher.getOutputSize(byArray.length)];
        int n = this._cipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        try {
            n += this._cipher.doFinal(byArray2, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidPassphraseException(DECRYPT_ERROR);
        }
        int n2 = 4 + this._digestSize;
        int n3 = n - n2;
        byte[] byArray3 = new byte[4];
        System.arraycopy(byArray2, 0, byArray3, 0, 4);
        byte[] byArray4 = new byte[this._digestSize];
        System.arraycopy(byArray2, 4, byArray4, 0, this._digestSize);
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray2, n2, byArray5, 0, n3);
        this._digest.reset();
        this._digest.update(byArray3, 0, 4);
        this._digest.update(byArray5, 0, byArray5.length);
        this._digest.doFinal(this._digestResult, 0);
        if (!this.compareDigest(byArray4, this._digestResult)) {
            throw new InvalidPassphraseException(DECRYPT_ERROR);
        }
        return byArray5;
    }

    public boolean compareDigest(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return this._name;
    }
}

